/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.preference;

import org.simantics.trend.configuration.LineQuality;
import org.simantics.trend.configuration.TimeFormat;
import org.simantics.trend.configuration.TrendItem.DrawMode;
import org.simantics.trend.configuration.YAxisMode;

/**
 * @author Toni Kalajainen
 */
public class ChartPreferences {
	
	public static final String P_NODE						 = "org.simantics.charts";					//$NON-NLS-1$

	// Time series editor
    public static final String P_REDRAW_INTERVAL             = "chart.redraw_interval";         		//$NON-NLS-1$
    public static final String P_AUTOSCALE_INTERVAL          = "chart.autoscale_interval";         		//$NON-NLS-1$
    public static final String P_DRAW_SAMPLES                = "chart.draw_samples";             		//$NON-NLS-1$
    public static final String P_ITEMPLACEMENT               = "chart.item_placement";         			//$NON-NLS-1$    

    // Chart
    public static final String P_TIMEWINDOW_TEMPLATE         = "chart.default_timewindowtemplate";     //$NON-NLS-1$
    public static final String P_AXISMODE                    = "chart.axismode";                       //$NON-NLS-1$
    public static final String P_TIMEFORMAT                  = "chart.timeformat";                     //$NON-NLS-1$
    public static final String P_VALUEFORMAT                 = "chart.valueformat";                    //$NON-NLS-1$
    public static final String P_LINEQUALITY                 = "chart.linequality";                    //$NON-NLS-1$
    public static final String P_TEXTQUALITY                 = "chart.textquality";                    //$NON-NLS-1$

    // Chart Item
    public static final String P_DRAWMODE                    = "chart.drawmode";                       //$NON-NLS-1$
    public static final String P_SCALEMODE                   = "chart.scalemode";                      //$NON-NLS-1$
    public static final String P_SCALE_MIN                   = "chart.scale.min";                      //$NON-NLS-1$
    public static final String P_SCALE_MAX                   = "chart.scale.max";                      //$NON-NLS-1$

    /**
     * Default chart data view update interval in milliseconds. Default value is
     * {@value #DEFAULT_REDRAW_INTERVAL}.
     */
    public static final Long   DEFAULT_REDRAW_INTERVAL       = 330L;
    public static final Long   DEFAULT_AUTOSCALE_INTERVAL    = 330L;
    public static final Boolean   DEFAULT_DRAW_SAMPLES       = false;
    public static final String DEFAULT_ITEMPLACEMENT         = "Overlapping";

    public static final String DEFAULT_TIMEWINDOW_TEMPLATE   = ChartTimeWindowTemplate.WholeHistory.id;
    public static final String DEFAULT_AXISMODE              = YAxisMode.MultiAxis.name();
    public static final String DEFAULT_TIMEFORMAT            = TimeFormat.Time.name();
    public static final String DEFAULT_VALUEFORMAT           = "Default";

    public static final String DEFAULT_DRAWMODE              = DrawMode.Line.name();
    public static final String DEFAULT_SCALEMODE             = "Auto"; 

    public static final String DEFAULT_LINEQUALITY           = LineQuality.Normal.name();
    public static final String DEFAULT_TEXTQUALITY           = LineQuality.Normal.name();
    
}
