/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.function;

import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.ui.ChartItemLabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.subscription.SubscriptionItemLabel;
import org.simantics.scl.reflection.annotations.SCLValue;

/**
 * @author Tuukka Lehtonen
 */
public class Labels {

    @SCLValue(type = "ReadGraph -> Resource -> a -> String")
    public static String chartItemLabel(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        if (context instanceof Resource) {
            return ChartItemLabelRule.INSTANCE.getLabel_(graph, (Resource) context);
        } else if (context instanceof Variable) {
        	Variable var = (Variable)context;
        	Resource r = var.getParent(graph).getPossibleRepresents(graph);
        	if(r == null) return "";
            return ChartItemLabelRule.INSTANCE.getLabel_(graph, r);
        } else {
            throw new DatabaseException("Unknown context " + context);
        }
    }

    @SCLValue(type = "ReadGraph -> Resource -> a -> String")
    public static String chartItemSubscriptionInfo(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        Resource chartItem = null;
        if (context instanceof Resource) {
            chartItem = (Resource) context;
        } else if (context instanceof Variable) {
            Variable var = (Variable) context;
            chartItem = var.getParent(graph).getPossibleRepresents(graph);
        } else {
            throw new DatabaseException("Unknown context " + context);
        }
        if (chartItem == null)
            return "";

        ChartResource CHART = ChartResource.getInstance(graph);
        Resource subscriptionItem = graph.getPossibleObject(chartItem, CHART.Chart_Item_HasSubscriptionItem);
        if (subscriptionItem == null)
            return "Not bound to a subscription item";

        String itemLabel = SubscriptionItemLabel.resolveLabel(graph, subscriptionItem, null, false, false, false);

        Layer0 L0 = Layer0.getInstance(graph);
        Resource subscription = graph.getPossibleObject(subscriptionItem, L0.PartOf);
        if (subscription != null) {
            String subscriptionLabel = graph.getPossibleRelatedValue2(subscription, L0.HasLabel, Bindings.STRING);
            if (subscriptionLabel != null) {
                return itemLabel + " in subscription " + subscriptionLabel;
            }
        }

        return itemLabel;
    }

}