package org.simantics.charts.editor;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.ui.ChartDoubleClickHandler;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.ui.SimanticsUI;

/**
 * @author Tuukka Lehtonen
 */
public class PropertiesAction extends Action {

    private Control  control;
    private Resource component;

    public PropertiesAction(String name, Control control, Resource component) {
        super(name);
        this.control = control;
        this.component = component;
    }

    @Override
    public void run() {
        final Shell shell = control.getShell();
        SimanticsUI.getSession().asyncRequest(new Read<Object>() {
			@Override
			public Object perform(ReadGraph graph) throws DatabaseException {
				ChartResource CHART = ChartResource.getInstance(graph);
				if ( graph.isInstanceOf(component, CHART.Chart_Item) ) {
					ChartDoubleClickHandler.openChartItemPropertiesDialog(graph, component, shell.getDisplay());
				} else
				if ( graph.isInstanceOf(component, CHART.Chart) ) {
					ChartDoubleClickHandler.openChartPropertiesDialog(graph, component, shell.getDisplay());
				} 
				return null;
			}});
    }

}