/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.charts.Activator;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;

/**
 * @author Toni Kalajainen
 */
public class ChartEditorAdapter extends AbstractResourceEditorAdapter {

    public static ImageDescriptor CHART_ICON = ImageDescriptor.createFromURL(Activator.getDefault().getBundle()
                                                     .getResource("icons/silk/chart_line.png")); ;

    public ChartEditorAdapter() {
        super("Chart Viewer", CHART_ICON);
    }

    @Override
    public boolean canHandle(ReadGraph graph, Object input) throws DatabaseException {
        Resource r = ResourceAdaptionUtils.toSingleResource(input);
        if (r == null)
            return false;

        ChartResource wr = ChartResource.getInstance(graph);
        if (wr.TimeSeriesChart == null)
            return false;
        return graph.isInstanceOf(r, wr.TimeSeriesChart);
    }

    @Override
    public void openEditor(Resource input) throws Exception {
        if (!SimanticsUI.getSession().syncRequest(Queries.isInstanceOf(input, ChartResource.URIs.TimeSeriesChart)))
            return;
        //E4WorkbenchUtils.openEditor(TimeSeriesEditor.ID, TimeSeriesEditor.CONTRIBUTION_URI, null, input);
        openEditorWithId(TimeSeriesEditor.ID, new ResourceEditorInput(TimeSeriesEditor.ID, input));
    }

}
