package org.simantics.charts.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class ChartResource {
    
    public final Resource Chart;
    public final Resource ChartActionContext;
    public final Resource ChartActionContext_Actions;
    public final Resource ChartActionContext_Actions_ChartDropAction;
    public final Resource ChartActionContext_Actions_ChartGroupDropAction;
    public final Resource ChartActionContext_Actions_ChartItemDropAction;
    public final Resource ChartActionContext_Actions_NewChart;
    public final Resource ChartActionContext_Actions_NewChartGroup;
    public final Resource ChartBrowseContext;
    public final Resource ChartBrowseContext_ChartItemLabelDecorationRule;
    public final Resource ChartBrowseContext_ChartItemLabelRule;
    public final Resource ChartBrowseContext_ChartItemNameModifierRule;
    public final Resource ChartBrowseContext_ChartSorterRule;
    public final Resource ChartBrowseContext_ChartsFolder;
    public final Resource ChartBrowseContext_Images;
    public final Resource ChartBrowseContext_Images_Chart;
    public final Resource ChartBrowseContext_Images_ChartGroup;
    public final Resource ChartBrowseContext_Images_ChartItemImage;
    public final Resource ChartBrowseContext_Images_ChartsFolder;
    public final Resource ChartBrowseContext_Images_Plot;
    public final Resource ChartGroup;
    public final Resource ChartTemplate;
    public final Resource Chart_Item;
    public final Resource Chart_Item_DrawMode;
    public final Resource Chart_Item_HasChartItem;
    public final Resource Chart_Item_HasSubscriptionItem;
    public final Resource Chart_Item_Index;
    public final Resource Chart_Item_Index_Inverse;
    public final Resource Chart_Item_Renderer;
    public final Resource Chart_Item_ScaleMode;
    public final Resource Chart_Item_ScaleMode_Max;
    public final Resource Chart_Item_ScaleMode_Max_Inverse;
    public final Resource Chart_Item_ScaleMode_Min;
    public final Resource Chart_Item_ScaleMode_Min_Inverse;
    public final Resource Chart_Item_hidden;
    public final Resource Chart_Item_hidden_Inverse;
    public final Resource Chart_Item_subscriptionInfo;
    public final Resource Chart_Item_subscriptionInfo_Inverse;
    public final Resource Chart_ShowMilestones;
    public final Resource Chart_ShowMilestones_Inverse;
    public final Resource Chart_TimeWindowIncrement;
    public final Resource Chart_TimeWindowIncrement_Inverse;
    public final Resource Chart_TimeWindowLength;
    public final Resource Chart_TimeWindowLength_Inverse;
    public final Resource Chart_TimeWindowStart;
    public final Resource Chart_TimeWindowStart_Inverse;
    public final Resource Chart_YAxisMode;
    public final Resource Chart_backgroundColor;
    public final Resource Chart_backgroundColor_Inverse;
    public final Resource Chart_gridColor;
    public final Resource Chart_gridColor_Inverse;
    public final Resource Chart_showGrid;
    public final Resource Chart_showGrid_Inverse;
    public final Resource Chart_trackExperimentTime;
    public final Resource Chart_trackExperimentTime_Inverse;
    public final Resource Chart_valueViewPosition;
    public final Resource Chart_valueViewPosition_Inverse;
    public final Resource Contributions;
    public final Resource Contributions_Charts;
    public final Resource Contributions_NewChart;
    public final Resource DrawMode;
    public final Resource DrawMode_Average;
    public final Resource DrawMode_Deviation;
    public final Resource DrawMode_DeviationAndAverage;
    public final Resource DrawMode_DeviationAndLine;
    public final Resource DrawMode_DeviationAndSample;
    public final Resource DrawMode_Line;
    public final Resource DrawMode_Sample;
    public final Resource Functions;
    public final Resource Functions_chartItemLabel;
    public final Resource Functions_chartItemSubscriptionInfo;
    public final Resource HasColor;
    public final Resource HasColor_Inverse;
    public final Resource HasDefaultChartTemplate;
    public final Resource HasDefaultChartTemplate_Inverse;
    public final Resource Last10MinutesChartTemplate;
    public final Resource Last60SecondsChartTemplate;
    public final Resource ObtainedDouble;
    public final Resource Renderer;
    public final Resource Renderer_Analog;
    public final Resource Renderer_Binary;
    public final Resource ScaleMode;
    public final Resource ScaleMode_AutoScale;
    public final Resource ScaleMode_ManualScale;
    public final Resource TimeSeriesChart;
    public final Resource WholeHistoryChartTemplate;
    public final Resource YAxisMode;
    public final Resource YAxisMode_MultiAxis;
    public final Resource YAxisMode_SingleAxis;
        
    public static class URIs {
        public static final String Chart = "http://www.simantics.org/Charts-1.2/Chart";
        public static final String ChartActionContext = "http://www.simantics.org/Charts-1.2/ChartActionContext";
        public static final String ChartActionContext_Actions = "http://www.simantics.org/Charts-1.2/ChartActionContext/Actions";
        public static final String ChartActionContext_Actions_ChartDropAction = "http://www.simantics.org/Charts-1.2/ChartActionContext/Actions/ChartDropAction";
        public static final String ChartActionContext_Actions_ChartGroupDropAction = "http://www.simantics.org/Charts-1.2/ChartActionContext/Actions/ChartGroupDropAction";
        public static final String ChartActionContext_Actions_ChartItemDropAction = "http://www.simantics.org/Charts-1.2/ChartActionContext/Actions/ChartItemDropAction";
        public static final String ChartActionContext_Actions_NewChart = "http://www.simantics.org/Charts-1.2/ChartActionContext/Actions/NewChart";
        public static final String ChartActionContext_Actions_NewChartGroup = "http://www.simantics.org/Charts-1.2/ChartActionContext/Actions/NewChartGroup";
        public static final String ChartBrowseContext = "http://www.simantics.org/Charts-1.2/ChartBrowseContext";
        public static final String ChartBrowseContext_ChartItemLabelDecorationRule = "http://www.simantics.org/Charts-1.2/ChartBrowseContext/ChartItemLabelDecorationRule";
        public static final String ChartBrowseContext_ChartItemLabelRule = "http://www.simantics.org/Charts-1.2/ChartBrowseContext/ChartItemLabelRule";
        public static final String ChartBrowseContext_ChartItemNameModifierRule = "http://www.simantics.org/Charts-1.2/ChartBrowseContext/ChartItemNameModifierRule";
        public static final String ChartBrowseContext_ChartSorterRule = "http://www.simantics.org/Charts-1.2/ChartBrowseContext/ChartSorterRule";
        public static final String ChartBrowseContext_ChartsFolder = "http://www.simantics.org/Charts-1.2/ChartBrowseContext/ChartsFolder";
        public static final String ChartBrowseContext_Images = "http://www.simantics.org/Charts-1.2/ChartBrowseContext/Images";
        public static final String ChartBrowseContext_Images_Chart = "http://www.simantics.org/Charts-1.2/ChartBrowseContext/Images/Chart";
        public static final String ChartBrowseContext_Images_ChartGroup = "http://www.simantics.org/Charts-1.2/ChartBrowseContext/Images/ChartGroup";
        public static final String ChartBrowseContext_Images_ChartItemImage = "http://www.simantics.org/Charts-1.2/ChartBrowseContext/Images/ChartItemImage";
        public static final String ChartBrowseContext_Images_ChartsFolder = "http://www.simantics.org/Charts-1.2/ChartBrowseContext/Images/ChartsFolder";
        public static final String ChartBrowseContext_Images_Plot = "http://www.simantics.org/Charts-1.2/ChartBrowseContext/Images/Plot";
        public static final String ChartGroup = "http://www.simantics.org/Charts-1.2/ChartGroup";
        public static final String ChartTemplate = "http://www.simantics.org/Charts-1.2/ChartTemplate";
        public static final String Chart_Item = "http://www.simantics.org/Charts-1.2/Chart/Item";
        public static final String Chart_Item_DrawMode = "http://www.simantics.org/Charts-1.2/Chart/Item/DrawMode";
        public static final String Chart_Item_HasChartItem = "http://www.simantics.org/Charts-1.2/Chart/Item/HasChartItem";
        public static final String Chart_Item_HasSubscriptionItem = "http://www.simantics.org/Charts-1.2/Chart/Item/HasSubscriptionItem";
        public static final String Chart_Item_Index = "http://www.simantics.org/Charts-1.2/Chart/Item/Index";
        public static final String Chart_Item_Index_Inverse = "http://www.simantics.org/Charts-1.2/Chart/Item/Index/Inverse";
        public static final String Chart_Item_Renderer = "http://www.simantics.org/Charts-1.2/Chart/Item/Renderer";
        public static final String Chart_Item_ScaleMode = "http://www.simantics.org/Charts-1.2/Chart/Item/ScaleMode";
        public static final String Chart_Item_ScaleMode_Max = "http://www.simantics.org/Charts-1.2/Chart/Item/ScaleMode/Max";
        public static final String Chart_Item_ScaleMode_Max_Inverse = "http://www.simantics.org/Charts-1.2/Chart/Item/ScaleMode/Max/Inverse";
        public static final String Chart_Item_ScaleMode_Min = "http://www.simantics.org/Charts-1.2/Chart/Item/ScaleMode/Min";
        public static final String Chart_Item_ScaleMode_Min_Inverse = "http://www.simantics.org/Charts-1.2/Chart/Item/ScaleMode/Min/Inverse";
        public static final String Chart_Item_hidden = "http://www.simantics.org/Charts-1.2/Chart/Item/hidden";
        public static final String Chart_Item_hidden_Inverse = "http://www.simantics.org/Charts-1.2/Chart/Item/hidden/Inverse";
        public static final String Chart_Item_subscriptionInfo = "http://www.simantics.org/Charts-1.2/Chart/Item/subscriptionInfo";
        public static final String Chart_Item_subscriptionInfo_Inverse = "http://www.simantics.org/Charts-1.2/Chart/Item/subscriptionInfo/Inverse";
        public static final String Chart_ShowMilestones = "http://www.simantics.org/Charts-1.2/Chart/ShowMilestones";
        public static final String Chart_ShowMilestones_Inverse = "http://www.simantics.org/Charts-1.2/Chart/ShowMilestones/Inverse";
        public static final String Chart_TimeWindowIncrement = "http://www.simantics.org/Charts-1.2/Chart/TimeWindowIncrement";
        public static final String Chart_TimeWindowIncrement_Inverse = "http://www.simantics.org/Charts-1.2/Chart/TimeWindowIncrement/Inverse";
        public static final String Chart_TimeWindowLength = "http://www.simantics.org/Charts-1.2/Chart/TimeWindowLength";
        public static final String Chart_TimeWindowLength_Inverse = "http://www.simantics.org/Charts-1.2/Chart/TimeWindowLength/Inverse";
        public static final String Chart_TimeWindowStart = "http://www.simantics.org/Charts-1.2/Chart/TimeWindowStart";
        public static final String Chart_TimeWindowStart_Inverse = "http://www.simantics.org/Charts-1.2/Chart/TimeWindowStart/Inverse";
        public static final String Chart_YAxisMode = "http://www.simantics.org/Charts-1.2/Chart/YAxisMode";
        public static final String Chart_backgroundColor = "http://www.simantics.org/Charts-1.2/Chart/backgroundColor";
        public static final String Chart_backgroundColor_Inverse = "http://www.simantics.org/Charts-1.2/Chart/backgroundColor/Inverse";
        public static final String Chart_gridColor = "http://www.simantics.org/Charts-1.2/Chart/gridColor";
        public static final String Chart_gridColor_Inverse = "http://www.simantics.org/Charts-1.2/Chart/gridColor/Inverse";
        public static final String Chart_showGrid = "http://www.simantics.org/Charts-1.2/Chart/showGrid";
        public static final String Chart_showGrid_Inverse = "http://www.simantics.org/Charts-1.2/Chart/showGrid/Inverse";
        public static final String Chart_trackExperimentTime = "http://www.simantics.org/Charts-1.2/Chart/trackExperimentTime";
        public static final String Chart_trackExperimentTime_Inverse = "http://www.simantics.org/Charts-1.2/Chart/trackExperimentTime/Inverse";
        public static final String Chart_valueViewPosition = "http://www.simantics.org/Charts-1.2/Chart/valueViewPosition";
        public static final String Chart_valueViewPosition_Inverse = "http://www.simantics.org/Charts-1.2/Chart/valueViewPosition/Inverse";
        public static final String Contributions = "http://www.simantics.org/Charts-1.2/Contributions";
        public static final String Contributions_Charts = "http://www.simantics.org/Charts-1.2/Contributions/Charts";
        public static final String Contributions_NewChart = "http://www.simantics.org/Charts-1.2/Contributions/NewChart";
        public static final String DrawMode = "http://www.simantics.org/Charts-1.2/DrawMode";
        public static final String DrawMode_Average = "http://www.simantics.org/Charts-1.2/DrawMode/Average";
        public static final String DrawMode_Deviation = "http://www.simantics.org/Charts-1.2/DrawMode/Deviation";
        public static final String DrawMode_DeviationAndAverage = "http://www.simantics.org/Charts-1.2/DrawMode/DeviationAndAverage";
        public static final String DrawMode_DeviationAndLine = "http://www.simantics.org/Charts-1.2/DrawMode/DeviationAndLine";
        public static final String DrawMode_DeviationAndSample = "http://www.simantics.org/Charts-1.2/DrawMode/DeviationAndSample";
        public static final String DrawMode_Line = "http://www.simantics.org/Charts-1.2/DrawMode/Line";
        public static final String DrawMode_Sample = "http://www.simantics.org/Charts-1.2/DrawMode/Sample";
        public static final String Functions = "http://www.simantics.org/Charts-1.2/Functions";
        public static final String Functions_chartItemLabel = "http://www.simantics.org/Charts-1.2/Functions/chartItemLabel";
        public static final String Functions_chartItemSubscriptionInfo = "http://www.simantics.org/Charts-1.2/Functions/chartItemSubscriptionInfo";
        public static final String HasColor = "http://www.simantics.org/Charts-1.2/HasColor";
        public static final String HasColor_Inverse = "http://www.simantics.org/Charts-1.2/HasColor/Inverse";
        public static final String HasDefaultChartTemplate = "http://www.simantics.org/Charts-1.2/HasDefaultChartTemplate";
        public static final String HasDefaultChartTemplate_Inverse = "http://www.simantics.org/Charts-1.2/HasDefaultChartTemplate/Inverse";
        public static final String Last10MinutesChartTemplate = "http://www.simantics.org/Charts-1.2/Last10MinutesChartTemplate";
        public static final String Last60SecondsChartTemplate = "http://www.simantics.org/Charts-1.2/Last60SecondsChartTemplate";
        public static final String ObtainedDouble = "http://www.simantics.org/Charts-1.2/ObtainedDouble";
        public static final String Renderer = "http://www.simantics.org/Charts-1.2/Renderer";
        public static final String Renderer_Analog = "http://www.simantics.org/Charts-1.2/Renderer/Analog";
        public static final String Renderer_Binary = "http://www.simantics.org/Charts-1.2/Renderer/Binary";
        public static final String ScaleMode = "http://www.simantics.org/Charts-1.2/ScaleMode";
        public static final String ScaleMode_AutoScale = "http://www.simantics.org/Charts-1.2/ScaleMode/AutoScale";
        public static final String ScaleMode_ManualScale = "http://www.simantics.org/Charts-1.2/ScaleMode/ManualScale";
        public static final String TimeSeriesChart = "http://www.simantics.org/Charts-1.2/TimeSeriesChart";
        public static final String WholeHistoryChartTemplate = "http://www.simantics.org/Charts-1.2/WholeHistoryChartTemplate";
        public static final String YAxisMode = "http://www.simantics.org/Charts-1.2/YAxisMode";
        public static final String YAxisMode_MultiAxis = "http://www.simantics.org/Charts-1.2/YAxisMode/MultiAxis";
        public static final String YAxisMode_SingleAxis = "http://www.simantics.org/Charts-1.2/YAxisMode/SingleAxis";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public ChartResource(ReadGraph graph) {
        Chart = getResourceOrNull(graph, URIs.Chart);
        ChartActionContext = getResourceOrNull(graph, URIs.ChartActionContext);
        ChartActionContext_Actions = getResourceOrNull(graph, URIs.ChartActionContext_Actions);
        ChartActionContext_Actions_ChartDropAction = getResourceOrNull(graph, URIs.ChartActionContext_Actions_ChartDropAction);
        ChartActionContext_Actions_ChartGroupDropAction = getResourceOrNull(graph, URIs.ChartActionContext_Actions_ChartGroupDropAction);
        ChartActionContext_Actions_ChartItemDropAction = getResourceOrNull(graph, URIs.ChartActionContext_Actions_ChartItemDropAction);
        ChartActionContext_Actions_NewChart = getResourceOrNull(graph, URIs.ChartActionContext_Actions_NewChart);
        ChartActionContext_Actions_NewChartGroup = getResourceOrNull(graph, URIs.ChartActionContext_Actions_NewChartGroup);
        ChartBrowseContext = getResourceOrNull(graph, URIs.ChartBrowseContext);
        ChartBrowseContext_ChartItemLabelDecorationRule = getResourceOrNull(graph, URIs.ChartBrowseContext_ChartItemLabelDecorationRule);
        ChartBrowseContext_ChartItemLabelRule = getResourceOrNull(graph, URIs.ChartBrowseContext_ChartItemLabelRule);
        ChartBrowseContext_ChartItemNameModifierRule = getResourceOrNull(graph, URIs.ChartBrowseContext_ChartItemNameModifierRule);
        ChartBrowseContext_ChartSorterRule = getResourceOrNull(graph, URIs.ChartBrowseContext_ChartSorterRule);
        ChartBrowseContext_ChartsFolder = getResourceOrNull(graph, URIs.ChartBrowseContext_ChartsFolder);
        ChartBrowseContext_Images = getResourceOrNull(graph, URIs.ChartBrowseContext_Images);
        ChartBrowseContext_Images_Chart = getResourceOrNull(graph, URIs.ChartBrowseContext_Images_Chart);
        ChartBrowseContext_Images_ChartGroup = getResourceOrNull(graph, URIs.ChartBrowseContext_Images_ChartGroup);
        ChartBrowseContext_Images_ChartItemImage = getResourceOrNull(graph, URIs.ChartBrowseContext_Images_ChartItemImage);
        ChartBrowseContext_Images_ChartsFolder = getResourceOrNull(graph, URIs.ChartBrowseContext_Images_ChartsFolder);
        ChartBrowseContext_Images_Plot = getResourceOrNull(graph, URIs.ChartBrowseContext_Images_Plot);
        ChartGroup = getResourceOrNull(graph, URIs.ChartGroup);
        ChartTemplate = getResourceOrNull(graph, URIs.ChartTemplate);
        Chart_Item = getResourceOrNull(graph, URIs.Chart_Item);
        Chart_Item_DrawMode = getResourceOrNull(graph, URIs.Chart_Item_DrawMode);
        Chart_Item_HasChartItem = getResourceOrNull(graph, URIs.Chart_Item_HasChartItem);
        Chart_Item_HasSubscriptionItem = getResourceOrNull(graph, URIs.Chart_Item_HasSubscriptionItem);
        Chart_Item_Index = getResourceOrNull(graph, URIs.Chart_Item_Index);
        Chart_Item_Index_Inverse = getResourceOrNull(graph, URIs.Chart_Item_Index_Inverse);
        Chart_Item_Renderer = getResourceOrNull(graph, URIs.Chart_Item_Renderer);
        Chart_Item_ScaleMode = getResourceOrNull(graph, URIs.Chart_Item_ScaleMode);
        Chart_Item_ScaleMode_Max = getResourceOrNull(graph, URIs.Chart_Item_ScaleMode_Max);
        Chart_Item_ScaleMode_Max_Inverse = getResourceOrNull(graph, URIs.Chart_Item_ScaleMode_Max_Inverse);
        Chart_Item_ScaleMode_Min = getResourceOrNull(graph, URIs.Chart_Item_ScaleMode_Min);
        Chart_Item_ScaleMode_Min_Inverse = getResourceOrNull(graph, URIs.Chart_Item_ScaleMode_Min_Inverse);
        Chart_Item_hidden = getResourceOrNull(graph, URIs.Chart_Item_hidden);
        Chart_Item_hidden_Inverse = getResourceOrNull(graph, URIs.Chart_Item_hidden_Inverse);
        Chart_Item_subscriptionInfo = getResourceOrNull(graph, URIs.Chart_Item_subscriptionInfo);
        Chart_Item_subscriptionInfo_Inverse = getResourceOrNull(graph, URIs.Chart_Item_subscriptionInfo_Inverse);
        Chart_ShowMilestones = getResourceOrNull(graph, URIs.Chart_ShowMilestones);
        Chart_ShowMilestones_Inverse = getResourceOrNull(graph, URIs.Chart_ShowMilestones_Inverse);
        Chart_TimeWindowIncrement = getResourceOrNull(graph, URIs.Chart_TimeWindowIncrement);
        Chart_TimeWindowIncrement_Inverse = getResourceOrNull(graph, URIs.Chart_TimeWindowIncrement_Inverse);
        Chart_TimeWindowLength = getResourceOrNull(graph, URIs.Chart_TimeWindowLength);
        Chart_TimeWindowLength_Inverse = getResourceOrNull(graph, URIs.Chart_TimeWindowLength_Inverse);
        Chart_TimeWindowStart = getResourceOrNull(graph, URIs.Chart_TimeWindowStart);
        Chart_TimeWindowStart_Inverse = getResourceOrNull(graph, URIs.Chart_TimeWindowStart_Inverse);
        Chart_YAxisMode = getResourceOrNull(graph, URIs.Chart_YAxisMode);
        Chart_backgroundColor = getResourceOrNull(graph, URIs.Chart_backgroundColor);
        Chart_backgroundColor_Inverse = getResourceOrNull(graph, URIs.Chart_backgroundColor_Inverse);
        Chart_gridColor = getResourceOrNull(graph, URIs.Chart_gridColor);
        Chart_gridColor_Inverse = getResourceOrNull(graph, URIs.Chart_gridColor_Inverse);
        Chart_showGrid = getResourceOrNull(graph, URIs.Chart_showGrid);
        Chart_showGrid_Inverse = getResourceOrNull(graph, URIs.Chart_showGrid_Inverse);
        Chart_trackExperimentTime = getResourceOrNull(graph, URIs.Chart_trackExperimentTime);
        Chart_trackExperimentTime_Inverse = getResourceOrNull(graph, URIs.Chart_trackExperimentTime_Inverse);
        Chart_valueViewPosition = getResourceOrNull(graph, URIs.Chart_valueViewPosition);
        Chart_valueViewPosition_Inverse = getResourceOrNull(graph, URIs.Chart_valueViewPosition_Inverse);
        Contributions = getResourceOrNull(graph, URIs.Contributions);
        Contributions_Charts = getResourceOrNull(graph, URIs.Contributions_Charts);
        Contributions_NewChart = getResourceOrNull(graph, URIs.Contributions_NewChart);
        DrawMode = getResourceOrNull(graph, URIs.DrawMode);
        DrawMode_Average = getResourceOrNull(graph, URIs.DrawMode_Average);
        DrawMode_Deviation = getResourceOrNull(graph, URIs.DrawMode_Deviation);
        DrawMode_DeviationAndAverage = getResourceOrNull(graph, URIs.DrawMode_DeviationAndAverage);
        DrawMode_DeviationAndLine = getResourceOrNull(graph, URIs.DrawMode_DeviationAndLine);
        DrawMode_DeviationAndSample = getResourceOrNull(graph, URIs.DrawMode_DeviationAndSample);
        DrawMode_Line = getResourceOrNull(graph, URIs.DrawMode_Line);
        DrawMode_Sample = getResourceOrNull(graph, URIs.DrawMode_Sample);
        Functions = getResourceOrNull(graph, URIs.Functions);
        Functions_chartItemLabel = getResourceOrNull(graph, URIs.Functions_chartItemLabel);
        Functions_chartItemSubscriptionInfo = getResourceOrNull(graph, URIs.Functions_chartItemSubscriptionInfo);
        HasColor = getResourceOrNull(graph, URIs.HasColor);
        HasColor_Inverse = getResourceOrNull(graph, URIs.HasColor_Inverse);
        HasDefaultChartTemplate = getResourceOrNull(graph, URIs.HasDefaultChartTemplate);
        HasDefaultChartTemplate_Inverse = getResourceOrNull(graph, URIs.HasDefaultChartTemplate_Inverse);
        Last10MinutesChartTemplate = getResourceOrNull(graph, URIs.Last10MinutesChartTemplate);
        Last60SecondsChartTemplate = getResourceOrNull(graph, URIs.Last60SecondsChartTemplate);
        ObtainedDouble = getResourceOrNull(graph, URIs.ObtainedDouble);
        Renderer = getResourceOrNull(graph, URIs.Renderer);
        Renderer_Analog = getResourceOrNull(graph, URIs.Renderer_Analog);
        Renderer_Binary = getResourceOrNull(graph, URIs.Renderer_Binary);
        ScaleMode = getResourceOrNull(graph, URIs.ScaleMode);
        ScaleMode_AutoScale = getResourceOrNull(graph, URIs.ScaleMode_AutoScale);
        ScaleMode_ManualScale = getResourceOrNull(graph, URIs.ScaleMode_ManualScale);
        TimeSeriesChart = getResourceOrNull(graph, URIs.TimeSeriesChart);
        WholeHistoryChartTemplate = getResourceOrNull(graph, URIs.WholeHistoryChartTemplate);
        YAxisMode = getResourceOrNull(graph, URIs.YAxisMode);
        YAxisMode_MultiAxis = getResourceOrNull(graph, URIs.YAxisMode_MultiAxis);
        YAxisMode_SingleAxis = getResourceOrNull(graph, URIs.YAxisMode_SingleAxis);
    }
    
    public static ChartResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        ChartResource ret = session.peekService(ChartResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new ChartResource(qc.getIndependentGraph(graph));
            session.registerService(ChartResource.class, ret);
        }
        return ret;
    }
    
    public static ChartResource getInstance(RequestProcessor session) throws DatabaseException {
        ChartResource ret = session.peekService(ChartResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<ChartResource>() {
                public ChartResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new ChartResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(ChartResource.class, ret);
        }
        return ret;
    }
    
}

