/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.services.IServiceLocator;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.ExplorerState;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryProcessor;
import org.simantics.browsing.ui.PrimitiveQueryProcessor;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.EvaluatorDataImpl;
import org.simantics.browsing.ui.common.processors.ComparableFactoryResolver;
import org.simantics.browsing.ui.common.processors.ComparableSelectorQueryProcessor;
import org.simantics.browsing.ui.common.processors.FilterSelectionRequestQueryProcessor;
import org.simantics.browsing.ui.common.processors.ImageDecoratorFactoryResolver;
import org.simantics.browsing.ui.common.processors.ImagerFactoryResolver;
import org.simantics.browsing.ui.common.processors.LabelDecoratorFactoryResolver;
import org.simantics.browsing.ui.common.processors.LabelerFactoryResolver;
import org.simantics.browsing.ui.common.processors.UserSelectedComparableFactoryQueryProcessor;
import org.simantics.browsing.ui.common.processors.UserSelectedViewpointFactoryQueryProcessor;
import org.simantics.browsing.ui.common.processors.ViewpointFactoryResolver;
import org.simantics.browsing.ui.common.state.ExplorerStates;
import org.simantics.browsing.ui.common.views.FilterAreaSource;
import org.simantics.browsing.ui.common.views.IFilterArea;
import org.simantics.browsing.ui.common.views.IFilterAreaProvider;
import org.simantics.browsing.ui.graph.impl.AsyncReadGraphDataSource;
import org.simantics.browsing.ui.graph.impl.Evaluators;
import org.simantics.browsing.ui.graph.impl.InheritsQueryProcessor;
import org.simantics.browsing.ui.graph.impl.ReadGraphDataSource;
import org.simantics.browsing.ui.graph.impl.RelatedObjectsQueryProcessor;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.swt.ComparatorSelector;
import org.simantics.browsing.ui.swt.ContextMenuInitializer;
import org.simantics.browsing.ui.swt.DefaultExplorerSelectionListener;
import org.simantics.browsing.ui.swt.DefaultIsCheckedProcessor2;
import org.simantics.browsing.ui.swt.DefaultKeyListener;
import org.simantics.browsing.ui.swt.DefaultMouseListener;
import org.simantics.browsing.ui.swt.DefaultSelectionDataResolver;
import org.simantics.browsing.ui.swt.FilterArea;
import org.simantics.browsing.ui.swt.GraphExplorerFactory;
import org.simantics.browsing.ui.swt.IContextMenuInitializer;
import org.simantics.browsing.ui.swt.RootFilterArea;
import org.simantics.browsing.ui.swt.StandardContextTypesQueryProcessor;
import org.simantics.browsing.ui.swt.TypesQueryProcessor;
import org.simantics.browsing.ui.swt.ViewpointSelector;
import org.simantics.browsing.ui.swt.widgets.DragSourceListenerFactory;
import org.simantics.browsing.ui.swt.widgets.ExplorerMouseListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.request.PossibleVariable;
import org.simantics.db.layer0.request.PossibleVariableRepresents;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.db.request.Read;
import org.simantics.project.ProjectKeys;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalSelectionDragSourceListener;
import org.simantics.ui.dnd.NoImageDragSourceEffect;
import org.simantics.ui.dnd.SessionContainer;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.ExplorerColumnContentType;
import org.simantics.ui.selection.ExplorerInputContentType;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.datastructures.Function;
import org.simantics.utils.datastructures.disposable.DisposeState;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.HintTracker;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.datastructures.hints.IHintTracker;
import org.simantics.utils.ui.SWTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphExplorerComposite
extends Composite
implements Widget,
IAdaptable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphExplorerComposite.class);
    protected UserSelectedComparableFactoryQueryProcessor userSelectedComparableFactoryQueryProcessor;
    protected UserSelectedViewpointFactoryQueryProcessor userSelectedViewpointFactoryQueryProcessor;
    protected FilterSelectionRequestQueryProcessor filterSelectionRequestQueryProcessor;
    protected IFilterArea filterArea;
    protected EvaluatorData evaluatorData;
    protected LocalResourceManager resourceManager;
    protected ISelectionListener workbenchSelectionListener;
    private final int style;
    private final IWorkbenchSite site;
    protected GraphExplorer explorer;
    protected IMenuManager menuManager;
    private final Map<String, Object> args;
    protected ISessionContextProvider contextProvider;
    private ISessionContext sessionContext;
    private Object dragSource;
    private IHintTracker sessionContextTracker = new SessionContextProjectTracker();
    private InputSource inputSource = new DirectInputSource();
    private FilterAreaSource filterAreaSource = new SelectionFilterAreaSource();
    private final TreeColumnLayout ad;
    private String[] editingColumn = ColumnKeys.KEYS_SINGLE;
    private StatePersistor persistor = null;
    private final Composite toolComposite;
    private final Composite toolComposite2;
    private final Composite explorerComposite;
    private final WidgetSupport support;
    private final boolean useNodeBrowseContexts;
    private final boolean useNodeActionContexts;
    private BiFunction<GraphExplorer, Object[], Object[]> selectionTransformation = new BiFunction<GraphExplorer, Object[], Object[]>(){
        private IHintContext.Key[] KEYS = new IHintContext.Key[]{SelectionHints.KEY_MAIN};

        @Override
        public Object[] apply(GraphExplorer explorer, Object[] objects) {
            Object[] result = new Object[objects.length];
            int i = 0;
            while (i < objects.length) {
                SelectionElement context = new SelectionElement(explorer, this.KEYS, objects[i]);
                context.setHint(SelectionHints.KEY_MAIN, objects[i]);
                result[i] = context;
                ++i;
            }
            return result;
        }
    };
    private Set<String> browseContexts = null;
    private DisposeState disposeState = DisposeState.Alive;
    private boolean created = false;
    protected String contextMenuId = null;
    protected Set<String> uiContext = null;
    protected ISessionContextChangedListener contextChangeListener = new ISessionContextChangedListener(){

        public void sessionContextChanged(SessionContextChangedEvent event) {
            GraphExplorerComposite.this.sessionContext = event.getNewValue();
            GraphExplorerComposite.this.sessionContextTracker.track((IHintContext)GraphExplorerComposite.this.sessionContext);
        }
    };
    DragSourceListenerFactory dragSourceListenerFactory = new DragSourceListenerFactory(){
        final Transfer[] transfers = new Transfer[]{LocalObjectTransfer.getTransfer(), TextTransfer.getInstance()};

        @Override
        public DragSourceListener get(final ISelectionProvider selectionProvider) {
            final LocalSelectionDragSourceListener ls = new LocalSelectionDragSourceListener(selectionProvider);
            return new DragSourceListener(){

                public void dragStart(DragSourceEvent event) {
                    ls.dragStart(event);
                }

                public void dragSetData(DragSourceEvent event) {
                    if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                        try {
                            event.data = WorkbenchSelectionUtils.getPossibleJSON((Object)selectionProvider.getSelection());
                        }
                        catch (DatabaseException e) {
                            event.data = "{ type:\"Exception\" }";
                            LOGGER.error("Failed to get current selection as JSON.", (Throwable)e);
                        }
                    } else if (LocalObjectTransfer.getTransfer().isSupportedType(event.dataType)) {
                        ls.dragSetData(event);
                    }
                }

                public void dragFinished(DragSourceEvent event) {
                    ls.dragFinished(event);
                }
            };
        }

        @Override
        public Transfer[] getTransfers() {
            return this.transfers;
        }
    };
    private int dragStyle = 23;
    private Object currentInput;
    private Object currentRoot;

    public GraphExplorerComposite(Map<String, Object> args, IWorkbenchSite site, Composite parent, WidgetSupport support, int style) {
        super(parent, 0);
        if (args == null) {
            args = Collections.emptyMap();
        }
        this.args = args;
        this.site = site;
        this.style = style;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()), (Control)this);
        this.contextProvider = this.getSessionContextProvider(site);
        Integer maxChildren = (Integer)args.get("maxChildren");
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(1).margins(0, 0).spacing(0, 0).applyTo((Composite)this);
        this.toolComposite = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.toolComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.toolComposite);
        this.ad = new TreeColumnLayout();
        this.explorerComposite = new Composite((Composite)this, 0);
        this.explorerComposite.setLayout((Layout)this.ad);
        GridDataFactory.fillDefaults().grab(true, true).minSize(1, 50).applyTo((Control)this.explorerComposite);
        this.explorer = args.containsKey("treeView") && Boolean.TRUE.equals(args.get("treeView")) ? this.createExplorerControl2(this.explorerComposite, maxChildren) : (args.containsKey("natTable") && Boolean.TRUE.equals(args.get("natTable")) ? this.createExplorerControl3(this.explorerComposite, maxChildren) : this.createExplorerControl(this.explorerComposite, maxChildren));
        this.useNodeBrowseContexts = args.containsKey("useNodeBrowseContexts") && Boolean.TRUE.equals(args.get("useNodeBrowseContexts"));
        this.useNodeActionContexts = args.containsKey("useNodeActionContexts") && Boolean.TRUE.equals(args.get("useNodeActionContexts"));
        this.toolComposite2 = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.toolComposite2);
        GridLayoutFactory.fillDefaults().applyTo(this.toolComposite2);
        this.support = support;
        if (support != null) {
            support.register(this);
        }
    }

    public GraphExplorerComposite(Map<String, Object> args, IWorkbenchSite site, Composite parent, int style) {
        this(args, site, parent, null, style);
    }

    public ISessionContextProvider getSessionContextProvider(IWorkbenchSite site) {
        if (site != null) {
            return SimanticsUI.getSessionContextProvider((Object)site.getWorkbenchWindow());
        }
        return SimanticsUI.getSessionContextProvider();
    }

    public GraphExplorer getExplorer() {
        return this.explorer;
    }

    public Composite getExplorerComposite() {
        return this.explorerComposite;
    }

    public <T> T getExplorerControl() {
        return (T)this.explorer.getControl();
    }

    public void addListenerToControl(int eventType, Listener listener) {
        ((Control)this.explorer.getControl()).addListener(eventType, listener);
    }

    public void finish() {
        this.created = true;
        this.createControls(this.site);
        this.attachToSession();
    }

    IWorkbenchSite getSite() {
        return this.site;
    }

    protected void activateUiContexts() {
        Set<String> contexts = this.getUiContexts();
        if (contexts == null || contexts.isEmpty()) {
            return;
        }
        IWorkbenchSite site = this.getSite();
        if (site != null) {
            IContextService cs = (IContextService)this.getSite().getService(IContextService.class);
            for (String context : contexts) {
                cs.activateContext(context);
            }
        }
    }

    protected void createControls(IWorkbenchSite site) {
        Boolean displayFilter2;
        Boolean displayFilter;
        Control control = (Control)this.explorer.getControl();
        IContextMenuInitializer cmi = this.getContextMenuInitializer();
        if (cmi != null) {
            ISelectionProvider selectionProvider = (ISelectionProvider)this.explorer.getAdapter(ISelectionProvider.class);
            this.menuManager = cmi.createContextMenu(control, selectionProvider, site);
        }
        this.activateUiContexts();
        this.dragSource = this.setupDND(this.explorer);
        this.addListeners(this.explorer, this.menuManager);
        this.userSelectedComparableFactoryQueryProcessor = new UserSelectedComparableFactoryQueryProcessor();
        this.userSelectedViewpointFactoryQueryProcessor = new UserSelectedViewpointFactoryQueryProcessor();
        this.filterSelectionRequestQueryProcessor = new FilterSelectionRequestQueryProcessor();
        this.explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)this.filterSelectionRequestQueryProcessor);
        boolean hasExtraControls = false;
        boolean hasExtraControls2 = false;
        Boolean displaySelectors = (Boolean)this.args.get("displaySelectors");
        if (displaySelectors == null || displaySelectors.booleanValue()) {
            new ComparatorSelector(this.explorer, this.userSelectedComparableFactoryQueryProcessor, this.toolComposite, 8);
            new ViewpointSelector(this.explorer, this.userSelectedViewpointFactoryQueryProcessor, this.toolComposite, 8);
            hasExtraControls = true;
        }
        if ((displayFilter = (Boolean)this.args.get("displayFilter")) == null || displayFilter.booleanValue()) {
            this.filterArea = this.filterAreaSource.getFilterArea(this.toolComposite, this.explorer);
            hasExtraControls = true;
        }
        if ((displayFilter2 = (Boolean)this.args.get("displayFilter2")) != null && displayFilter2.booleanValue()) {
            this.filterArea = this.filterAreaSource.getFilterArea(this.toolComposite2, this.explorer);
            hasExtraControls2 = true;
        }
        if (!hasExtraControls) {
            GridDataFactory.fillDefaults().grab(true, false).minSize(0, 0).hint(0, 0).applyTo((Control)this.toolComposite);
        }
        if (!hasExtraControls2) {
            GridDataFactory.fillDefaults().grab(true, false).minSize(0, 0).hint(0, 0).applyTo((Control)this.toolComposite2);
        }
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(control);
        DropTarget target = new DropTarget(control, 23);
        target.setTransfer(this.getAcceptedDataTypes());
        if (control instanceof Tree) {
            target.addDropListener(new DropTargetListener(){
                Tree tree;
                {
                    this.tree = (Tree)GraphExplorerComposite.this.explorer.getControl();
                }

                public void dragEnter(DropTargetEvent event) {
                    event.detail = 1;
                }

                public void dragLeave(DropTargetEvent event) {
                }

                public void dragOperationChanged(DropTargetEvent event) {
                }

                public void dragOver(DropTargetEvent event) {
                }

                public void drop(DropTargetEvent event) {
                    TreeItem item = this.tree.getItem(this.tree.toControl(event.x, event.y));
                    if (item != null) {
                        Object data = item.getData();
                        if (data instanceof NodeContext) {
                            GraphExplorerComposite.this.handleDrop(event.data, (NodeContext)data);
                        } else if (data instanceof IAdaptable) {
                            IAdaptable a = (IAdaptable)data;
                            GraphExplorerComposite.this.handleDrop(event.data, (NodeContext)a.getAdapter(NodeContext.class));
                        }
                    } else {
                        GraphExplorerComposite.this.handleDrop(event.data, null);
                    }
                }

                public void dropAccept(DropTargetEvent event) {
                }
            });
        }
        this.setWorkbenchListeners();
        control.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                GraphExplorerComposite.this.doDispose();
            }
        });
    }

    public Object getAdapter(Class adapter) {
        if (GraphExplorer.class == adapter) {
            return this.explorer;
        }
        if (EvaluatorData.class == adapter) {
            return this.evaluatorData;
        }
        if (BrowseContext.class == adapter) {
            EvaluatorData ed = this.evaluatorData;
            return ed != null ? ed.getBrowseContext() : null;
        }
        if (adapter == IFilterAreaProvider.class) {
            return this.filterArea;
        }
        return this.explorer.getAdapter(adapter);
    }

    protected void doDispose() {
        this.removeWorkbenchListeners();
        this.userSelectedComparableFactoryQueryProcessor = null;
        this.userSelectedViewpointFactoryQueryProcessor = null;
        this.filterSelectionRequestQueryProcessor = null;
        this.disposeState = DisposeState.Disposing;
        try {
            if (this.contextProvider != null) {
                this.contextProvider.removeContextChangedListener(this.contextChangeListener);
                this.contextProvider = null;
            }
            this.sessionContextTracker.untrack();
            this.resourceManager = null;
            this.explorer = null;
            this.sessionContext = null;
            this.dragSource = null;
        }
        finally {
            this.disposeState = DisposeState.Disposed;
        }
    }

    public void dispose() {
        this.doDispose();
        super.dispose();
    }

    protected StatePersistor getStatePersistor() {
        return this.persistor;
    }

    public void setStatePersistor(StatePersistor persistor) {
        this.persistor = persistor;
    }

    protected void initializeExplorer(GraphExplorer explorer, ISessionContext context) {
        if (explorer == null || explorer.isDisposed()) {
            return;
        }
        if (context == null) {
            return;
        }
        if (this.browseContexts == null) {
            return;
        }
        Session session = context != null ? context.getSession() : null;
        this.setupDragSource(session);
        if (session != null) {
            this.evaluatorData = this.createEvaluatorData(session);
            explorer.setDataSource((DataSource)new AsyncReadGraphDataSource((AsyncRequestProcessor)session));
            explorer.setDataSource((DataSource)new ReadGraphDataSource((AsyncRequestProcessor)session));
        } else {
            this.evaluatorData = new EvaluatorDataImpl();
            explorer.removeDataSource(AsyncReadGraph.class);
            explorer.removeDataSource(ReadGraph.class);
        }
        explorer.setPersistor(this.getStatePersistor());
        explorer.setProcessor((NodeQueryProcessor)new ComparableFactoryResolver(this.evaluatorData));
        explorer.setProcessor((NodeQueryProcessor)new ViewpointFactoryResolver(this.evaluatorData));
        explorer.setProcessor((NodeQueryProcessor)new LabelerFactoryResolver(this.evaluatorData));
        explorer.setProcessor((NodeQueryProcessor)new ImagerFactoryResolver(this.evaluatorData));
        explorer.setProcessor((NodeQueryProcessor)new LabelDecoratorFactoryResolver(this.evaluatorData));
        explorer.setProcessor((NodeQueryProcessor)new ImageDecoratorFactoryResolver(this.evaluatorData));
        explorer.setProcessor((NodeQueryProcessor)new DefaultIsCheckedProcessor2(this.evaluatorData));
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new TypesQueryProcessor());
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new StandardContextTypesQueryProcessor());
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new InheritsQueryProcessor());
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new RelatedObjectsQueryProcessor());
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)this.userSelectedViewpointFactoryQueryProcessor);
        explorer.setProcessor((NodeQueryProcessor)new ComparableSelectorQueryProcessor());
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)this.userSelectedComparableFactoryQueryProcessor);
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)this.filterSelectionRequestQueryProcessor);
        this.initializeExplorerWithEvaluator(explorer, context, this.evaluatorData);
    }

    protected void initializeExplorerWithEvaluator(GraphExplorer explorer, ISessionContext context, EvaluatorData data) {
    }

    protected EvaluatorData createEvaluatorData(Session context) {
        return Evaluators.load((RequestProcessor)context.getSession(), this.browseContexts, (ResourceManager)this.resourceManager, (boolean)this.useNodeBrowseContexts, (boolean)this.useNodeActionContexts);
    }

    protected Transfer[] getAcceptedDataTypes() {
        return new Transfer[]{LocalObjectTransfer.getTransfer(), FileTransfer.getInstance(), TextTransfer.getInstance()};
    }

    protected void handleDrop(Object data, NodeContext target) {
    }

    public void setDragSourceListenerFactory(DragSourceListenerFactory dragSourceListenerFactory) {
        this.dragSourceListenerFactory = dragSourceListenerFactory;
    }

    protected DragSourceListener setupDND(GraphExplorer explorer) {
        ISelectionProvider selectionProvider = (ISelectionProvider)explorer.getAdapter(ISelectionProvider.class);
        DragSourceListener listener = this.createDragSourceListener(selectionProvider);
        Control control = (Control)explorer.getControl();
        DragSource source = this.createDragSource(control);
        source.setTransfer(this.getTransfers());
        source.addDragListener(listener);
        source.setDragSourceEffect((DragSourceEffect)new NoImageDragSourceEffect(control));
        return listener;
    }

    protected DragSourceListener createDragSourceListener(ISelectionProvider selectionProvider) {
        return this.dragSourceListenerFactory.get(selectionProvider);
    }

    protected void setDragStyle(int style) {
        this.dragStyle = style;
    }

    protected int getDragStyle() {
        return this.dragStyle;
    }

    protected DragSource createDragSource(Control control) {
        return new DragSource(control, this.getDragStyle());
    }

    protected Transfer[] getTransfers() {
        return this.dragSourceListenerFactory.getTransfers();
    }

    public EvaluatorData getEvaluatorData() {
        return this.evaluatorData;
    }

    protected void setSessionContextTracker(IHintTracker tracker) {
        this.sessionContextTracker = tracker;
    }

    public void setInputSource(InputSource source) {
        this.inputSource = source;
    }

    public void setFilterAreaSource(FilterAreaSource provider) {
        this.filterAreaSource = provider;
    }

    public void setSelectionTransformation(BiFunction<GraphExplorer, Object[], Object[]> transformation) {
        this.selectionTransformation = transformation;
        if (this.explorer != null) {
            this.explorer.setSelectionTransformation(transformation);
        }
    }

    protected Set<String> getBrowseContexts() {
        return this.browseContexts;
    }

    public void setBrowseContexts(Set<String> contexts) {
        this.browseContexts = contexts;
    }

    public void setBrowseContexts(String ... contexts) {
        this.browseContexts = new HashSet<String>();
        String[] stringArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.browseContexts.add(s);
            ++n2;
        }
        this.initializeExplorer(this.explorer, this.getSessionContext());
    }

    public void setContextMenuId(String contextMenuId) {
        this.contextMenuId = contextMenuId;
    }

    protected String getContextMenuId() {
        return this.contextMenuId;
    }

    public void setUiContexts(Set<String> uiContext) {
        this.uiContext = uiContext;
    }

    public Set<String> getUiContexts() {
        return this.uiContext;
    }

    protected InputSource getInputSource() {
        return this.inputSource;
    }

    protected Map<String, Object> getArguments() {
        return this.args;
    }

    protected <T> T getArgument(String key) {
        return (T)this.args.get(key);
    }

    protected DisposeState getDisposeState() {
        return this.disposeState;
    }

    public ISessionContext getSessionContext() {
        return this.sessionContext;
    }

    public ISessionContextProvider getSessionContextProvider() {
        return this.contextProvider;
    }

    public boolean setFocus() {
        if (this.explorer != null && !this.explorer.isDisposed()) {
            this.explorer.setFocus();
        }
        return true;
    }

    public void setWorkbenchListeners() {
        if (this.workbenchSelectionListener == null && this.getSite() != null) {
            ISelectionProvider selectionProvider = (ISelectionProvider)this.explorer.getAdapter(ISelectionProvider.class);
            this.getSite().setSelectionProvider(selectionProvider);
            this.workbenchSelectionListener = new DefaultExplorerSelectionListener(this.site.getPage().getActivePart(), this.explorer);
            this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.workbenchSelectionListener);
        }
    }

    protected void removeWorkbenchListeners() {
        if (this.workbenchSelectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.workbenchSelectionListener);
            this.workbenchSelectionListener = null;
            ISelectionProvider selectionProvider = (ISelectionProvider)this.explorer.getAdapter(ISelectionProvider.class);
            if (this.getSite().getSelectionProvider() == selectionProvider) {
                this.getSite().setSelectionProvider(null);
            }
        }
    }

    protected final void attachToSession() {
        this.contextProvider.addContextChangedListener(this.contextChangeListener);
        this.sessionContext = this.contextProvider.getSessionContext();
        this.sessionContextTracker.track((IHintContext)this.sessionContext);
    }

    protected void createControls(Composite parent) {
    }

    protected IContextMenuInitializer getContextMenuInitializer() {
        String contextMenuId = this.getContextMenuId();
        if (contextMenuId != null) {
            return new ContextMenuInitializer(contextMenuId);
        }
        return null;
    }

    protected GraphExplorer createExplorerControl(Composite parent, Integer maxChildren) {
        GraphExplorerFactory factory = GraphExplorerFactory.getInstance();
        if (maxChildren != null) {
            factory = factory.maxChildrenShown(maxChildren);
        }
        GraphExplorer ge = factory.selectionDataResolver(new DefaultSelectionDataResolver()).selectionTransformation(this.selectionTransformation).setServiceLocator((IServiceLocator)this.site).create(parent, this.style);
        return ge;
    }

    protected GraphExplorer createExplorerControl2(Composite parent, Integer maxChildren) {
        GraphExplorerFactory factory = GraphExplorerFactory.getInstance();
        if (maxChildren != null) {
            factory = factory.maxChildrenShown(maxChildren);
        }
        GraphExplorer ge = factory.selectionDataResolver(new DefaultSelectionDataResolver()).selectionTransformation(this.selectionTransformation).setServiceLocator((IServiceLocator)this.site).create2(parent, this.style);
        return ge;
    }

    protected GraphExplorer createExplorerControl3(Composite parent, Integer maxChildren) {
        GraphExplorerFactory factory = GraphExplorerFactory.getInstance();
        if (maxChildren != null) {
            factory = factory.maxChildrenShown(maxChildren);
        }
        GraphExplorer ge = factory.selectionDataResolver(new DefaultSelectionDataResolver()).selectionTransformation(this.selectionTransformation).setServiceLocator((IServiceLocator)this.site).create3(parent, this.style);
        return ge;
    }

    protected void setupDragSource(Session session) {
        if (this.dragSource instanceof SessionContainer) {
            ((SessionContainer)this.dragSource).setSession(session);
        }
    }

    protected void addListeners(GraphExplorer explorer, IMenuManager menuManager) {
        this.addSelectionInputListeners(explorer, menuManager);
    }

    protected void addSelectionInputListeners(GraphExplorer explorer, IMenuManager menuManager) {
        explorer.addListener((Object)new DefaultKeyListener(this.contextProvider, explorer, new Function<String[]>(){

            public String[] execute(Object ... obj) {
                return GraphExplorerComposite.this.getEditingColumn((NodeContext)obj[0]);
            }
        }));
        explorer.addListener((Object)new DefaultMouseListener(explorer));
    }

    protected String[] getEditingColumn(NodeContext context) {
        return this.editingColumn;
    }

    public void setEditingColumn(String ... columnKeysInOrderOfTrial) {
        this.editingColumn = columnKeysInOrderOfTrial;
    }

    public final boolean applySessionContext(ISessionContext context) {
        if (this.disposeState != DisposeState.Alive) {
            return false;
        }
        this.initializeExplorer(this.explorer, context);
        this.sessionContextTracker.track((IHintContext)this.sessionContext);
        this.sessionContext = context;
        Object root = this.inputSource.get(context, this.currentInput);
        if (ObjectUtils.objectEquals((Object)root, (Object)this.currentRoot)) {
            return false;
        }
        this.currentRoot = root;
        this.explorer.setUIContexts(this.uiContext);
        this.explorer.setRoot(root);
        return true;
    }

    protected boolean isImportantInput(Object previousSelection, Object selection) {
        return !ObjectUtils.objectEquals((Object)previousSelection, (Object)selection);
    }

    public void setInput(Object selection, boolean force) {
        Object root;
        assert (this.created);
        if (this.isDisposed()) {
            return;
        }
        if (this.sessionContext == null) {
            return;
        }
        if (!force && !this.isImportantInput(this.currentInput, selection)) {
            return;
        }
        this.currentInput = selection;
        this.currentRoot = root = this.inputSource.get(this.sessionContext, selection);
        this.explorer.setUIContexts(this.uiContext);
        if (root == null) {
            this.explorer.setRoot(GraphExplorer.EMPTY_INPUT);
        } else {
            this.explorer.setRoot(root);
        }
    }

    public void setColumnsVisible(boolean visible) {
        this.explorer.setColumnsVisible(visible);
    }

    private int getColumnWidth(Column column, ExplorerState state) {
        Integer width;
        if (state != null && state.columnWidths != null && (width = (Integer)state.columnWidths.get(column.getLabel())) != null) {
            return width;
        }
        return column.getWidth();
    }

    protected void restoreColumnSizes(Map<Column, Object> columns) {
        if (this.persistor != null) {
            this.setColumnData(columns, null);
            ExplorerStates.scheduleRead((NodeContext)this.explorer.getRoot(), (StatePersistor)this.persistor).thenAccept(state -> SWTUtils.asyncExec((org.eclipse.swt.widgets.Widget)this, () -> {
                if (this.explorerComposite.isDisposed()) {
                    this.setColumnData(columns, (ExplorerState)state);
                }
            }));
        } else {
            this.setColumnData(columns, null);
        }
    }

    protected void setColumnData(Map<Column, Object> columns, ExplorerState state) {
        columns.forEach((column, widget) -> {
            org.eclipse.swt.widgets.Widget columnWidget = (org.eclipse.swt.widgets.Widget)widget;
            this.ad.setColumnData(columnWidget, (ColumnLayoutData)new ColumnWeightData(column.hasGrab() ? column.getWeight() : 0, this.getColumnWidth((Column)column, state)));
        });
    }

    public void setColumns(Column[] columns) {
        Column[] columnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            if (column.getWeight() < 0) {
                throw new IllegalArgumentException("Column weight must be >= 0, got " + column.getWeight() + " for " + column);
            }
            if (column.getWidth() < 0) {
                throw new IllegalArgumentException("Column minimum width must be >= 0, got " + column.getWidth() + " for " + column);
            }
            ++n2;
        }
        this.explorer.setColumns(columns, this::restoreColumnSizes);
    }

    @Override
    public void setInput(ISessionContext context, Object input) {
        this.setInput(input, false);
    }

    public void setMaxChildren(int maxChildren) {
        this.explorer.setMaxChildren(maxChildren);
    }

    public <T> void addListener(ExplorerMouseListenerImpl<T> listener) {
        this.support.register(listener);
        listener.register(this.explorer);
        this.explorer.addListener(listener);
    }

    public class DirectInputSource
    implements InputSource {
        @Override
        public Object get(ISessionContext ctx, Object selection) {
            return selection;
        }
    }

    public static interface FilterSource {
    }

    public static interface InputSource {
        public Object get(ISessionContext var1, Object var2);
    }

    public static class RootFilterAreaSource
    implements FilterAreaSource {
        public IFilterArea getFilterArea(Composite parent, GraphExplorer explorer) {
            FilterSelectionRequestQueryProcessor processor = (FilterSelectionRequestQueryProcessor)explorer.getPrimitiveProcessor(BuiltinKeys.SELECTION_REQUESTS);
            return new RootFilterArea(explorer, processor, parent, 8);
        }
    }

    static class SelectionElement
    extends AdaptableHintContext {
        public final WorkbenchSelectionElement wse;
        public final Object content;
        public final Resource resource;
        public final Variable variable;
        public final Object input;
        public final GraphExplorer.TransientExplorerState explorerState;

        private WorkbenchSelectionElement extractWse(Object content) {
            NodeContext context;
            Object input;
            if (content instanceof NodeContext && (input = (context = (NodeContext)content).getConstant(NodeType.TYPE)) instanceof NodeType) {
                return ((NodeType)input).getWorkbenchSelectionElement(context);
            }
            return null;
        }

        private Resource extractResource(Object content) {
            if (content instanceof NodeContext) {
                Resource var;
                NodeContext context = (NodeContext)content;
                Object input = context.getConstant(BuiltinKeys.INPUT);
                if (input instanceof Resource) {
                    return (Resource)input;
                }
                if (input instanceof IAdaptable && (var = (Resource)((IAdaptable)input).getAdapter(Resource.class)) != null) {
                    return var;
                }
            }
            return null;
        }

        private Variable extractVariable(Object content) {
            if (content instanceof NodeContext) {
                Variable var;
                NodeContext context = (NodeContext)content;
                Object input = context.getConstant(BuiltinKeys.INPUT);
                if (input instanceof Variable) {
                    return (Variable)input;
                }
                if (input instanceof IAdaptable && (var = (Variable)((IAdaptable)input).getAdapter(Variable.class)) != null) {
                    return var;
                }
            }
            return null;
        }

        private Object extractInput(Object content) {
            if (content instanceof NodeContext) {
                NodeContext context = (NodeContext)content;
                return context.getConstant(BuiltinKeys.INPUT);
            }
            return null;
        }

        public SelectionElement(GraphExplorer explorer, IHintContext.Key[] keys, Object content) {
            super(keys);
            this.content = content;
            this.wse = this.extractWse(content);
            this.resource = this.extractResource(content);
            this.variable = this.extractVariable(content);
            this.input = this.extractInput(content);
            this.explorerState = explorer.getTransientState();
        }

        public <T> T getContent(WorkbenchSelectionContentType<T> contentType) {
            Object result;
            if (this.wse != null && (result = this.wse.getContent(contentType)) != null) {
                return (T)result;
            }
            if (contentType instanceof AnyResource) {
                if (this.resource != null) {
                    return (T)this.resource;
                }
                if (this.variable == null) {
                    return null;
                }
                try {
                    return (T)((AnyResource)contentType).processor.syncRequest((Read)new PossibleVariableRepresents(this.variable));
                }
                catch (DatabaseException e) {
                    LOGGER.error("Unexpected error occurred while resolving Resource from Variable " + this.variable, (Throwable)e);
                }
            } else if (contentType instanceof AnyVariable) {
                if (this.variable != null) {
                    return (T)this.variable;
                }
                if (this.resource == null) {
                    return null;
                }
                try {
                    return (T)((AnyVariable)contentType).processor.syncRequest((Read)new PossibleVariable(this.resource));
                }
                catch (DatabaseException e) {
                    LOGGER.error("Unexpected error occurred while resolving Variable from Resource " + this.resource, (Throwable)e);
                }
            } else {
                if (contentType instanceof ExplorerInputContentType) {
                    return (T)this.input;
                }
                if (contentType instanceof ExplorerColumnContentType) {
                    return (T)this.explorerState.getActiveColumn();
                }
            }
            return null;
        }

        public Object getAdapter(Class adapter) {
            if (WorkbenchSelectionElement.class == adapter) {
                return this.wse;
            }
            if (NodeContext.class == adapter) {
                if (this.content instanceof NodeContext) {
                    return (NodeContext)this.content;
                }
                return null;
            }
            return super.getAdapter(adapter);
        }
    }

    public static class SelectionFilterAreaSource
    implements FilterAreaSource {
        public IFilterArea getFilterArea(Composite parent, GraphExplorer explorer) {
            FilterSelectionRequestQueryProcessor processor = (FilterSelectionRequestQueryProcessor)explorer.getPrimitiveProcessor(BuiltinKeys.SELECTION_REQUESTS);
            return new FilterArea(explorer, processor, parent, 8);
        }
    }

    public class SessionContextProjectTracker
    extends HintTracker {
        public SessionContextProjectTracker() {
            HintListenerAdapter activeProjectListener = new HintListenerAdapter(){

                public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                    GraphExplorerComposite.this.applySessionContext(GraphExplorerComposite.this.getSessionContext());
                }
            };
            this.addKeyHintListener(ProjectKeys.KEY_PROJECT, (IHintListener)activeProjectListener);
        }
    }
}

