/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.function.Consumer;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.browsing.ui.swt.SimanticsDialog;
import org.simantics.utils.datastructures.UnaryFunction;

public class Dialogs {
    public static <T> void invoke(final UnaryFunction<SimanticsDialog, Shell> function, final Consumer<T> callback) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SimanticsDialog dialog = (SimanticsDialog)((Object)function.call((Object)Display.getCurrent().getActiveShell()));
                dialog.open();
                if (1 == dialog.getReturnCode()) {
                    callback.accept(null);
                } else {
                    callback.accept(dialog.getSelection());
                }
            }
        });
    }

    public static String file(Shell shell, int style, String extension) {
        FileDialog dialog = new FileDialog(shell, style);
        dialog.setFilterExtensions(new String[]{extension});
        String newFileName = dialog.open();
        return newFileName;
    }

    public static String directory(Shell shell, int style, String filterPath) {
        DirectoryDialog dialog = new DirectoryDialog(shell, style);
        if (filterPath != null) {
            dialog.setFilterPath(filterPath);
        }
        String newFileName = dialog.open();
        return newFileName;
    }

    public static String file(int style, String extension) {
        return Dialogs.file(Display.getDefault().getActiveShell(), style, extension);
    }

    public static String file(Shell shell, String extension) {
        return Dialogs.file(shell, 4096, extension);
    }

    public static String file(ExecutionEvent event, String extension) {
        return Dialogs.file(HandlerUtil.getActiveShell((ExecutionEvent)event), extension);
    }

    public static String file(ExecutionEvent event, int style, String extension) {
        return Dialogs.file(HandlerUtil.getActiveShell((ExecutionEvent)event), style, extension);
    }

    public static String directory(int style, String filterPath) {
        return Dialogs.directory(Display.getDefault().getActiveShell(), style, filterPath);
    }
}

