/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets.impl;

import java.util.List;
import java.util.Map;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.simantics.browsing.ui.swt.widgets.Combo;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.utils.ReflectionUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ISelectionUtils;

abstract public class ModifyComboListenerImpl<T, S> implements ModifyListener, Widget {

	private ISessionContext context;
	private Object lastInput = null;
	
    final private Class<?> clazz;
	
	public ModifyComboListenerImpl() {
        clazz = ReflectionUtils.getSingleParameterType(getClass());
	}
	
	private Object getInputContents(Object input, Class<?> inputClass) {

		if(inputClass.isInstance(input)) return input;
		
		if(input instanceof ISelection) {
			return ISelectionUtils.filterSingleSelection((ISelection)input, inputClass);
		} else {
			return null;
		}
		
	}
	
	@SuppressWarnings("unchecked")
    @Override
	public void modifyText(ModifyEvent e) {
		
		Combo combo = (Combo)e.widget.getData("org.simantics.browsing.ui.widgets.Combo");
		
		int selectionIndex = combo.getWidget().getSelectionIndex();
		if (selectionIndex == -1)
		    return;

		String[] items = combo.getWidget().getItems();
		
		String key = items[selectionIndex];
		final Object input = lastInput;
		
		if(e.widget.getData() instanceof List) {

			List<Pair<String, Object>> data = (List<Pair<String, Object>>) e.widget.getData();
			Pair<String, Object> pair = data.get(selectionIndex);
			final Object o = pair.second;
			
			try {
				context.getSession().syncRequest(new WriteRequest() {

					@Override
					public void perform(WriteGraph graph) throws DatabaseException {

						T single = (T)getInputContents(input, clazz);
						applySelection(graph, single, (S)o);
						
					}
					
				});
			} catch (DatabaseException e1) {
				e1.printStackTrace();
			}
			
		} else if (e.widget.getData() instanceof Map) {
			
			Map<String, Object> data = (Map<String, Object>) e.widget.getData();
			final Object o = data.get(key);
			
			try {
				context.getSession().syncRequest(new WriteRequest() {

					@Override
					public void perform(WriteGraph graph) throws DatabaseException {

						T single = (T)getInputContents(input, clazz);
						applySelection(graph, single, (S)o);
						
					}
					
				});
			} catch (DatabaseException e1) {
				e1.printStackTrace();
			}
			
		}
		
	}

	@Override
	public void setInput(ISessionContext context, Object parameter) {
		this.context = context;
		lastInput = parameter;
	}
	
	abstract public void applySelection(WriteGraph graph, T input, S selection) throws DatabaseException;
	
}
	