/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.ui.SWTUtils;

public class Label extends WidgetImpl {

	private ReadFactory<?, String> textFactory;
	private ReadFactory<?, Color> colorFactory;
	
	final private org.eclipse.swt.widgets.Label label;
	
	public Label(Composite parent, WidgetSupport support, int style) {
		super(support);
		label = new org.eclipse.swt.widgets.Label(parent, style);
		support.register(this);
	}
	
	public void setTextFactory(ReadFactory<?, String> textFactory) {
		this.textFactory = textFactory;
	}
	
	public void setForegroundFactory(ReadFactory<?, Color> colorFactory) {
		this.colorFactory = colorFactory;
	}

	public org.eclipse.swt.widgets.Label getWidget() {
		return label;
	}
	
	@Override
	public Control getControl() {
		return label;
	}

	@Override
	public void setInput(ISessionContext context, Object input) {

		if(textFactory != null) {
			textFactory.listen(context, input, new Listener<String>() {

				public void exception(final Throwable t) {
					SWTUtils.asyncExec(label, new Runnable() {

						@Override
						public void run() {
							if(isDisposed()) return;
//							System.out.println("Button received new text: " + text);
							label.setText(t.toString());
						}

					});
				}

				@Override
				public void execute(final String text) {
					SWTUtils.asyncExec(label, new Runnable() {

						@Override
						public void run() {
							if(isDisposed()) return;
							label.setText(text);
							// TODO: how can we resize without this knife??
							label.getParent().layout();
							label.getParent().getParent().layout();
						}

					});
				}

				@Override
				public boolean isDisposed() {
					return label.isDisposed();
				}

			});
		}
		
		if(colorFactory != null) {
			colorFactory.listen(context, input, new Listener<Color>() {

				@Override
				public void exception(Throwable t) {
					t.printStackTrace();
				}

				@Override
				public void execute(final Color color) {
					label.getDisplay().asyncExec(new Runnable() {

						@Override
						public void run() {
							if(isDisposed()) return;
							label.setForeground(color);
						}

					});
				}

				@Override
				public boolean isDisposed() {
					return label.isDisposed();
				}

			});
		}
		
	}
	
    public <T> void setText(final ParametrizedRead<T, String> read) {
    	
    	Simantics.getSession().async(new UniqueRead<String>() {

    		@Override
    		public String perform(ReadGraph graph) throws DatabaseException {
    			T input = support.getInput(graph);
    			return graph.syncRequest(read.get(input));
    		}

    	}, new Listener<String>() {

    		@Override
    		public void exception(Throwable t) {
    			t.printStackTrace();
    		}

    		@Override
    		public void execute(final String text) {

    			if(isDisposed()) return;

    			label.getDisplay().asyncExec(new Runnable() {

    				@Override
    				public void run() {
    					label.setText(text);
    				}

    			});
    		}

    		@Override
    		public boolean isDisposed() {
    			return label.isDisposed();
    		}

    	});

    }
	
	public void setText(String text) {
		label.setText(text);
	}

}
