/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.ReflectionUtils;
import org.simantics.utils.ui.ISelectionUtils;


public class IdentityFactory<T> implements ReadFactory<T, T> {

	final Class<?> inputClass;
	
	public IdentityFactory() {
		inputClass = ReflectionUtils.getSingleParameterType(getClass());
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void listen(ISessionContext context, Object input, Listener<T> listener) {
		
		final Object inputContents = ISelectionUtils.filterSingleSelection((ISelection)input, inputClass);
		listener.execute((T)inputContents);
		
	}

	
}
