/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.datastructures.Pair;

public class Combo extends WidgetImpl {

    private ReadFactory<?, Map<String, Object>> itemFactory;
    private ReadFactory<?, List<Pair<String, Object>>> itemFactory2;
    private ReadFactory<?, String> selectionFactory;
    private final CopyOnWriteArrayList<ModifyListener> modifyListeners = new CopyOnWriteArrayList<ModifyListener>();
    private List<Pair<String, Object>> itemList;

    final private Display display;
    final private org.eclipse.swt.widgets.Combo combo;

    public Combo(Composite parent, WidgetSupport support, int style) {
    	super(support);
        this.display = parent.getDisplay();
        combo = new org.eclipse.swt.widgets.Combo(parent, style);
        combo.setData("org.simantics.browsing.ui.widgets.Combo", this);
        support.register(this);
    }

    public void setItemFactory(ReadFactory<?, Map<String, Object>> itemFactory) {
        if (this.itemFactory2 != null)
            throw new IllegalStateException("Cannot use both itemFactory and itemFactory2");
        this.itemFactory = itemFactory;
    }

    public void setItemFactory2(ReadFactory<?, List<Pair<String, Object>>> itemFactory) {
        if (this.itemFactory != null)
            throw new IllegalStateException("Cannot use both itemFactory and itemFactory2");
        this.itemFactory2 = itemFactory;
    }

    public void setSelectionFactory(ReadFactory<?, String> selectionFactory) {
        this.selectionFactory = selectionFactory;
    }

    public org.eclipse.swt.widgets.Combo getWidget() {
        return combo;
    }

    @Override
    public Control getControl() {
        return combo;
    }

    private AtomicBoolean inputDisposed;

    @Override
    public void setInput(ISessionContext context, Object input) {

        if (this.inputDisposed != null)
            this.inputDisposed.set(true);
        final AtomicBoolean inputDisposed = this.inputDisposed = new AtomicBoolean(false);

        if (modifyListeners != null) {
            for (ModifyListener listener : modifyListeners) {
                if(listener instanceof Widget) {
                    ((Widget) listener).setInput(context, input);
                }
            }
        }

        if(itemFactory != null) {
            itemFactory.listen(context, input, new Listener<Map<String, Object>>() {

                @Override
                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                @Override
                public void execute(final Map<String, Object> items) {
                    if(isDisposed()) return;
                    display.asyncExec(new Runnable() {

                        @Override
                        public void run() {
                            if(isDisposed()) return;
//                            System.out.println("Combo received new items: " + items.size());
                            for(ModifyListener listener : modifyListeners) combo.removeModifyListener(listener);
                            combo.setData(items);
                            combo.clearSelection();
                            try {
                                combo.removeAll();
                            } catch (Throwable t) {
                                t.printStackTrace();
                            }
                            int index = 0;
                            for(String key : items.keySet()) {
//                                System.out.println("-" + key);
                                combo.add(key);
                                combo.setData(key, index++);
                            }
                            String selectionKey = (String)combo.getData("_SelectionKey");
                            if(selectionKey != null) {
                                Integer selectionIndex = (Integer)combo.getData(selectionKey);
                                if(selectionIndex != null) combo.select(selectionIndex);
                            }
                            for(ModifyListener listener : modifyListeners) combo.addModifyListener(listener);
                            //label.setSize(200, 20);
//                            label.getParent().layout();
//                            label.getParent().getParent().layout();
                        }

                    });
                }

                @Override
                public boolean isDisposed() {
                    return combo.isDisposed() || inputDisposed.get();
                }

            });
        }

        if(itemFactory2 != null) {
            itemFactory2.listen(context, input, new Listener<List<Pair<String, Object>>>() {

                @Override
                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                @Override
                public void execute(final List<Pair<String, Object>> items) {
                    if(isDisposed()) return;
                    display.asyncExec(new Runnable() {

                        @Override
                        public void run() {
                            if(isDisposed()) return;
//                            System.out.println("Combo received new items: " + items.size());
                            itemList = items;
                            for(ModifyListener listener : modifyListeners) combo.removeModifyListener(listener);
                            combo.setData(items);
                            combo.clearSelection();
                            try {
                                combo.removeAll();
                            } catch (Throwable t) {
                                t.printStackTrace();
                            }
                            if (items != null) {
                                int index = 0;
                                for(Pair<String, Object> key : items) {
//                                    System.out.println("-" + key);
                                    combo.add(key.first);
                                    combo.setData(key.first, index++);
                                }
                                String selectionKey = (String)combo.getData("_SelectionKey");
                                if(selectionKey != null) {
                                    Integer selectionIndex = (Integer)combo.getData(selectionKey);
                                    if(selectionIndex != null) combo.select(selectionIndex);
                                }
                            }
                            for(ModifyListener listener : modifyListeners) combo.addModifyListener(listener);
                            //label.setSize(200, 20);
//							label.getParent().layout();
//							label.getParent().getParent().layout();
                        }

                    });
                }

                @Override
                public boolean isDisposed() {
                    return combo.isDisposed() || inputDisposed.get();
                }

            });
        }

        if(selectionFactory != null) {
            selectionFactory.listen(context, input, new Listener<String>() {

                @Override
                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                @Override
                public void execute(final String selectionKey) {
                    if(isDisposed()) return;
                    display.asyncExec(new Runnable() {

                        @Override
                        public void run() {
                            if(isDisposed()) return;
                            if(selectionKey == null) return;
//                            System.out.println("Combo received new selection key: " + selectionKey);
                            for(ModifyListener listener : modifyListeners) combo.removeModifyListener(listener);
                            combo.setData("_SelectionKey", selectionKey);
                            Integer selectionIndex = (Integer)combo.getData(selectionKey);
                            if(selectionIndex != null) combo.select(selectionIndex);
                            for(ModifyListener listener : modifyListeners) combo.addModifyListener(listener);
                        }

                    });
                }

                @Override
                public boolean isDisposed() {
                    return combo.isDisposed() || inputDisposed.get();
                }

            });
        }

    }

    public synchronized void addModifyListener(ModifyListener listener) {
        modifyListeners.add(listener);
        combo.addModifyListener(listener);
    }

    /**
     * @param index
     * @return
     * @throws IndexOutOfBoundsException if index is outside widget bounds
     */
    @SuppressWarnings("unchecked")
    public <T> Pair<String, T> getData(int index) {
        if (itemFactory != null)
            new IllegalStateException("this method is only useful when used with Combo.setItemFactory2").printStackTrace();
        if (index == -1)
            return null;
        return (Pair<String, T>) itemList.get(index);
    }

    /**
     * @return selected combo list item or <code>null</code> if no item is
     *         selected
     */
    public <T> Pair<String, T> getSelectedData() {
        return getData(combo.getSelectionIndex());
    }

}
