/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/**
 * @author Tuukka Lehtonen <tuukka.lehtonen@semantum.fi>
 */
public class ExplorerState {

	/**
	 * Default value for empty {@link #topNodePathChildIndex}.
	 */
	private static final int[] NO_CHILD_INDEXES = {};

	/**
	 * Empty default value for ExplorerState.
	 */
	public static final ExplorerState EMPTY = new ExplorerState(
			NodeContext.NONE, NO_CHILD_INDEXES,
			Collections.<NodeContext> emptyList(),
			Collections.<String, Integer> emptyMap());

	/**
	 * An empty array of no top node path is set.
	 * @see NodeContext#NONE
	 */
	public final NodeContext[] topNodePath;

	/**
	 * Tells the child index of each node in {@link #topNodePath}. 
	 * Must be the same size as {@link #topNodePath}.
	 */
	public final int[] topNodePathChildIndex;

	/**
	 * All the expanded nodes in the explorer. Never <code>null</code>.
	 */
	public final Collection<NodeContext> expandedNodes;

	/**
	 * Widths of columns.
	 */
	public final Map<String, Integer> columnWidths;

	/**
	 * @param topNodePath
	 * @param topNodePathChildIndex
	 * @param expandedNodes
	 * @param columnWidths 
	 */
	public ExplorerState(NodeContext[] topNodePath, int[] topNodePathChildIndex, Collection<NodeContext> expandedNodes, Map<String, Integer> columnWidths) {
		if (expandedNodes == null)
			throw new IllegalArgumentException("null expanded nodes");
		this.topNodePath = topNodePath;
		this.topNodePathChildIndex = topNodePathChildIndex;
		this.expandedNodes = expandedNodes;
		this.columnWidths = columnWidths;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + "[topNodePath="
				+ Arrays.toString(topNodePath) + ", topNodePathChildIndex="
				+ Arrays.toString(topNodePathChildIndex) + ", expandedNodes="
				+ expandedNodes + ", " + columnWidths + "]";
	}

}
