/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.platform.debug;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.graph.impl.Evaluators;
import org.simantics.browsing.ui.graph.impl.SessionContextInputSource;
import org.simantics.browsing.ui.platform.GraphExplorerView;
import org.simantics.browsing.ui.swt.DefaultSelectionDataResolver;
import org.simantics.browsing.ui.swt.GraphExplorerFactory;
import org.simantics.db.Session;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class BrowseDebuggerView extends GraphExplorerView {

    final private Set<String> browseContexts = Collections.singleton("browseDebuggerView");

    @Override
    protected GraphExplorer createExplorerControl(Composite parent) {
        return GraphExplorerFactory.getInstance()
        .selectionDataResolver(new DefaultSelectionDataResolver())
        .create(parent);
    }

    public BrowseDebuggerView() {

        setInputSource(new SessionContextInputSource() {

            @Override
            public Object get(ISessionContext ctx) {

                Map<String, String> args = getViewArguments();
                System.out.println("args=" + args);

                IViewPart view = WorkbenchUtils.findView(args.get("view"));
                System.out.println("view=" + view);

                return view;

            }
            
            @Override
            public IWorkbenchPart getProvider() {
                Map<String, String> args = getViewArguments();
                IViewPart view = WorkbenchUtils.findView(args.get("view"));
            	return view;
            }

        });

    }

    @Override
    protected EvaluatorData createEvaluatorData(Session session) {

        return Evaluators.load(session, browseContexts, resourceManager);

    }

    @SuppressWarnings({ "rawtypes" })
    @Override
    public Object getAdapter(Class adapter) {

//        if(adapter == IPropertyPage.class) {
//            return new UserPropertyPage(getSite(), this);
//        }
        if(adapter == ISessionContextProvider.class) {
            return getSessionContextProvider();
        }

        return super.getAdapter(adapter);

    }

}
