/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.nattable;

import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.simantics.browsing.ui.nattable.GETreeData;
import org.simantics.browsing.ui.nattable.GETreeRowModel;
import org.simantics.browsing.ui.nattable.TreeNode;
import org.simantics.browsing.ui.nattable.override.TreeLayer2;
import org.simantics.databoard.util.IdentityHashSet;

public class GETreeLayer
extends TreeLayer2 {
    Set<TreeNode> expanded = new IdentityHashSet();
    GETreeData treeData;
    Comparator<int[]> comparator = new FirstElementComparator();
    private boolean internalRefresh = false;
    List<int[]> hiddenPos;

    public GETreeLayer(IUniqueIndexLayer underlyingLayer, GETreeRowModel<TreeNode> treeRowModel, boolean useDefaultConfiguration) {
        super(underlyingLayer, treeRowModel, useDefaultConfiguration);
        if (underlyingLayer instanceof AbstractRowHideShowLayer) {
            throw new IllegalArgumentException("Cannot use treelayer above row hide layer");
        }
        this.treeData = (GETreeData)treeRowModel.getTreeData();
        this.hiddenPos = new ArrayList<int[]>();
        this.hiddenPos.add(new int[2]);
    }

    @Override
    public void collapseTreeRow(int parentIndex) {
        TreeNode task = this.treeData.getDataAtIndex(parentIndex);
        this.expanded.remove(task);
        task.setExpanded(false);
        super.collapseTreeRow(parentIndex);
    }

    public void fullCollapseTreeRow(int parentIndex) {
        TreeNode task = this.treeData.getDataAtIndex(parentIndex);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        Stack<TreeNode> stack = new Stack<TreeNode>();
        stack.add(task);
        while (!stack.isEmpty()) {
            TreeNode t = (TreeNode)stack.pop();
            indices.add(this.treeData.indexOf(t));
            stack.addAll(t.getChildren());
        }
        this.collapseTreeRow(indices);
    }

    @Override
    public void expandTreeRow(int parentIndex) {
        TreeNode task = this.treeData.getDataAtIndex(parentIndex);
        this.expanded.add(task);
        task.setExpanded(true);
        super.expandTreeRow(parentIndex);
    }

    public void expandToTreeRow(int parentIndex) {
        TreeNode task = this.treeData.getDataAtIndex(parentIndex);
        ArrayList<TreeNode> ancestors = new ArrayList<TreeNode>();
        while ((task = task.getParent()) != null) {
            ancestors.add(0, task);
        }
        for (TreeNode t : ancestors) {
            if (this.treeData.getDepthOfData(t) < 0) continue;
            this.expandTreeRow(this.treeData.indexOf(t));
        }
    }

    public void fullExpandTreeRow(int parentIndex) {
        TreeNode task = this.treeData.getDataAtIndex(parentIndex);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        Stack<TreeNode> stack = new Stack<TreeNode>();
        stack.add(task);
        while (!stack.isEmpty()) {
            TreeNode t = (TreeNode)stack.pop();
            indices.add(this.treeData.indexOf(t));
            stack.addAll(t.getChildren());
        }
        this.expandTreeRow(indices);
    }

    public void collapseTreeRow(int[] parentIndices) {
        ArrayList<Integer> rowPositions = new ArrayList<Integer>();
        ArrayList rowIndexes = new ArrayList();
        int[] nArray = parentIndices;
        int n = parentIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int parentIndex = nArray[n2];
            if (parentIndex >= 0) {
                TreeNode task = this.treeData.getDataAtIndex(parentIndex);
                if (task != null) {
                    task.setExpanded(false);
                    this.expanded.remove(task);
                }
                rowIndexes.addAll(this.getModel().collapse(parentIndex));
            }
            ++n2;
        }
        for (Integer rowIndex : rowIndexes) {
            int rowPos = this.getRowPositionByIndex(rowIndex);
            if (rowPos < 0) continue;
            rowPositions.add(rowPos);
        }
        int i = 0;
        while (i < rowIndexes.size()) {
            this.getHiddenRowIndexes().add((Integer)rowIndexes.get(i));
            ++i;
        }
        this.invalidateCache();
        this.fireLayerEvent((ILayerEvent)new HideRowPositionsEvent((ILayer)this, rowPositions));
    }

    public void collapseTreeRow(List<Integer> parentIndices) {
        ArrayList<Integer> rowPositions = new ArrayList<Integer>();
        ArrayList rowIndexes = new ArrayList();
        for (int parentIndex : parentIndices) {
            if (parentIndex < 0) continue;
            TreeNode task = this.treeData.getDataAtIndex(parentIndex);
            task.setExpanded(false);
            this.expanded.remove(task);
            rowIndexes.addAll(this.getModel().collapse(parentIndex));
        }
        for (Integer rowIndex : rowIndexes) {
            int rowPos = this.getRowPositionByIndex(rowIndex);
            if (rowPos < 0) continue;
            rowPositions.add(rowPos);
        }
        int i = 0;
        while (i < rowIndexes.size()) {
            this.getHiddenRowIndexes().add((Integer)rowIndexes.get(i));
            ++i;
        }
        this.invalidateCache();
        this.fireLayerEvent((ILayerEvent)new HideRowPositionsEvent((ILayer)this, rowPositions));
    }

    public void collapseAllRows() {
        int count = this.treeData.getElementCount();
        ArrayList<Integer> rowIndexes = new ArrayList<Integer>(count);
        int i = 0;
        while (i < count) {
            TreeNode t = this.treeData.getDataAtIndex(i);
            if (!this.treeData.isRoot(t)) {
                rowIndexes.add(i);
            }
            t.setExpanded(false);
            this.expanded.remove(t);
            this.getModel().collapse(i);
            ++i;
        }
        this.getHiddenRowIndexes().addAll(rowIndexes);
        this.invalidateCache();
        this.fireLayerEvent((ILayerEvent)new HideRowPositionsEvent((ILayer)this, rowIndexes));
    }

    public void expandTreeRow(int[] parentIndices) {
        ArrayList<Integer> rowIndexes = new ArrayList<Integer>();
        int[] nArray = parentIndices;
        int n = parentIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int parentIndex = nArray[n2];
            TreeNode task = this.treeData.getDataAtIndex(parentIndex);
            task.setExpanded(true);
            this.expanded.add(task);
            rowIndexes.addAll(this.getModel().expand(parentIndex));
            rowIndexes.add(parentIndex);
            ++n2;
        }
        int i = rowIndexes.size() - 1;
        while (i >= 0) {
            this.getHiddenRowIndexes().remove(rowIndexes.get(i));
            --i;
        }
        this.invalidateCache();
        this.fireLayerEvent((ILayerEvent)new ShowRowPositionsEvent((ILayer)this, rowIndexes));
    }

    public void expandTreeRow(List<Integer> parentIndices) {
        ArrayList rowIndexes = new ArrayList();
        for (int parentIndex : parentIndices) {
            TreeNode task = this.treeData.getDataAtIndex(parentIndex);
            task.setExpanded(true);
            this.expanded.add(task);
            rowIndexes.addAll(this.getModel().expand(parentIndex));
        }
        int i = rowIndexes.size() - 1;
        while (i >= 0) {
            this.getHiddenRowIndexes().remove(rowIndexes.get(i));
            --i;
        }
        this.invalidateCache();
        this.fireLayerEvent((ILayerEvent)new ShowRowPositionsEvent((ILayer)this, rowIndexes));
    }

    @Override
    protected void invalidateCache() {
        super.invalidateCache();
        this.hiddenPos.clear();
        this.hiddenPos.add(new int[2]);
    }

    private void _collapseAllRows() {
        int count = this.treeData.getElementCount();
        ArrayList<Integer> rowIndexes = new ArrayList<Integer>(count);
        int i = 0;
        while (i < count) {
            TreeNode t = this.treeData.getDataAtIndex(i);
            if (!this.treeData.isRoot(t)) {
                rowIndexes.add(i);
            }
            this.getModel().collapse(i);
            ++i;
        }
        this.getHiddenRowIndexes().addAll(rowIndexes);
        this.invalidateCache();
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        IStructuralChangeEvent structuralChangeEvent;
        HashSet<TreeNode> coll = null;
        if (event instanceof IStructuralChangeEvent && (structuralChangeEvent = (IStructuralChangeEvent)event).isVerticalStructureChanged()) {
            this.internalRefresh = true;
            ((GETreeRowModel)this.getModel()).clear();
            this.getHiddenRowIndexes().clear();
            coll = new HashSet<TreeNode>();
            for (TreeNode n : this.expanded) {
                if (n.isDisposed()) continue;
                coll.add(n);
            }
            this.expanded.clear();
            this.expanded.addAll(coll);
            coll.clear();
            for (TreeNode n : this.expanded) {
                if (n.isHidden()) continue;
                coll.add(n);
            }
        }
        super.handleLayerEvent(event);
        if (coll != null) {
            this._collapseAllRows();
            int[] ind = new int[coll.size()];
            Iterator iter = coll.iterator();
            int i = 0;
            while (i < ind.length) {
                ind[i] = this.treeData.indexOf((TreeNode)iter.next());
                ++i;
            }
            this.expandTreeRow(ind);
            this.internalRefresh = false;
        }
    }

    public void fireLayerEvent(ILayerEvent event) {
        if (!this.internalRefresh) {
            super.fireLayerEvent(event);
        }
    }

    public Set<TreeNode> getExpanded() {
        return this.expanded;
    }

    @Override
    public int getStartYOfRowPosition(int localRowPosition) {
        int underlyingPosition;
        Integer cachedStartY = this.startYCache.get((Object)localRowPosition);
        if (cachedStartY != null) {
            return cachedStartY;
        }
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        int underlyingStartY = underlyingLayer.getStartYOfRowPosition(underlyingPosition = this.localToUnderlyingRowPosition(localRowPosition));
        if (underlyingStartY < 0) {
            return -1;
        }
        int h = 0;
        int start = 0;
        if (this.hiddenPos.size() < 2) {
            if (this.getHiddenRowIndexes().size() > 0) {
                start = this.getHiddenRowIndexes().iterator().next();
            }
        } else {
            int[] d = this.hiddenPos.get(this.hiddenPos.size() - 1);
            start = d[0] + 1;
            h = d[1];
        }
        if (start < underlyingPosition) {
            Iterator iterator = ((IntRBTreeSet)this.getHiddenRowIndexes()).tailSet(start).iterator();
            while (iterator.hasNext()) {
                int hiddenIndex = (Integer)iterator.next();
                int hiddenPosition = underlyingLayer.getRowPositionByIndex(hiddenIndex);
                if (hiddenPosition != hiddenIndex) {
                    throw new RuntimeException("Underlying layer is swithing indices");
                }
                if (hiddenPosition >= 0 && hiddenPosition <= underlyingPosition) {
                    this.hiddenPos.add(new int[]{hiddenPosition, h += underlyingLayer.getRowHeightByPosition(hiddenPosition)});
                    continue;
                }
                if (hiddenPosition <= underlyingPosition) {
                    continue;
                }
                break;
            }
        } else {
            h = 0;
            int[] nArray = new int[2];
            nArray[0] = underlyingPosition;
            int index = Collections.binarySearch(this.hiddenPos, nArray, this.comparator);
            if (index < 0) {
                index = -index - 2;
            }
            h = this.hiddenPos.get(index)[1];
        }
        this.startYCache.put(Integer.valueOf(localRowPosition), Integer.valueOf(underlyingStartY -= h));
        return underlyingStartY;
    }

    private static class FirstElementComparator
    implements Comparator<int[]> {
        private FirstElementComparator() {
        }

        @Override
        public int compare(int[] o1, int[] o2) {
            return o1[0] - o2[0];
        }
    }
}

