/*******************************************************************************
 * Copyright (c) 2012 Original authors and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Original authors and others - initial API and implementation
 ******************************************************************************/
package org.simantics.browsing.ui.nattable.override;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandCollapseCommand;

public class TreeExpandCollapseCommandHandler extends
        AbstractLayerCommandHandler<TreeExpandCollapseCommand> {

    private final TreeLayer2 treeLayer;

    public TreeExpandCollapseCommandHandler(TreeLayer2 treeLayer) {
        this.treeLayer = treeLayer;
    }

    @Override
    public Class<TreeExpandCollapseCommand> getCommandClass() {
        return TreeExpandCollapseCommand.class;
    }

    @Override
    protected boolean doCommand(TreeExpandCollapseCommand command) {
        int parentIndex = command.getParentIndex();
        this.treeLayer.expandOrCollapseIndex(parentIndex);
        return true;
    }

}
