package org.simantics.browsing.ui.nattable;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.ui.matcher.CellEditorMouseEventMatcher;
import org.eclipse.swt.events.MouseEvent;

public class SelectedCellEditorMatcher extends CellEditorMouseEventMatcher{

	public SelectedCellEditorMatcher( String regionLabel) {
		super(regionLabel);
	}
	
	ILayerCell previous;
	int previousTime = 0;
	@Override
	public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
		if (super.matches(natTable, event, regionLabels)) {
			int px = natTable.getColumnPositionByX(event.x);
			int py = natTable.getRowPositionByY(event.y);
			ILayerCell cell = natTable.getCellByPosition(px,py);
			int time = event.time;
			if (previous != null &&
				cell.getColumnIndex() == previous.getColumnIndex() &&
				cell.getRowIndex() == previous.getRowIndex() &&
				time - previousTime > event.display.getDoubleClickTime())
				return true;
			previous = cell;
			previousTime = time;
		}
		return false;
	}
	
	
	
	

}
