package org.simantics.browsing.ui.nattable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.ConfigAttribute;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.IDisplayModeOrdering;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class GEStyler extends CellPainterWrapper{
		
	private GETreeData treeData;
	
	public GEStyler(GETreeData treeData, ICellPainter painter) {
		super(painter);
		this.treeData = treeData;
	}
	
	private ConfigRegistryWrapper wrapper = new ConfigRegistryWrapper();

	@Override
	public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
		wrapper.clear();
		wrapper.wrappedRegistry = configRegistry;
		TreeNode node = treeData.getDataAtIndex(cell.getRowIndex());
		Style style = new Style();
		node.getStyle(cell.getColumnIndex(), style);
		Image image = node.getImage(cell.getColumnIndex());
		if (image != null)
			style.setAttributeValue(CellStyleAttributes.IMAGE, image);
		
		wrapper.setSpecificConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "BODY", style);
//		wrapper.setSpecificConfigAttribute(CellStyleAttributes.FOREGROUND_COLOR, DisplayMode.NORMAL, "BODY", style.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
//		wrapper.setSpecificConfigAttribute(CellStyleAttributes.BACKGROUND_COLOR, DisplayMode.NORMAL, "BODY", style.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
//		wrapper.setSpecificConfigAttribute(CellStyleAttributes.FONT, DisplayMode.NORMAL, "BODY", style.getAttributeValue(CellStyleAttributes.FONT));
		super.paintCell(cell, gc, rectangle, wrapper);
	}
	
	private class ConfigRegistryWrapper extends ConfigRegistry {
		IConfigRegistry wrappedRegistry;
		 Map<ConfigAttribute<?>, Map<String, Map<String, ?>>> configRegistry = new HashMap<ConfigAttribute<?>, Map<String, Map<String, ?>>>();
		
		public void clear() {
			configRegistry.clear();
		}

		@Override
		public <T> T getConfigAttribute(ConfigAttribute<T> configAttribute, String targetDisplayMode,
				String... configLabels) {
			return wrappedRegistry.getConfigAttribute(configAttribute, targetDisplayMode, configLabels);
		}

		@Override
		public <T> T getConfigAttribute(ConfigAttribute<T> configAttribute, String targetDisplayMode,
				List<String> configLabels) {
			return wrappedRegistry.getConfigAttribute(configAttribute, targetDisplayMode, configLabels);
		}

		@Override
		public <T> T getSpecificConfigAttribute(ConfigAttribute<T> configAttribute, String displayMode,
				String configLabel) {
			T value = _getSpecificConfigAttribute(configAttribute, displayMode, configLabel);
			if (value != null)
				return value;
			return wrappedRegistry.getSpecificConfigAttribute(configAttribute, displayMode, configLabel);
		}
		
		 public <T> T _getSpecificConfigAttribute(ConfigAttribute<T> configAttribute,
		            String displayMode, String configLabel) {
		        T attributeValue = null;

		        Map<String, Map<String, ?>> displayModeConfigAttributeMap = this.configRegistry
		                .get(configAttribute);
		        if (displayModeConfigAttributeMap != null) {
		            Map<String, T> configAttributeMap = (Map<String, T>) displayModeConfigAttributeMap.get(displayMode);
		            if (configAttributeMap != null) {
		                attributeValue = configAttributeMap.get(configLabel);
		                if (attributeValue != null) {
		                    return attributeValue;
		                }
		            }
		        }

		        return attributeValue;
		    }
		
		public <T> void setSpecificConfigAttribute(ConfigAttribute<T> configAttribute, String displayMode,
				String configLabel, T attributeValue) {
			Map<String, Map<String, ?>> displayModeConfigAttributeMap = this.configRegistry
	                .get(configAttribute);
	        if (displayModeConfigAttributeMap == null) {
	            displayModeConfigAttributeMap = new HashMap<String, Map<String, ?>>();
	            this.configRegistry.put(configAttribute, displayModeConfigAttributeMap);
	        }

	        Map<String, T> configAttributeMap = (Map<String, T>) displayModeConfigAttributeMap.get(displayMode);
	        if (configAttributeMap == null) {
	            configAttributeMap = new HashMap<String, T>();
	            displayModeConfigAttributeMap.put(displayMode, configAttributeMap);
	        }

	        configAttributeMap.put(configLabel, attributeValue);
		}

		@Override
		public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue) {
			wrappedRegistry.registerConfigAttribute(configAttribute, attributeValue);
			
		}

		@Override
		public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue,
				String targetDisplayMode) {
			wrappedRegistry.registerConfigAttribute(configAttribute, attributeValue, targetDisplayMode);
			
		}

		@Override
		public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue,
				String targetDisplayMode, String configLabel) {
			wrappedRegistry.registerConfigAttribute(configAttribute, attributeValue, targetDisplayMode, configLabel);
			
		}

		@Override
		public <T> void unregisterConfigAttribute(ConfigAttribute<T> configAttributeType) {
			wrappedRegistry.unregisterConfigAttribute(configAttributeType);
			
		}

		@Override
		public <T> void unregisterConfigAttribute(ConfigAttribute<T> configAttributeType, String displayMode) {
			wrappedRegistry.unregisterConfigAttribute(configAttributeType, displayMode);
			
		}

		@Override
		public <T> void unregisterConfigAttribute(ConfigAttribute<T> configAttributeType, String displayMode,
				String configLabel) {
			wrappedRegistry.unregisterConfigAttribute(configAttributeType, displayMode, configLabel);
		}

		@Override
		public IDisplayModeOrdering getDisplayModeOrdering() {
			return wrappedRegistry.getDisplayModeOrdering();
		}
		
	}
}
