package org.simantics.browsing.ui.nattable;

import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.edit.action.CellEditDragMode;
import org.eclipse.nebula.widgets.nattable.edit.action.KeyEditAction;
import org.eclipse.nebula.widgets.nattable.edit.action.MouseEditAction;
import org.eclipse.nebula.widgets.nattable.grid.GridRegion;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.CellEditorMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.CellPainterMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.KeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.LetterOrDigitKeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.swt.SWT;

public class GEEditBindings extends AbstractUiBindingConfiguration {
	
    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        // configure the space key to activate a cell editor via keyboard
        // this is especially useful for changing the value for a checkbox
        uiBindingRegistry.registerKeyBinding(
                new KeyEventMatcher(SWT.NONE, 32),
                new KeyEditAction());
        uiBindingRegistry.registerKeyBinding(
                new KeyEventMatcher(SWT.NONE, SWT.F2),
                new KeyEditAction());
        uiBindingRegistry.registerKeyBinding(
                new LetterOrDigitKeyEventMatcher(),
                new KeyEditAction());
        uiBindingRegistry.registerKeyBinding(
                new LetterOrDigitKeyEventMatcher(SWT.MOD2),
                new KeyEditAction());

        uiBindingRegistry.registerSingleClickBinding(
                new SelectedCellEditorMatcher(GridRegion.BODY),
                new MouseEditAction());

        uiBindingRegistry.registerMouseDragMode(
                new CellEditorMouseEventMatcher(GridRegion.BODY),
                new CellEditDragMode());

        uiBindingRegistry.registerFirstSingleClickBinding(
                new CellPainterMouseEventMatcher(GridRegion.BODY, MouseEventMatcher.LEFT_BUTTON, CheckBoxPainter.class),
                new MouseEditAction());

        uiBindingRegistry.registerFirstMouseDragMode(
                new CellPainterMouseEventMatcher(GridRegion.BODY, MouseEventMatcher.LEFT_BUTTON, CheckBoxPainter.class),
                new CellEditDragMode());

    }

	
}
