package org.simantics.browsing.ui.model.browsecontexts;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.utils.datastructures.Arrays;
import org.simantics.viewpoint.ontology.ViewpointResource;

public class ContributedActionBrowseContexts extends TernaryRead<Resource,Resource,String,Collection<Resource>> {

    public ContributedActionBrowseContexts(Resource indexRoot, Resource context, String uiContext) {
        super(indexRoot, context, uiContext);
    }

    @Override
    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
        
        ViewpointResource VP = ViewpointResource.getInstance(graph);
        Instances query = graph.adapt(VP.ActionBrowseContextContribution, Instances.class);
        Collection<Resource> result = new ArrayList<Resource>();
        for(Resource contribution : query.find(graph, parameter)) {
            Resource type = graph.getPossibleObject(contribution, VP.ActionBrowseContextContribution_HasType);
            if(type != null) {
	            if(!graph.isInstanceOf(parameter2, type)) continue;
            }
            Resource testResource = graph.getPossibleObject(contribution, VP.ActionBrowseContextContribution_HasTest);
            if(testResource != null) {
            	Test test = graph.getPossibleAdapter(testResource, Test.class);
            	if(test != null) {
            		if(!test.test(graph, parameter2)) continue;
            	}
            }
	            	
            Resource context = graph.getPossibleObject(contribution, VP.ActionBrowseContextContribution_HasActionBrowseContext);
            if(context == null) continue;
            String[] allowedContexts = graph.getPossibleRelatedValue(contribution, VP.ActionBrowseContextContribution_allowedUIContexts, Bindings.STRING_ARRAY);
            if(allowedContexts != null)
            	if(!Arrays.contains(allowedContexts, parameter3))
            		continue;
            result.add(context);
            
        }
        return result;
        
    }

}
