/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.contributor.viewpoint;

import java.util.Collection;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointKey;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.graph.impl.LazyViewpoint;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * Extend and implement {@link #getChildren(ReadGraph, NodeContext)} to create a
 * viewpoint factory that reads from the graph database.
 * 
 * @author Antti Villberg
 */
public abstract class ViewpointFactory<T> implements org.simantics.browsing.ui.content.ViewpointFactory {

    @Override
    public Viewpoint create(PrimitiveQueryUpdater updater, NodeContext context, ViewpointKey key) {

        return new LazyViewpoint(updater, context, key) {
            @SuppressWarnings("unchecked")
            @Override
            public NodeContext[] children(ReadGraph graph) throws DatabaseException {

                T input = (T) context.getConstant(BuiltinKeys.INPUT);

                return toContextsWithInput(ViewpointFactory.this.
                        children(graph, input));

            }

            @Override
            public Boolean hasChildren(ReadGraph graph) throws DatabaseException {
                return children(graph).length > 0;
            }

            @Override
            public String toString() {
                return ViewpointFactory.this.toString();
            }

            @Override
            public Object getIdentity() {
                return ViewpointFactory.this.getClass();
            }
        };

    }

    abstract protected Collection<?> children(ReadGraph g, T input) throws DatabaseException;

}
