/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.Map;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.browsing.ui.common.modifiers.EnumerationValue;
import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.browsing.ui.graph.impl.GetEnumerationValue;
import org.simantics.browsing.ui.graph.impl.GraphEnumerationModifier;
import org.simantics.browsing.ui.graph.impl.GraphFactoryStringModifier;
import org.simantics.browsing.ui.graph.impl.LabelerUtil;
import org.simantics.browsing.ui.graph.impl.LazyGraphLabeler;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.ArrayMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyValueRepresentationLabelerFactory
implements LabelerFactory {
    public Labeler create(PrimitiveQueryUpdater manager, final NodeContext context, BuiltinKeys.LabelerKey key) {
        assert (manager != null);
        assert (context != null);
        return new LazyGraphLabeler(manager, context, key){

            @Override
            public Map<String, String> labels(ReadGraph graph) throws DatabaseException {
                IProperty prop = (IProperty)context.getConstant(BuiltinKeys.INPUT);
                Resource[] r = (Resource[])prop.adapt(Resource[].class);
                String property = LabelerUtil.safeStringRepresentation(graph, r[1]);
                String value = LabelerUtil.safeStringRepresentation(graph, r[2]);
                return new ArrayMap((Object[])ColumnKeys.KEYS_PROPERTY_VALUE, (Object[])new String[]{property, value});
            }

            public Labeler.Modifier getModifier(GraphExplorer.ModificationContext modificationContext, String key) {
                ISessionContext session = Simantics.getSessionContext();
                if (session == null) {
                    return null;
                }
                IProperty prop = (IProperty)context.getConstant(BuiltinKeys.INPUT);
                Resource[] r = (Resource[])prop.adapt(Resource[].class);
                if ("Value".equals(key)) {
                    try {
                        EnumerationValue enu = (EnumerationValue)session.getSession().syncRequest((Read)new GetEnumerationValue(r[2]));
                        if (enu != null) {
                            return new GraphEnumerationModifier(session.getSession(), r[0], r[1], (Enumeration<Resource>)enu.getEnumeration(), (EnumeratedValue<Resource>)enu.getEnumeratedValue());
                        }
                        return new GraphFactoryStringModifier(r[0], r[1], r[2], (RequestProcessor)session.getSession());
                    }
                    catch (DatabaseException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }

            @Override
            public Logger getLogger() {
                return LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            }
        };
    }
}

