/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.Collection;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointKey;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * Extend and implement {@link #getChildren(ReadGraph, NodeContext)} to create a
 * viewpoint factory that reads from the graph database.
 * 
 * @author Antti Villberg
 */
public abstract class LazyViewpointFactory implements ViewpointFactory {

    @Override
    public Viewpoint create(PrimitiveQueryUpdater updater,
            NodeContext context, ViewpointKey key) {
        return new LazyViewpoint(updater, context, key) {
            @Override
            public NodeContext[] children(ReadGraph graph) throws DatabaseException {
                return toContextsWithInput(LazyViewpointFactory.this.
                        getChildren(graph, context));
            }

            @Override
            public Boolean hasChildren(ReadGraph graph) throws DatabaseException {
                return children(graph).length > 0;
            }

            @Override
            public String toString() {
                return LazyViewpointFactory.this.toString();
            }

            @Override
            public Object getIdentity() {
                return LazyViewpointFactory.this.getClass();
            }
        };
    }

    abstract protected Collection<?> getChildren(ReadGraph g, NodeContext context) throws DatabaseException;

    protected boolean hasChildren(ReadGraph g, NodeContext context) throws DatabaseException {
        return !getChildren(g, context).isEmpty();
    }

}
