/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.ImagerKey;
import org.simantics.browsing.ui.NodeContext.QueryKey;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.ImagerFactory;

public class DefaultImagerFactoriesProcessor extends AbstractNodeQueryProcessor<Collection<ImagerFactory>> {

    @Override
    public QueryKey<Collection<ImagerFactory>> getIdentifier() {
        return BuiltinKeys.IMAGER_FACTORIES;
    }

    @Override
    public Collection<ImagerFactory> query(NodeQueryManager manager, NodeContext context) {
        return Collections.singleton((ImagerFactory) new ImagerFactory() {
            @Override
            public Imager create(PrimitiveQueryUpdater updater, final NodeContext context, ImagerKey key) {

                return new Imager() {

                    @Override
                    public <Image> Image getImage(String key) {
                        return null;
                    }

                };
                
            }
        });
    }

    @Override
    public String toString() {
        return "ImagerFactoriesProcessor";
    }

}