/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.comparators;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.content.ComparableContext;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.utils.strings.AlphanumComparator;

/**
 * @author Tuukka Lehtonen
 */
public class AlphanumericComparatorFactory implements ComparableContextFactory {

    private final String  column;
    private final String  label;
    private final boolean reverse;

    public AlphanumericComparatorFactory(String column) {
        this(column, null, false);
    }

    public AlphanumericComparatorFactory(String column, boolean reverse) {
        this(column, null, reverse);
    }

    public AlphanumericComparatorFactory(String column, String label, boolean reverse) {
        this.column = column;
        this.label = label;
        this.reverse = reverse;
    }
    
    protected String adjustLabel(String label) {
    	return label;
    }

    @Override
    public ComparableContext[] create(NodeQueryManager manager, NodeContext parent, NodeContext[] children) {
        ComparableContext[] result = new ComparableContext[children.length];
        for (int i = 0; i < children.length; i++) {
            NodeContext child = children[i];
            Labeler labeler = manager.query(child, BuiltinKeys.SELECTED_LABELER);

            int category = (labeler != null) ? labeler.getCategory() : 0;
            String label = (labeler != null) ? labeler.getLabels().get(column) : "";
            if (label == null)
                label = "";

            result[i] = new ImmutableLexicalComparable(category, adjustLabel(label), child) {
                @Override
                public int compareTo(ComparableContext arg0) {
                    ImmutableLexicalComparable other = (ImmutableLexicalComparable) arg0;

                    int catDelta = getCategory() - other.getCategory();
                    if (reverse)
                        catDelta = -catDelta;
                    if (catDelta != 0)
                        return catDelta;

                    String label1 = getLabel();
                    String label2 = other.getLabel();

                    return reverse ? AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare(label2, label1)
                            : AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare(label1, label2);
                }
            };
        }

        return result;
    }

    @Override
    public String toString() {
        return label != null ? label :
            reverse ? "Reversed Natural" : "Natural";
    }

}
