/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.application.db;

import java.net.BindException;
import java.net.Socket;

/**
 * @author Tuukka Lehtonen
 */
public class SocketUtils {

    /**
     * @return free ephemeral port for a TCP socket
     */
    public static int getFreeEphemeralPort() {
        while (true) {
            try {
                Socket s = null;
                try {
                    s = new Socket();
                    s.bind(null);
                    return s.getLocalPort();
                } finally {
                    if (s != null)
                        s.close();
                }
            } catch (BindException e) {
                // Nothing to do, try next port
            } catch (Throwable e) {
                throw new Error(e);
            }
        }
    }

}
