/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.annotation.ui.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.annotation.ui.Activator;

/**
 * A factory for diagram template related wizard extensions.
 * 
 * @author Tuukka Lehtonen
 */
public class WizardExtensionFactory implements IExecutableExtensionFactory, IExecutableExtension {

    /**
     * Factory ID for the annotation type export wizard.
     */
    public static final String ANNOTATION_TYPE_EXPORT_WIZARD = "annotationTypeExportWizard"; // $//$NON-NLS-1$

    /**
     * Factory ID for the annotation type import wizard.
     */
    public static final String ANNOTATION_TYPE_IMPORT_WIZARD = "annotationTypeImportWizard"; // $//$NON-NLS-1$
 
    private IConfigurationElement config;

    private String id;

    private String propertyName;

    public WizardExtensionFactory() {
        // do nothing
    }

    private Object configure(Object obj) throws CoreException {
        if (obj instanceof IExecutableExtension) {
            ((IExecutableExtension) obj).setInitializationData(config, propertyName, null);
        }
        return obj;
    }

    @Override
    public Object create() throws CoreException {
        if (ANNOTATION_TYPE_EXPORT_WIZARD.equals(id)) {
            return configure(new AnnotationTypeExportWizard());
        }
        if (ANNOTATION_TYPE_IMPORT_WIZARD.equals(id)) {
            return configure(new AnnotationTypeImportWizard());
        }

        throw new CoreException(new Status(IStatus.ERROR, Activator.PLUGIN_ID,
                0, "Unknown id in data argument for " + getClass(), null)); //$NON-NLS-1$
    }

    @Override
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data)
    throws CoreException {

        if (data instanceof String) {
            id = (String) data;
        } else {
            throw new CoreException(new Status(IStatus.ERROR,
                    Activator.PLUGIN_ID, 0,
                    "Data argument must be a String for " + getClass(), null)); //$NON-NLS-1$
        }
        this.config = config;
        this.propertyName = propertyName;
    }

}
