/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.simantics.utils.datastructures.MapList;
import org.simantics.xml.sax.ExporterGenerator;
import org.simantics.xml.sax.ImporterGenerator;
import org.simantics.xml.sax.ManualSchemaFileImport;
import org.simantics.xml.sax.OntologyGenerator;
import org.simantics.xml.sax.SchemaConversionBase;
import org.simantics.xml.sax.configuration.Configuration;
import org.w3._2001.xmlschema.Annotation;
import org.w3._2001.xmlschema.Import;
import org.w3._2001.xmlschema.Include;
import org.w3._2001.xmlschema.OpenAttrs;
import org.w3._2001.xmlschema.Schema;

public class SchemaConverter {
    File outputPlugin;
    File schemaFile;
    File conversionFile;
    File ontologyFile;
    File parserDir;
    Schema schema;
    Configuration configuration;
    String pluginName;
    private String[] header;
    boolean createPGraph = true;
    boolean createImporter = true;
    boolean createExporter = true;
    private List<SchemaConverter> parent = new ArrayList<SchemaConverter>();
    private List<SchemaConverter> subConverters = new ArrayList<SchemaConverter>();
    private Map<String, SchemaConverter> fileMap;
    private MapList<String, SchemaConverter> schemaNSMap;
    private MapList<String, SchemaConverter> shortNameMap;
    String schemaNs;
    String ontologyUri;
    String className;
    String name;
    String shortName;
    SchemaConversionBase base;
    private ManualSchemaFileImport fileImport;
    boolean init = false;

    public SchemaConverter(File schemaFile, File conversionFile, File outputPlugin) throws IOException {
        this(null, schemaFile, conversionFile, outputPlugin);
    }

    public SchemaConverter(SchemaConverter parent, File schemaFile, File conversionFile, File outputPlugin) throws IOException {
        this.outputPlugin = outputPlugin;
        this.schemaFile = schemaFile;
        this.conversionFile = conversionFile;
        this.pluginName = outputPlugin.getName();
        String[] packageParts = this.pluginName.split("\\.");
        String outputLoc = outputPlugin.getAbsolutePath();
        outputLoc = String.valueOf(outputLoc) + "/src";
        String[] stringArray = packageParts;
        int n = packageParts.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            outputLoc = String.valueOf(outputLoc) + "/" + s;
            ++n2;
        }
        String outputGraph = outputPlugin.getAbsolutePath();
        outputGraph = String.valueOf(outputGraph) + "/graph";
        outputGraph = String.valueOf(outputGraph) + "/" + schemaFile.getName().substring(0, schemaFile.getName().length() - 4) + ".pgraph";
        this.ontologyFile = new File(outputGraph);
        this.parserDir = new File(outputLoc);
        if (parent != null) {
            this.parent.add(parent);
            parent.subConverters.add(this);
        } else {
            this.fileMap = new HashMap<String, SchemaConverter>();
            this.schemaNSMap = new MapList();
            this.shortNameMap = new MapList();
        }
        this.getRoot().fileMap.put(schemaFile.getAbsolutePath(), this);
    }

    public List<SchemaConverter> getConverter(String schemaNS) {
        return this.getRoot().schemaNSMap.getValues((Object)schemaNS);
    }

    public void setFileImport(ManualSchemaFileImport fileImport) {
        this.fileImport = fileImport;
    }

    public void setCreateExporter(boolean createExporter) {
        this.createExporter = createExporter;
    }

    public void setCreateImporter(boolean createImporter) {
        this.createImporter = createImporter;
    }

    public void setCreatePGraph(boolean createPGraph) {
        this.createPGraph = createPGraph;
    }

    protected SchemaConverter createSubConverter(String location) throws JAXBException, IOException {
        SchemaConverter subConverter;
        File directory = this.schemaFile.getParentFile();
        File schemaFile = new File(String.valueOf(directory.getAbsolutePath()) + File.separator + location);
        if (!schemaFile.exists()) {
            if (this.getRoot().fileImport != null) {
                schemaFile = this.getRoot().fileImport.getFileForLocation(location);
            }
            if (!schemaFile.exists()) {
                throw new FileNotFoundException(schemaFile.getAbsolutePath());
            }
        }
        if ((subConverter = this.getRoot().fileMap.get(schemaFile.getAbsolutePath())) == null) {
            subConverter = new SchemaConverter(this, schemaFile, this.conversionFile, this.outputPlugin);
            subConverter.createPGraph = this.createPGraph;
            subConverter.createImporter = this.createImporter;
            subConverter.createExporter = this.createExporter;
        } else {
            subConverter.parent.add(this);
        }
        return subConverter;
    }

    /*
     * Unable to fully structure code
     */
    protected SchemaConverter getRoot() {
        s = this;
        if (s.fileMap == null) ** GOTO lbl7
        return s;
lbl-1000:
        // 1 sources

        {
            s = s.parent.get(0);
            if (s.fileMap == null) continue;
            return s;
lbl7:
            // 2 sources

            ** while (s.parent.size() > 0)
        }
lbl8:
        // 1 sources

        return s;
    }

    public void convert() throws JAXBException, IOException {
        this.init();
        this.doConvert();
    }

    protected void assignShortName() {
        this.shortName = this.name.substring(0, 3).toUpperCase();
        SchemaConverter root = this.getRoot();
        if (!root.shortNameMap.containsKey((Object)this.shortName)) {
            root.shortNameMap.add((Object)this.shortName, (Object)this);
            return;
        }
        SchemaConverter sc = (SchemaConverter)root.shortNameMap.getValues((Object)this.shortName).get(0);
        if (sc.schemaNs.equals(this.schemaNs)) {
            root.shortNameMap.add((Object)this.shortName, (Object)this);
            return;
        }
        int i = 1;
        while (true) {
            String n;
            if (!root.shortNameMap.containsKey((Object)(n = String.valueOf(this.shortName) + i))) {
                this.shortName = n;
                root.shortNameMap.add((Object)this.shortName, (Object)this);
                return;
            }
            SchemaConverter sc2 = (SchemaConverter)root.shortNameMap.getValues((Object)n).get(0);
            if (sc2.schemaNs.equals(this.schemaNs)) {
                this.shortName = n;
                root.shortNameMap.add((Object)this.shortName, (Object)this);
                return;
            }
            ++i;
        }
    }

    protected void init() throws IOException, JAXBException {
        if (this.init) {
            return;
        }
        this.init = true;
        JAXBContext jc = JAXBContext.newInstance((String)"org.w3._2001.xmlschema");
        Unmarshaller u = jc.createUnmarshaller();
        FileInputStream fileStream = new FileInputStream(this.schemaFile);
        this.schema = (Schema)u.unmarshal((InputStream)fileStream);
        if (this.conversionFile != null) {
            jc = JAXBContext.newInstance((String)"org.simantics.xml.sax.configuration");
            u = jc.createUnmarshaller();
            fileStream = new FileInputStream(this.conversionFile);
            this.configuration = (Configuration)((JAXBElement)u.unmarshal((InputStream)fileStream)).getValue();
        } else {
            this.configuration = new Configuration();
        }
        this.header = new String[4];
        this.header[0] = "Generated with org.simantics.xml.sax XML schema converter";
        this.header[1] = "";
        this.header[2] = "File " + this.schemaFile.getAbsolutePath().replaceAll(Matcher.quoteReplacement("\\"), "/");
        this.header[3] = "Date " + new Date().toString();
        this.ontologyUri = this.schemaNs = this.schema.getTargetNamespace();
        if (this.ontologyUri == null) {
            this.ontologyUri = this.getSchemaFile().getName();
            int index = this.ontologyUri.lastIndexOf(".");
            if (index > 0) {
                this.ontologyUri = this.ontologyUri.substring(0, index);
            }
            this.schemaNs = "";
        }
        this.ontologyUri = this.ontologyUri.replaceAll(" ", "_");
        String[] parts = this.ontologyUri.split("/");
        int i = parts.length - 1;
        while (i >= 0) {
            this.name = parts[i];
            if (!Character.isDigit(this.name.charAt(0))) break;
            --i;
        }
        if (this.name == null) {
            throw new JAXBException("Could not resolve proper name for schema " + this.ontologyUri);
        }
        this.name = this.name.replaceAll("\\.", "_");
        this.ontologyUri = !this.ontologyUri.startsWith("http://") ? "http://" + this.ontologyUri.replaceAll("/", "_") : "http://" + this.ontologyUri.substring("http://".length()).replaceAll("/", "_");
        String version = this.schema.getVersion();
        if (version == null) {
            version = "1.0";
        }
        this.ontologyUri = String.valueOf(this.ontologyUri) + "-" + version;
        this.className = String.valueOf(this.getPluginName()) + "." + this.name;
        this.assignShortName();
        if (this.schemaNs != null) {
            this.getRoot().schemaNSMap.add((Object)this.schemaNs, (Object)this);
        }
        for (OpenAttrs attrs : this.schema.getIncludeOrImportOrRedefine()) {
            SchemaConverter sc;
            String location;
            if (attrs instanceof Import) {
                Import imp = (Import)attrs;
                location = imp.getSchemaLocation();
                sc = this.createSubConverter(location);
                sc.init();
                continue;
            }
            if (attrs instanceof Include) {
                Include inc = (Include)attrs;
                location = inc.getSchemaLocation();
                sc = this.createSubConverter(location);
                sc.init();
                continue;
            }
            if (attrs instanceof Annotation) continue;
            throw new IOException("Cannot handle schema file " + this.schemaFile.getName() + ", the schema uses redefine elements.");
        }
    }

    protected void doConvert() throws IOException, JAXBException {
        if (!this.ontologyFile.exists()) {
            this.ontologyFile.getParentFile().mkdirs();
            this.ontologyFile.createNewFile();
        }
        if (!this.parserDir.exists()) {
            this.parserDir.mkdirs();
        }
        for (SchemaConverter sc : this.subConverters) {
            sc.doConvert();
        }
        this.base = new SchemaConversionBase(this, this.ontologyUri, this.className);
        this.base.init(this.schema);
        if (this.createPGraph) {
            OntologyGenerator ontologyGenerator = new OntologyGenerator(this, this.base);
            ontologyGenerator.createOntology();
        }
        if (this.createImporter) {
            ImporterGenerator importerGenerator = new ImporterGenerator(this, this.base);
            importerGenerator.createParser();
        }
        if (this.createExporter) {
            ExporterGenerator exporterGenerator = new ExporterGenerator(this, this.base);
            exporterGenerator.createParser();
        }
        this.base.component = null;
    }

    public File getOntologyFile() {
        return this.ontologyFile;
    }

    public File getParserDir() {
        return this.parserDir;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String[] getHeader() {
        return this.header;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isPrimary() {
        return this.getRoot() == this;
    }

    public String getShortName(String namespaceURI) {
        List<SchemaConverter> converters = this.getRoot().getConverter(namespaceURI);
        for (SchemaConverter conv : converters) {
            if (conv.shortName == null) continue;
            return conv.shortName;
        }
        return null;
    }

    public String getOntologyClassName(String namespaceURI) {
        List<SchemaConverter> converters = this.getRoot().getConverter(namespaceURI);
        for (SchemaConverter conv : converters) {
            if (conv.className == null) continue;
            return conv.className;
        }
        return null;
    }
}

