/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import javax.xml.namespace.QName;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.xml.sax.SchemaConversionBase;
import org.simantics.xml.sax.SchemaConversionComponent;
import org.simantics.xml.sax.SchemaConverter;
import org.simantics.xml.sax.SchemaElement;
import org.simantics.xml.sax.SchemaObject;
import org.simantics.xml.sax.configuration.Attribute;
import org.simantics.xml.sax.configuration.AttributeComposition;
import org.simantics.xml.sax.configuration.IDReference;
import org.w3._2001.xmlschema.Annotated;
import org.w3._2001.xmlschema.AttributeGroup;
import org.w3._2001.xmlschema.Element;
import org.w3._2001.xmlschema.List;
import org.w3._2001.xmlschema.LocalComplexType;
import org.w3._2001.xmlschema.LocalSimpleType;
import org.w3._2001.xmlschema.NamedAttributeGroup;
import org.w3._2001.xmlschema.NamedGroup;
import org.w3._2001.xmlschema.Schema;
import org.w3._2001.xmlschema.SimpleType;

public class OntologyGenerator
implements SchemaConversionComponent {
    SchemaConversionBase base;
    String ontRoot = "ONT.";
    String commentTag = "//";
    Schema schema;
    String ontologyUri;
    String className;
    SchemaConverter converter;
    PrintWriter writer = null;

    public OntologyGenerator(SchemaConverter converter, SchemaConversionBase base) {
        this.base = base;
        this.converter = converter;
        this.schema = base.schema;
        this.ontologyUri = base.ontologyURI;
        this.className = base.className;
    }

    public void createOntology() throws FileNotFoundException {
        StringWriter stringWriter = null;
        if (this.converter.getOntologyFile() == null) {
            stringWriter = new StringWriter();
            this.writer = new PrintWriter(stringWriter);
        } else {
            this.writer = new PrintWriter(this.converter.getOntologyFile());
        }
        this.handle();
        this.writer.flush();
        this.writer.close();
        if (stringWriter != null) {
            System.out.println(stringWriter.toString());
        }
    }

    protected void handle() {
        this.ontRoot = this.converter.shortName;
        String[] stringArray = this.converter.getHeader();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.writer.println(String.valueOf(this.commentTag) + " " + s);
            ++n2;
        }
        this.writer.println();
        this.writer.println("L0 = <http://www.simantics.org/Layer0-1.1>");
        this.writer.println("XML = <http://www.simantics.org/XML-1.0>");
        this.writer.println();
        if (this.converter.isPrimary()) {
            this.writer.println(String.valueOf(this.ontRoot) + " = <" + this.ontologyUri + "> : L0.Ontology");
            this.writer.println("   @L0.new");
            this.writer.println("   L0.HasResourceClass \"" + this.className + "\"");
        } else {
            this.writer.println(String.valueOf(this.ontRoot) + " = <" + this.ontologyUri + ">");
        }
        this.writer.println();
        this.writer.println();
        this.ontRoot = String.valueOf(this.ontRoot) + ".";
        this.writer.println(String.valueOf(this.ontRoot) + "SimpleTypes : L0.Library");
        this.writer.println(String.valueOf(this.ontRoot) + "ComplexTypes : L0.Library");
        this.writer.println(String.valueOf(this.ontRoot) + "AttributeGroups : L0.Library");
        this.writer.println();
        this.writer.println(String.valueOf(this.commentTag) + " Interpreted from schema");
        this.writer.println();
        this.base.handle(this);
    }

    protected String getType(QName qtype, String rel) {
        String ontType = this.base.getL0TypeFromPrimitiveType(qtype);
        if (ontType != null) {
            return ontType;
        }
        if (this.base.isComplexTypeRef(qtype.getLocalPart())) {
            return this.getName(this.base.getComplexType(qtype), rel);
        }
        if (this.base.isSimpleTypeRef(qtype.getLocalPart())) {
            return this.getName(this.base.getSimpleType(qtype), rel);
        }
        if (this.base.isElementRef(qtype.getLocalPart())) {
            return this.getName(this.base.getElement(qtype), rel);
        }
        throw new RuntimeException("Reference to unknown type " + qtype.getLocalPart());
    }

    @Override
    public String getSimpleTypePrefix() {
        return "SimpleTypes.";
    }

    @Override
    public String getComplexTypePrefix() {
        return "ComplexTypes.";
    }

    @Override
    public String getAttributeGroupPrefix() {
        return "AttributeGroups.";
    }

    @Override
    public String handleChoice(SchemaObject parent, SchemaElement indicator, java.util.List<SchemaElement> elements, String name) {
        boolean single = true;
        for (SchemaElement e : elements) {
            if (!e.getRestriction().many()) continue;
            single = false;
            break;
        }
        String relationName = String.valueOf(this.getName(parent)) + ".has" + name;
        this.writer.print(relationName);
        this.writer.print(" <R XML.hasElement");
        this.writer.println();
        if (!single) {
            String elementListType = String.valueOf(this.getName(parent)) + "." + name + "_List";
            this.writer.println(String.valueOf(elementListType) + " <T XML.ElementList");
            this.writer.println(String.valueOf(relationName) + "_List <R XML.hasElementList : L0.FunctionalRelation");
            this.writer.println("   --> " + elementListType);
        }
        return relationName;
    }

    @Override
    public void handleIndicator(SchemaObject parent, SchemaElement indicator, SchemaElement element, String refName, SchemaConversionBase.RefType refType, String baseRelationName) {
        if (refType != SchemaConversionBase.RefType.Element) {
            QName referenceType = null;
            if (refType == SchemaConversionBase.RefType.Type) {
                referenceType = element.getElement().getType();
                SchemaObject eObj = this.base.getElement(element.getElement());
                if (refName == null) {
                    refName = eObj.getName();
                }
            } else {
                referenceType = element.getElement().getRef();
                if (refName == null) {
                    refName = referenceType.getLocalPart();
                }
            }
            String type = this.base.getL0TypeFromPrimitiveType(referenceType);
            SchemaObject obj = null;
            if (type == null) {
                obj = this.base.getWithName(referenceType);
                this.writer.print(String.valueOf(this.getName(parent)) + ".has" + refName + " <R XML.hasElement <R " + this.getName(obj, "has"));
                if (baseRelationName != null) {
                    this.writer.print(" <R " + baseRelationName);
                }
                this.writer.println();
            } else {
                this.writer.print(String.valueOf(this.getName(parent)) + ".has" + refName + " <R XML.hasElement");
                if (baseRelationName != null) {
                    this.writer.print(" <R " + baseRelationName);
                }
                this.writer.println();
                this.writer.println("   --> " + this.getType(referenceType, ""));
            }
            if (this.base.useElementList(parent, indicator, element, refType == SchemaConversionBase.RefType.Reference, refName, referenceType)) {
                if (type == null) {
                    this.writer.println(String.valueOf(this.getName(parent)) + "." + refName + "List <T XML.ElementList");
                    this.writer.println(String.valueOf(this.getName(parent)) + ".has" + refName + "_List <R " + this.getName(obj, "has") + "_List : L0.FunctionalRelation");
                } else {
                    this.writer.println(String.valueOf(this.getName(parent)) + "." + refName + "_List <T XML.ElementList");
                    this.writer.println(String.valueOf(this.getName(parent)) + ".has" + refName + "_List <R XML.hasElementList : L0.FunctionalRelation");
                }
            }
        } else {
            Element attrs = element.getElement();
            SchemaObject obj = this.base.getWithObj(parent, attrs);
            if (refName == null) {
                refName = obj.getName();
            }
            this.writer.print(String.valueOf(this.getName(parent)) + ".has" + refName + " <R " + this.getName(obj, "has"));
            if (baseRelationName != null) {
                this.writer.print(" <R " + baseRelationName);
            }
            this.writer.println();
            this.writer.println("   --> " + this.getName(obj));
            if (this.base.useElementList(parent, indicator, element, false, refName, new QName(obj.getName()))) {
                this.writer.println(String.valueOf(this.getName(parent)) + "." + refName + "_List <T XML.ElementList");
                this.writer.println(String.valueOf(this.getName(parent)) + ".has" + refName + "_List <R " + this.getName(obj, "has") + "_List : L0.FunctionalRelation");
            }
        }
    }

    @Override
    public void handleIndicator(SchemaObject parent, SchemaElement indicator, SchemaElement any) {
    }

    @Override
    public void handle(SchemaObject parent, NamedGroup attribute) {
    }

    @Override
    public void handle(SchemaObject parent, org.w3._2001.xmlschema.Attribute attribute) {
        String relationType;
        String relationName;
        String name = attribute.getName();
        QName primitiveType = attribute.getType();
        LocalSimpleType simpleType = attribute.getSimpleType();
        QName ref = attribute.getRef();
        if (name != null) {
            relationName = String.valueOf(this.ontRoot) + "has" + name;
            if (parent != null) {
                relationName = String.valueOf(this.getName(parent)) + ".has" + name;
            }
            relationType = "XML.hasAttribute";
        } else if (ref != null && parent != null) {
            relationName = String.valueOf(this.getName(parent)) + ".has" + ref.getLocalPart();
            relationType = String.valueOf(this.ontRoot) + "has" + ref.getLocalPart();
        } else {
            throw new RuntimeException();
        }
        boolean id = false;
        String ontType = null;
        if (primitiveType != null) {
            ontType = this.base.getL0TypeFromPrimitiveType(primitiveType);
            if (ontType != null && (id = this.base.getTypeEntry((QName)primitiveType).id)) {
                relationType = "XML.hasID";
            }
        } else if (simpleType != null) {
            QName base = this.base.getSimpleTypeBase(simpleType);
            ontType = this.base.getL0TypeFromPrimitiveType(base);
        }
        this.writer.println(String.valueOf(relationName) + " <R " + relationType + ": L0.FunctionalRelation");
        if (!id) {
            if (ontType != null) {
                this.writer.println("   --> " + ontType);
            } else if (primitiveType != null) {
                this.writer.println("   <R " + this.getType(primitiveType, "has"));
            }
        }
    }

    @Override
    public void handleAttributes(SchemaObject simpleTypeObj) {
    }

    @Override
    public void handle(SchemaObject parent, AttributeGroup attributeGroup) {
        if (parent == null) {
            NamedAttributeGroup group = (NamedAttributeGroup)attributeGroup;
            this.writer.println(String.valueOf(this.ontRoot) + this.getAttributeGroupPrefix() + group.getName() + " <T XML.AttributeGroup");
            SchemaObject obj = new SchemaObject(parent, attributeGroup);
            for (Annotated annotated : group.getAttributeOrAttributeGroup()) {
                if (annotated instanceof org.w3._2001.xmlschema.Attribute) {
                    this.handle(obj, (org.w3._2001.xmlschema.Attribute)annotated);
                    continue;
                }
                if (!(annotated instanceof AttributeGroup)) continue;
                this.handle(obj, (AttributeGroup)annotated);
            }
        } else {
            this.writer.println(String.valueOf(this.getName(parent)) + " L0.Inherits " + this.ontRoot + this.getAttributeGroupPrefix() + attributeGroup.getRef().getLocalPart());
        }
    }

    @Override
    public void handleAttributeComposition(SchemaObject parent, AttributeComposition composition, BijectionMap<Attribute, Annotated> attributes) {
        org.w3._2001.xmlschema.Attribute compositionAttribute = new org.w3._2001.xmlschema.Attribute();
        compositionAttribute.setName(composition.getName());
        QName type = new QName("http://www.simantics.org/Layer0", composition.getType());
        compositionAttribute.setType(type);
        this.handle(parent, compositionAttribute);
    }

    @Override
    public void handleSimpleType(SchemaObject parent, SchemaObject simpleTypeObj) {
        SimpleType simpleType = simpleTypeObj.getSimpleType();
        String name = simpleType.getName();
        List list = simpleType.getList();
        if (list != null) {
            String relationName = this.getName(simpleTypeObj, "has");
            this.writer.println(String.valueOf(relationName) + " <R XML.hasAttribute : L0.FunctionalRelation");
            String ontType = this.base.getL0Type(new QName("http://www.w3.org/2001/XMLSchema", "string"));
            this.writer.println("   --> " + ontType);
        } else {
            QName base = this.base.getSimpleTypeBase(simpleType);
            this.writer.println(String.valueOf(this.getName(simpleTypeObj)) + " <T " + this.getType(base, ""));
            String relationName = this.getName(simpleTypeObj, "has");
            this.writer.println(String.valueOf(relationName) + " : L0.FunctionalRelation");
            this.writer.println("   --> " + this.getName(simpleTypeObj));
        }
    }

    @Override
    public void handleComplexType(SchemaObject topLevelComplexType) {
        String name = this.getName(topLevelComplexType);
        SchemaConversionBase.Inheritance inheritance = this.base.getInheritance(topLevelComplexType);
        if (inheritance.additionalClass != null) {
            this.writer.println(String.valueOf(name) + " <T " + inheritance.baseClass + " <T " + inheritance.additionalClass);
        } else if (inheritance.atomicType != null) {
            this.writer.println(String.valueOf(name) + " <T " + inheritance.baseClass + " <T " + inheritance.atomicType.l0Type);
        } else {
            this.writer.println(String.valueOf(name) + " <T " + inheritance.baseClass);
        }
        this.writer.println(String.valueOf(name) + "_List <T XML.ElementList");
        String relationName = this.getName(topLevelComplexType, "has");
        this.writer.println(String.valueOf(relationName) + " <R XML.hasComplexType");
        this.writer.println("   --> " + name);
        this.writer.println(String.valueOf(relationName) + "_List <R XML.hasElementList");
        this.writer.println("   --> " + name + "_List");
        this.writer.println();
        this.base.handleComplexTypeAttributes(topLevelComplexType);
        this.base.handleComplexTypeExtension(topLevelComplexType);
        this.base.handleExtensionAttributes(topLevelComplexType);
        this.writer.println();
    }

    @Override
    public void handleElement(SchemaObject elementObj) {
        QName substitution;
        QName base;
        Element element = elementObj.getElement();
        String name = this.getName(elementObj);
        if ("Text".equals(name)) {
            System.out.println();
        }
        String type = "XML.Element";
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        if (element.getType() != null) {
            types.add(this.getType(element.getType(), ""));
        }
        if ((base = this.base.getElementBase(element)) != null) {
            if (base.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                String l0Type = this.base.getL0Type(base);
                if (l0Type == null) {
                    throw new RuntimeException("Cannot get L0 type for " + base.getLocalPart());
                }
                types.add(l0Type);
            } else if (this.base.isElementRef(base.getLocalPart())) {
                types.add(String.valueOf(this.ontRoot) + base.getLocalPart());
            } else {
                types.add(String.valueOf(this.ontRoot) + this.getComplexTypePrefix() + base.getLocalPart());
            }
        }
        if ((substitution = element.getSubstitutionGroup()) != null) {
            if (this.base.isElementRef(substitution.getLocalPart())) {
                types.add(String.valueOf(this.ontRoot) + substitution.getLocalPart());
            } else {
                types.add(String.valueOf(this.ontRoot) + this.getComplexTypePrefix() + substitution.getLocalPart());
            }
        }
        for (String t : types) {
            type = String.valueOf(type) + " <T " + t;
        }
        String relationName = this.getName(elementObj, "has");
        this.writer.println(String.valueOf(relationName) + " <R XML.hasElement");
        this.writer.println(String.valueOf(relationName) + "_List <R XML.hasElementList");
        this.writer.println(String.valueOf(name) + " <T " + type);
        LocalComplexType complexType = element.getComplexType();
        LocalSimpleType simpleType = element.getSimpleType();
        if (complexType != null) {
            SchemaObject complexTypeObj = this.base.getComplexType(complexType);
            this.base.handleElementComplexTypeAttributes(complexTypeObj);
            this.base.handleComplexTypeExtension(complexTypeObj);
        } else if (simpleType != null) {
            SchemaObject simpleTypeObj = this.base.getSimpleType(simpleType);
            this.base.handleElementSimpleTypeAttributes(simpleTypeObj);
        }
        java.util.List<IDReference> references = this.base.getIDReferences(element);
        for (IDReference ref : references) {
            this.writer.println(String.valueOf(name) + "." + ref.getReference().getName() + " <R XML.hasReference");
        }
        this.writer.println();
    }

    @Override
    public String getBaseClass(SchemaObject.ObjectType type) {
        if (type == SchemaObject.ObjectType.ELEMENT) {
            return "XML.Element";
        }
        if (type == SchemaObject.ObjectType.COMPLEX_TYPE) {
            return "XML.ComplexType";
        }
        throw new RuntimeException("ObjectType " + (Object)((Object)type) + " has no base class");
    }

    @Override
    public String getName(SchemaObject obj) {
        if (obj.getParent() == null) {
            switch (obj.getType()) {
                case COMPLEX_TYPE: {
                    return String.valueOf(this.ontRoot) + this.getComplexTypePrefix() + obj.getName();
                }
                case ELEMENT: {
                    return String.valueOf(this.ontRoot) + obj.getName();
                }
                case ATTRIBUTE_GROUP: {
                    return String.valueOf(this.ontRoot) + this.getAttributeGroupPrefix() + obj.getName();
                }
                case SIMPLE_TYPE: {
                    return String.valueOf(this.ontRoot) + this.getSimpleTypePrefix() + obj.getName();
                }
            }
        } else {
            SchemaObject o = obj;
            SchemaObject prev = null;
            String name = "";
            while (o != null) {
                if (o.getName() != null) {
                    name = String.valueOf(o.getName()) + "." + name;
                }
                prev = o;
                o = o.getParent();
            }
            name = name.substring(0, name.length() - 1);
            switch (prev.getType()) {
                case COMPLEX_TYPE: {
                    return String.valueOf(this.ontRoot) + this.getComplexTypePrefix() + name;
                }
                case ELEMENT: {
                    return String.valueOf(this.ontRoot) + name;
                }
                case ATTRIBUTE_GROUP: {
                    return String.valueOf(this.ontRoot) + this.getAttributeGroupPrefix() + name;
                }
                case SIMPLE_TYPE: {
                    return String.valueOf(this.ontRoot) + this.getSimpleTypePrefix() + name;
                }
            }
        }
        throw new RuntimeException();
    }

    public String getName(SchemaObject parent, SchemaElement e, String rel) {
        QName ref = e.getElement().getRef();
        if (ref != null) {
            return String.valueOf(this.converter.getShortName(ref.getNamespaceURI())) + rel + ref.getLocalPart();
        }
        return String.valueOf(this.getName(parent, "")) + "." + rel + e.getElement().getName();
    }

    public String getName(SchemaObject obj, String rel) {
        if (obj.getParent() == null) {
            switch (obj.getType()) {
                case COMPLEX_TYPE: {
                    return String.valueOf(this.ontRoot) + this.getComplexTypePrefix() + rel + obj.getName();
                }
                case ELEMENT: {
                    return String.valueOf(this.ontRoot) + rel + obj.getName();
                }
                case ATTRIBUTE_GROUP: {
                    return String.valueOf(this.ontRoot) + this.getAttributeGroupPrefix() + rel + obj.getName();
                }
                case SIMPLE_TYPE: {
                    return String.valueOf(this.ontRoot) + this.getSimpleTypePrefix() + rel + obj.getName();
                }
            }
        } else {
            SchemaObject o = obj;
            SchemaObject prev = null;
            String name = "";
            while (o != null) {
                if (o.getName() != null) {
                    name = String.valueOf(o.getName()) + "." + name;
                }
                prev = o;
                o = o.getParent();
            }
            name = name.substring(0, name.length() - 1);
            switch (prev.getType()) {
                case COMPLEX_TYPE: {
                    return String.valueOf(this.ontRoot) + this.getComplexTypePrefix() + rel + name;
                }
                case ELEMENT: {
                    return String.valueOf(this.ontRoot) + rel + name;
                }
                case ATTRIBUTE_GROUP: {
                    return String.valueOf(this.ontRoot) + this.getAttributeGroupPrefix() + rel + name;
                }
                case SIMPLE_TYPE: {
                    return String.valueOf(this.ontRoot) + this.getSimpleTypePrefix() + rel + name;
                }
            }
        }
        throw new RuntimeException();
    }
}

