/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class OntologyCombinator {
    public static void combine(File[] inputFiles, File outputFile) throws IOException {
        HashSet<String> resources = new HashSet<String>();
        ArrayList<String> ontologyUris = new ArrayList<String>();
        ArrayList<String> classNames = new ArrayList<String>();
        String packageLine = null;
        String packageLineStart = "package";
        String resourceLineStart = "public final Resource ";
        String uriLineStart = "public static final String ";
        File[] fileArray = inputFiles;
        int n = inputFiles.length;
        int n2 = 0;
        while (n2 < n) {
            block19: {
                File inputFile = fileArray[n2];
                try (BufferedReader reader = new BufferedReader(new FileReader(inputFile));){
                    String line;
                    String uri = null;
                    String filename = inputFile.getName();
                    String classname = filename.substring(0, filename.length() - 5);
                    classNames.add(classname);
                    block7: while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).startsWith(resourceLineStart)) {
                            String res = line.substring(resourceLineStart.length(), line.length() - 1);
                            resources.add(res);
                            continue;
                        }
                        if (line.startsWith(uriLineStart)) {
                            String euri = line.substring(line.indexOf(34) + 1, line.length() - 2);
                            if (uri == null) {
                                uri = euri;
                                continue;
                            }
                            int max = Math.min(euri.length(), uri.length());
                            int i = 0;
                            while (i < max) {
                                if (euri.charAt(i) != uri.charAt(i)) {
                                    uri = uri.substring(0, i);
                                    continue block7;
                                }
                                ++i;
                            }
                            continue;
                        }
                        if (!line.startsWith(packageLineStart)) continue;
                        packageLine = line;
                    }
                    if (uri != null && uri.length() > 6) {
                        if (uri.endsWith("/")) {
                            uri = uri.substring(0, uri.length() - 1);
                        }
                        ontologyUris.add(uri);
                        break block19;
                    }
                    throw new IOException("Could not resolve ontology uri for file " + inputFile.getName());
                }
            }
            ++n2;
        }
        ArrayList<String> sortedResourcses = new ArrayList<String>();
        sortedResourcses.addAll(resources);
        Collections.sort(sortedResourcses);
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        String className = outputFile.getName();
        int dp = className.indexOf(".");
        if (dp > 0) {
            className = className.substring(0, dp);
        }
        try {
            writer.println(packageLine);
            writer.println();
            writer.println("import java.lang.reflect.Field;");
            writer.println("import java.util.Collection;");
            writer.println("import java.util.HashMap;");
            writer.println("import java.util.Map;");
            writer.println("import org.simantics.Simantics;");
            writer.println("import org.simantics.db.ReadGraph;");
            writer.println("import org.simantics.db.Resource;");
            writer.println("import org.simantics.db.exception.DatabaseException;");
            writer.println("import org.simantics.db.request.Read;");
            writer.println("import org.simantics.layer0.Layer0;");
            writer.println();
            writer.println();
            writer.println("public class " + className + " {");
            writer.println("  private static boolean init = false;");
            writer.println("  private static Map<Resource, Object> resourceObjects = new HashMap<>();");
            writer.println("  private static Map<Resource, " + className + "> loaderObjects = new HashMap<>();");
            writer.println();
            writer.println("  private Resource ontologyResource;");
            writer.println("  private Object resourceObject;");
            writer.println();
            writer.println("  static void init(ReadGraph graph) throws DatabaseException{");
            writer.println("     if (init)");
            writer.println("       return;");
            writer.println("     ");
            int i = 0;
            while (i < inputFiles.length) {
                writer.println("     add(graph.getResource(\"" + (String)ontologyUris.get(i) + "\"), " + (String)classNames.get(i) + ".getInstance(graph));");
                ++i;
            }
            writer.println("     ");
            writer.println("     init = true;");
            writer.println("  }");
            writer.println("  ");
            writer.println("  public static void add(Resource resource, Object object) {");
            writer.println("     if (resource == null || object == null)");
            writer.println("        throw new IllegalArgumentException();");
            writer.println("     resourceObjects.put(resource, object);");
            writer.println("     loaderObjects.put(resource, new " + className + "(resource, object));");
            writer.println("  }");
            writer.println("  ");
            writer.println("  public static " + className + " getOntology(final Resource res) throws DatabaseException {");
            writer.println("    return Simantics.getSession().syncRequest(new Read<" + className + ">() {");
            writer.println("        @Override");
            writer.println("        public " + className + " perform(ReadGraph graph) throws DatabaseException {");
            writer.println("          return getOntology(graph, res);");
            writer.println("        }");
            writer.println("    });");
            writer.println("  }");
            writer.println("  ");
            writer.println("  public static " + className + " getOntology(ReadGraph graph, Resource res) throws DatabaseException{");
            writer.println("     init(graph);");
            writer.println("     Layer0 L0 = Layer0.getInstance(graph);");
            writer.println("     Collection<Resource> types = graph.getTypes(res);");
            writer.println("     for (Resource type : types) {");
            writer.println("        Resource part = graph.getPossibleObject(type, L0.PartOf);");
            writer.println("        while (part != null) {");
            writer.println("          if (loaderObjects.containsKey(part))");
            writer.println("             return loaderObjects.get(part);");
            writer.println("          part = graph.getPossibleObject(part, L0.PartOf);");
            writer.println("        }");
            writer.println("     }");
            writer.println("     return null;");
            writer.println("  }");
            writer.println("  ");
            writer.println("  private " + className + "(Resource ontologyRes, Object resourceObject) {");
            writer.println("     this.ontologyResource = ontologyRes;");
            writer.println("     this.resourceObject = resourceObject;");
            writer.println("     init();");
            writer.println("  }");
            writer.println("  ");
            writer.println("  private Resource get(String name)  {");
            writer.println("    try {");
            writer.println("      Field field = resourceObject.getClass().getDeclaredField(name);");
            writer.println("      return (Resource)field.get(resourceObject);");
            writer.println("    } catch (Exception e){");
            writer.println("      return null;");
            writer.println("    }");
            writer.println("  }");
            writer.println("  ");
            for (String s : sortedResourcses) {
                writer.println("  public Resource " + s + ";");
            }
            writer.println("  ");
            writer.println("  private void init() {");
            for (String s : sortedResourcses) {
                writer.println("  \t" + s + " = get(\"" + s + "\");");
            }
            writer.println("  }");
            writer.println("}");
        }
        finally {
            writer.close();
        }
    }
}

