/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.base;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.message.ILogger;
import org.simantics.xml.sax.base.WriterElement;
import org.simantics.xml.sax.base.XMLElementNamedChildWriter;
import org.simantics.xml.sax.base.XMLElementWriter;
import org.simantics.xml.sax.base.XMLNSElementWriter;
import org.simantics.xml.sax.base.XMLNSNamedChildWriter;
import org.simantics.xml.sax.base.XMLParser;
import org.simantics.xml.sax.ontology.XMLResource;

public class XMLWriter {
    public static String XML_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    public static String XML_SCHEMA_INSTANCE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private ReadGraph graph;
    private Map<Resource, XMLWriter> subWriters = new HashMap<Resource, XMLWriter>();
    private Map<Class<? extends XMLElementWriter>, XMLElementWriter> namedWriters = new HashMap<Class<? extends XMLElementWriter>, XMLElementWriter>();
    private Map<Resource, XMLElementWriter> writers = new HashMap<Resource, XMLElementWriter>();
    private String schemaURI;
    private String ontologyURI;
    private Resource ontology;
    private ILogger logger;

    public ReadGraph getGraph() {
        return this.graph;
    }

    public void setGraph(ReadGraph graph) throws DatabaseException {
        this.graph = graph;
        for (XMLWriter p : this.subWriters.values()) {
            p.setGraph(graph);
        }
        if (this.ontologyURI != null) {
            this.ontology = graph.getResource(this.ontologyURI);
        }
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    public void setSchemaURI(String schemaURI) {
        this.schemaURI = schemaURI;
    }

    public String getOntologyURI() {
        return this.ontologyURI;
    }

    public void setOntologyURI(String ontologyURI) {
        this.ontologyURI = ontologyURI;
    }

    public Resource getOntology() {
        return this.ontology;
    }

    public void add(XMLElementWriter writer) throws DatabaseException {
        Resource type = writer.getType(this.graph);
        if (type != null) {
            this.writers.put(type, writer);
        }
        this.namedWriters.put(writer.getClass(), writer);
    }

    public void add(XMLWriter writer) {
        this.subWriters.put(writer.getOntology(), writer);
    }

    public void write(Resource root, XMLStreamWriter writer) throws DatabaseException, XMLStreamException {
        WriterElement element = new WriterElement(root);
        this.loadElement(element);
        this.write(element, writer);
    }

    protected void write(WriterElement instance, XMLStreamWriter writer) throws DatabaseException, XMLStreamException {
        WriterElement child;
        XMLResource XML = XMLResource.getInstance((ReadGraph)this.graph);
        XMLElementWriter elementWriter = instance.writer;
        elementWriter.start(this.graph, instance, writer);
        if (instance.parent == null) {
            if (this.getSchemaURI() != null) {
                writer.writeDefaultNamespace(this.getSchemaURI());
            }
            writer.writeNamespace("xsd", XML_SCHEMA_URI);
            writer.writeNamespace("xsi", XML_SCHEMA_INSTANCE_URI);
        }
        elementWriter.attributes(this.graph, instance, this.graph.getStatements(instance.instance, XML.hasAttribute), writer);
        if (this.graph.hasValue(instance.instance)) {
            elementWriter.characters(this.graph, instance, writer);
        }
        HashSet childElements = new HashSet();
        childElements.addAll(this.graph.getStatements(instance.instance, XML.hasElement));
        childElements.addAll(this.graph.getStatements(instance.instance, XML.hasComplexType));
        HashMap<Resource, WriterElement> elementMap = new HashMap<Resource, WriterElement>();
        for (Statement s : childElements) {
            WriterElement c = new WriterElement(instance, s);
            this.loadElement(c);
            elementMap.put(s.getObject(), c);
        }
        LinkedHashSet<Resource> sorted = new LinkedHashSet<Resource>();
        if (this.graph.hasStatement(instance.instance, XML.hasOriginalElementList)) {
            Resource originalList = this.graph.getSingleObject(instance.instance, XML.hasOriginalElementList);
            List l = ListUtils.toList((ReadGraph)this.graph, (Resource)originalList);
            sorted.addAll(l);
        }
        elementWriter.children(this.graph, instance, sorted);
        HashSet<Resource> processed = new HashSet<Resource>();
        for (Resource r : sorted) {
            if (processed.contains(r)) continue;
            child = (WriterElement)elementMap.get(r);
            if (child == null) {
                throw new DatabaseException("Trying to export unregonized resource " + NameUtils.getSafeName((ReadGraph)this.graph, (Resource)r) + " " + r);
            }
            this.write(child, writer);
            processed.add(r);
        }
        for (Statement stm : childElements) {
            if (processed.contains(stm.getObject())) continue;
            child = (WriterElement)elementMap.get(stm.getObject());
            if (child == null) {
                throw new DatabaseException("Trying to export unregonized resource " + NameUtils.getSafeName((ReadGraph)this.graph, (Resource)stm.getObject()) + " " + stm.getObject());
            }
            this.write(child, writer);
        }
        elementWriter.end(this.graph, instance, writer);
    }

    private void loadElement(WriterElement child) throws DatabaseException {
        Resource type;
        XMLElementWriter childWriter = null;
        if (child.parent != null && child.parent.writer instanceof XMLElementNamedChildWriter) {
            XMLElementNamedChildWriter namedParentWriter = (XMLElementNamedChildWriter)child.parent.writer;
            Class<? extends XMLElementWriter> childWriterClass = namedParentWriter.getWriter(this.graph, this.writers, child);
            if (childWriterClass != null && (childWriter = this.writers.get(childWriterClass)) == null) {
                try {
                    Constructor<? extends XMLElementWriter> c = null;
                    try {
                        c = childWriterClass.getConstructor(ReadGraph.class);
                        childWriter = c.newInstance(this.graph);
                    }
                    catch (NoSuchMethodException e) {
                        c = childWriterClass.getConstructor(new Class[0]);
                        childWriter = c.newInstance(new Object[0]);
                    }
                    this.namedWriters.put(childWriterClass, childWriter);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    String err = "Error processing " + childWriterClass.getName() + " : element writers must have accessible constructor with ReadGraph parameter";
                    this.logger.log((IStatus)new Status(4, XMLParser.PLUGIN_ID, err, (Throwable)e));
                }
            }
        } else {
            type = this.graph.getSingleType(child.instance);
            childWriter = this.writers.get(type);
        }
        if (childWriter == null) {
            XMLWriter xmlWriter;
            type = this.graph.getSingleType(child.instance);
            Resource ontology = this.getOntology(type);
            if (ontology != null && (xmlWriter = this.subWriters.get(ontology)) != null && (childWriter = xmlWriter.writers.get(type)) != null) {
                childWriter = childWriter instanceof XMLElementNamedChildWriter ? new XMLNSNamedChildWriter((XMLElementNamedChildWriter)childWriter, xmlWriter.schemaURI) : new XMLNSElementWriter(childWriter, xmlWriter.schemaURI);
            }
            if (childWriter == null) {
                throw new DatabaseException("Cannot locate writer for " + NameUtils.getSafeName((ReadGraph)this.graph, (Resource)child.instance) + ", " + child.instance);
            }
        }
        child.writer = childWriter;
    }

    private Resource getOntology(Resource type) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)this.graph);
        Resource r = type;
        while ((r = this.graph.getPossibleObject(r, L0.PartOf)) == null || !this.graph.isInstanceOf(r, L0.Ontology)) {
        }
        return r;
    }
}

