/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.test.GraphChanges;

public abstract class UpdateOp {
    private GraphChanges changes;
    private boolean selected = false;
    private boolean manualSelection = false;
    protected boolean applied = false;
    protected boolean visible = true;
    private Collection<UpdateOp> parentOps = new ArrayList<UpdateOp>();
    private Collection<UpdateOp> subOps = new ArrayList<UpdateOp>();

    public UpdateOp(GraphChanges changes) {
        this.changes = changes;
    }

    public Collection<UpdateOp> getParentOps() {
        return this.parentOps;
    }

    public Collection<UpdateOp> getSubOps() {
        return this.subOps;
    }

    public void addParentOp(UpdateOp op) {
        assert (!op.equals(this));
        this.parentOps.add(op);
    }

    public void addSubOp(UpdateOp op) {
        assert (!op.equals(this));
        this.subOps.add(op);
    }

    public void removeParentOp(UpdateOp op) {
        this.parentOps.remove(op);
    }

    public void removeSubOp(UpdateOp op) {
        this.subOps.remove(op);
    }

    public GraphChanges getChanges() {
        return this.changes;
    }

    public abstract boolean isAdd();

    public abstract boolean isDelete();

    public boolean isChange() {
        return this.isAdd() || this.isDelete();
    }

    public abstract boolean requiresParentOps();

    public abstract boolean requiresSubOps();

    public boolean selectParentOps() {
        return this.requiresParentOps();
    }

    public boolean selectSubOps() {
        return this.requiresSubOps();
    }

    public boolean select(boolean select) {
        boolean b = this._select(select);
        if (b) {
            this.manualSelection = true;
        }
        return b;
    }

    private boolean _select(boolean select) {
        if (select == this.selected) {
            return true;
        }
        if (this.applied) {
            return false;
        }
        if (select) {
            if (this.selectParentOps()) {
                for (UpdateOp op : this.parentOps) {
                    op._select(true);
                }
            }
            this.selected = true;
            this.manualSelection = false;
            if (this.selectSubOps()) {
                for (UpdateOp op : this.subOps) {
                    op._select(true);
                }
            }
        } else {
            this.selected = false;
            this.manualSelection = false;
            for (UpdateOp op : this.subOps) {
                if (op.selectParentOps()) {
                    op._select(false);
                    continue;
                }
                if (op.manualSelection) continue;
                op._select(false);
            }
            for (UpdateOp op : this.parentOps) {
                if (!op.selectSubOps()) continue;
                op._select(false);
            }
            return true;
        }
        return false;
    }

    public boolean selected() {
        return this.selected;
    }

    public boolean applied() {
        return this.applied;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void apply(WriteGraph g) throws DatabaseException {
        if (this.applied) {
            return;
        }
        this._apply(g);
        this.applied = true;
    }

    protected abstract void _apply(WriteGraph var1) throws DatabaseException;

    public abstract Resource getResource();

    public abstract Statement getStatement();

    public abstract Resource getCreatedResource();
}

