/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.layer0.Layer0;
import org.simantics.plant3d.ontology.Plant3D;
import org.simantics.plant3d.scenegraph.Equipment;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import org.simantics.plant3d.scenegraph.controlpoint.PipingRules;
import org.simantics.plant3d.utils.Item;

public class P3DUtil {
    public static List<Item> getEquipments() throws DatabaseException {
        return P3DUtil.getEquipments("http://www.simantics.org/Plant3D-0.1/Builtin");
    }

    public static List<Item> getEquipments(final String libUri) throws DatabaseException {
        return (List)Simantics.getSession().syncRequest((Read)new Read<List<Item>>(){

            public List<Item> perform(ReadGraph graph) throws DatabaseException {
                Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
                Resource project = (Resource)Simantics.getProject().get();
                Resource builtins = graph.getResource(libUri);
                List actions = P3DUtil.getItems(graph, project, p3d.Equipment);
                actions.addAll(P3DUtil.getItems(graph, builtins, p3d.Equipment));
                return actions;
            }
        });
    }

    public static List<Item> getNozzles(final String libUri) throws DatabaseException {
        return (List)Simantics.getSession().syncRequest((Read)new Read<List<Item>>(){

            public List<Item> perform(ReadGraph graph) throws DatabaseException {
                Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
                ItemQuery query = new ItemQuery(p3d.Nozzle, libUri);
                return (List)graph.syncRequest((Read)query);
            }
        });
    }

    public static List<Item> getEnds(final String libUri) throws DatabaseException {
        return (List)Simantics.getSession().syncRequest((Read)new Read<List<Item>>(){

            public List<Item> perform(ReadGraph graph) throws DatabaseException {
                Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
                ItemQuery query = new ItemQuery(p3d.EndComponent, libUri);
                return (List)graph.syncRequest((Read)query);
            }
        });
    }

    public static List<Item> getTurns(final String libUri) throws DatabaseException {
        return (List)Simantics.getSession().syncRequest((Read)new Read<List<Item>>(){

            public List<Item> perform(ReadGraph graph) throws DatabaseException {
                Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
                ItemQuery query = new ItemQuery(p3d.TurnComponent, libUri);
                return (List)graph.syncRequest((Read)query);
            }
        });
    }

    public static List<Item> getInlines(final String libUri) throws DatabaseException {
        return (List)Simantics.getSession().syncRequest((Read)new Read<List<Item>>(){

            public List<Item> perform(ReadGraph graph) throws DatabaseException {
                Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
                ItemQuery query = new ItemQuery(p3d.InlineComponent, libUri);
                return (List)graph.syncRequest((Read)query);
            }
        });
    }

    public static List<Item> filterUserComponents(List<Item> items) {
        ArrayList<Item> result = new ArrayList<Item>(items.size());
        for (Item i : items) {
            if (i.isCode()) continue;
            result.add(i);
        }
        return result;
    }

    private static List<Item> getItems(ReadGraph graph, Resource lib, Resource type) throws DatabaseException {
        Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ArrayList<Item> result = new ArrayList<Item>();
        HashSet<Resource> processed = new HashSet<Resource>();
        ArrayDeque stack = new ArrayDeque();
        stack.addAll(graph.getObjects(lib, l0.ConsistsOf));
        stack.addAll(graph.getObjects(lib, p3d.ComponentLibrary_contains));
        while (!stack.isEmpty()) {
            Resource geom;
            Resource r = (Resource)stack.pop();
            if (processed.contains(r)) continue;
            processed.add(r);
            if (graph.isInstanceOf(r, type) && ((geom = graph.getPossibleObject(r, p3d.hasGeometry)) != null || graph.hasStatement(r, p3d.NonVisibleComponent))) {
                result.add(P3DUtil.createItem(graph, r));
                continue;
            }
            if (graph.isInheritedFrom(r, type)) {
                boolean asserts = false;
                for (Resource a : graph.getObjects(r, l0.Asserts)) {
                    if (!p3d.hasGeometry.equals(graph.getPossibleObject(a, l0.HasPredicate))) continue;
                    asserts = true;
                    break;
                }
                if (asserts) {
                    result.add(P3DUtil.createItem(graph, r));
                    continue;
                }
            }
            if (!graph.isInstanceOf(r, p3d.ComponentLibrary)) continue;
            stack.addAll(graph.getObjects(r, l0.ConsistsOf));
            stack.addAll(graph.getObjects(r, p3d.ComponentLibrary_contains));
        }
        Collections.sort(result, new Comparator<Item>(){

            @Override
            public int compare(Item o1, Item o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }

    public static Item createItem(ReadGraph graph, Resource r) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
        String name = (String)graph.getRelatedValue(r, l0.HasName);
        String uri = graph.getURI(r);
        Item item = new Item(uri, name);
        if (graph.isInstanceOf(r, p3d.Equipment)) {
            item.setType(Item.Type.EQUIPMENT);
        } else if (graph.isInstanceOf(r, p3d.InlineComponent)) {
            item.setType(Item.Type.INLINE);
        } else if (graph.isInstanceOf(r, p3d.EndComponent)) {
            item.setType(Item.Type.END);
        } else if (graph.isInstanceOf(r, p3d.TurnComponent)) {
            item.setType(Item.Type.TURN);
        } else if (graph.isInstanceOf(r, p3d.Nozzle)) {
            item.setType(Item.Type.NOZZLE);
        } else {
            throw new RuntimeException("Cannot detect type for " + r);
        }
        if (graph.hasStatement(r, p3d.CodeComponent)) {
            item.setCode(true);
        }
        if (graph.hasStatement(r, p3d.VariableAngleTurnComponent) || graph.hasStatement(r, p3d.VariableLengthInlineComponent)) {
            item.setVariable(true);
        }
        if (graph.hasStatement(r, p3d.AdjustableLengthInlineComponent)) {
            item.setModifiable(true);
        }
        if (graph.hasStatement(r, p3d.SizeChangeComponent)) {
            item.setSizeChange(true);
        }
        if (graph.hasStatement(r, p3d.RotateComponent)) {
            item.setRotated(true);
        }
        return item;
    }

    public static Resource createModel(WriteGraph graph, String name) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
        Resource model = graph.newResource();
        graph.claim(model, l0.InstanceOf, p3d.Plant);
        graph.claimLiteral(model, l0.HasName, (Object)name);
        return model;
    }

    public static void finalizeDBLoad(P3DRootNode rootNode) throws Exception {
        for (INode node : rootNode.getChild()) {
            if (node instanceof PipeRun) {
                for (PipelineComponent pipelineComponent : ((PipeRun)node).getChild()) {
                    pipelineComponent.sync();
                }
                continue;
            }
            if (!(node instanceof Equipment)) continue;
            for (PipelineComponent pipelineComponent : ((Equipment)node).getChild()) {
                pipelineComponent.sync();
            }
        }
        for (INode node : rootNode.getChild()) {
            if (node instanceof PipeRun) {
                for (PipelineComponent pipelineComponent : ((PipeRun)node).getChild()) {
                    pipelineComponent.sync2();
                }
                continue;
            }
            if (!(node instanceof Equipment)) continue;
            for (PipelineComponent pipelineComponent : ((Equipment)node).getChild()) {
                pipelineComponent.sync2();
            }
        }
        for (INode node : rootNode.getChild()) {
            if (!(node instanceof PipeRun)) continue;
            PipingRules.validate((PipeRun)node);
        }
    }

    public static void finalizeDBLoad2(P3DRootNode rootNode) throws Exception {
        PipingRules.setEnabled(true);
        for (INode node : rootNode.getChild()) {
            if (!(node instanceof PipeRun)) continue;
            PipeRun run = (PipeRun)node;
            for (PipeControlPoint pcp : run.getControlPoints()) {
                if (!pcp.asPathLegEnd()) continue;
                PipingRules.requestUpdate(pcp);
            }
        }
        PipingRules.update();
    }

    public static class ItemQuery
    implements Read<List<Item>> {
        private Resource type;
        private String libUri;

        public ItemQuery(Resource type, String libUri) {
            this.type = type;
            this.libUri = libUri;
        }

        public List<Item> perform(ReadGraph graph) throws DatabaseException {
            Resource builtins = graph.getResource(this.libUri);
            ArrayList<Item> actions = new ArrayList<Item>();
            actions.addAll(P3DUtil.getItems(graph, builtins, this.type));
            return actions;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ItemQuery other = (ItemQuery)obj;
            if (!this.type.equals(other.type)) {
                return false;
            }
            return this.libUri.equals(other.libUri);
        }

        public int hashCode() {
            return this.type.hashCode() + this.libUri.hashCode();
        }
    }
}

