/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.scenegraph.GeometryProvider;
import org.simantics.g3d.scenegraph.ParametricGeometryProvider;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.layer0.Layer0;
import org.simantics.plant3d.geometry.ParameterRead;
import org.simantics.plant3d.ontology.Plant3D;
import org.simantics.plant3d.scenegraph.EndComponent;
import org.simantics.plant3d.scenegraph.Equipment;
import org.simantics.plant3d.scenegraph.InlineComponent;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.TurnComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import org.simantics.plant3d.scenegraph.controlpoint.PipingRules;
import org.simantics.plant3d.utils.Item;

public class ComponentUtils {
    private static Map<String, Class<? extends PipelineComponent>> clazzes = new HashMap<String, Class<? extends PipelineComponent>>();
    private static Map<String, GeometryProvider> providers = new HashMap<String, GeometryProvider>();
    private static Map<String, String> names = new HashMap<String, String>();

    public static void preloadCache() {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                ArrayList<String> types = new ArrayList<String>();
                types.add("http://www.simantics.org/Plant3D-0.1/Builtin/Straight");
                types.add("http://www.simantics.org/Plant3D-0.1/Builtin/Elbow");
                types.add("http://www.simantics.org/Plant3D-0.1/Builtin/ConcentricReducer");
                types.add("http://www.simantics.org/Plant3D-0.1/Builtin/BranchSplitComponent");
                types.add("http://www.simantics.org/Plant3D-0.1/Builtin/EccentricReducer");
                types.add("http://www.simantics.org/Plant3D-0.1/Builtin/Elbow45");
                types.add("http://www.simantics.org/Plant3D-0.1/Builtin/Elbow90");
                for (String typeURI : types) {
                    ComponentUtils.load(graph, typeURI);
                }
            }
        });
    }

    private static GeometryProvider getProvider(ReadGraph graph, Resource type) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
        Resource geom = graph.getPossibleObject(type, p3d.hasGeometry);
        if (geom == null) {
            for (Resource a : graph.getObjects(type, l0.Asserts)) {
                if (!p3d.hasGeometry.equals(graph.getPossibleObject(a, l0.HasPredicate))) continue;
                geom = graph.getPossibleObject(a, l0.HasObject);
                break;
            }
        }
        if (geom != null) {
            Map params;
            GeometryProvider provider = (GeometryProvider)graph.adapt(geom, GeometryProvider.class);
            if (provider instanceof ParametricGeometryProvider && (params = (Map)graph.syncRequest((Read)new ParameterRead(type))).size() > 0) {
                ((ParametricGeometryProvider)provider).setProperties(params);
            }
            return provider;
        }
        return null;
    }

    private static Class<? extends PipelineComponent> getClazz(ReadGraph graph, Resource type) throws DatabaseException {
        Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
        if (graph.isInheritedFrom(type, p3d.InlineComponent)) {
            return InlineComponent.class;
        }
        if (graph.isInheritedFrom(type, p3d.TurnComponent)) {
            return TurnComponent.class;
        }
        if (graph.isInheritedFrom(type, p3d.EndComponent)) {
            return EndComponent.class;
        }
        if (graph.isInheritedFrom(type, p3d.Nozzle)) {
            return Nozzle.class;
        }
        return null;
    }

    private static void load(ReadGraph graph, String typeURI) throws DatabaseException {
        Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
        Resource type = graph.getResource(typeURI);
        GeometryProvider provider = ComponentUtils.getProvider(graph, type);
        if (provider != null || graph.hasStatement(type, p3d.NonVisibleComponent)) {
            providers.put(typeURI, provider);
            if (graph.isInheritedFrom(type, p3d.PipelineComponent)) {
                clazzes.put(typeURI, ComponentUtils.getClazz(graph, type));
            }
            names.put(typeURI, NameUtils.getSafeName((ReadGraph)graph, (Resource)type));
            return;
        }
        throw new DatabaseException("Cannot find component for " + typeURI);
    }

    private static void load(final String typeURI) throws DatabaseException {
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                ComponentUtils.load(graph, typeURI);
            }
        });
    }

    public static PipelineComponent createComponent(P3DRootNode root, String typeURI) throws Exception {
        Class<? extends PipelineComponent> type = clazzes.get(typeURI);
        GeometryProvider provider = providers.get(typeURI);
        if (type == null || provider == null) {
            ComponentUtils.load(typeURI);
            type = clazzes.get(typeURI);
            provider = providers.get(typeURI);
        }
        PipelineComponent component = null;
        if (type == InlineComponent.class) {
            component = root.createInline();
        } else if (type == TurnComponent.class) {
            component = root.createTurn();
        } else if (type == EndComponent.class) {
            component = root.createTurn();
        } else if (type == Nozzle.class) {
            component = root.createNozzle();
        }
        ((PipelineComponent)component).setType(typeURI);
        component.setGeometry(provider);
        return component;
    }

    public static Equipment createEquipment(P3DRootNode root, String typeURI) throws Exception {
        GeometryProvider provider = providers.get(typeURI);
        if (provider == null) {
            ComponentUtils.load(typeURI);
            provider = providers.get(typeURI);
        }
        Equipment equipment = root.createEquipment();
        equipment.setType(typeURI);
        equipment.setGeometry(provider);
        root.addChild((INode)equipment);
        return equipment;
    }

    public static Equipment createEquipmentWithNozzles(P3DRootNode root, String typeURI, String nozzleTypeUri) throws Exception {
        GeometryProvider provider = providers.get(typeURI);
        if (provider == null) {
            ComponentUtils.load(typeURI);
            provider = providers.get(typeURI);
        }
        Equipment equipment = root.createEquipment();
        equipment.setType(typeURI);
        equipment.setGeometry(provider);
        root.addChild((INode)equipment);
        int i = 0;
        while (i < equipment.numberOfFixedNozzles()) {
            ComponentUtils.createNozzle(root, equipment, new Item(nozzleTypeUri, "Nozzle"));
            ++i;
        }
        return equipment;
    }

    public static InlineComponent createStraight(P3DRootNode root) throws Exception {
        InlineComponent component = root.createInline();
        component.setType("http://www.simantics.org/Plant3D-0.1/Builtin/Straight");
        component.setGeometry(providers.get("http://www.simantics.org/Plant3D-0.1/Builtin/Straight"));
        return component;
    }

    public static TurnComponent createTurn(P3DRootNode root) throws Exception {
        TurnComponent elbow = root.createTurn();
        elbow.setType("http://www.simantics.org/Plant3D-0.1/Builtin/Elbow");
        elbow.setGeometry(providers.get("http://www.simantics.org/Plant3D-0.1/Builtin/Elbow"));
        return elbow;
    }

    public static InlineComponent createReducer(P3DRootNode root) throws Exception {
        InlineComponent component = root.createInline();
        component.setType("http://www.simantics.org/Plant3D-0.1/Builtin/ConcentricReducer");
        component.setGeometry(providers.get("http://www.simantics.org/Plant3D-0.1/Builtin/ConcentricReducer"));
        return component;
    }

    public static InlineComponent createBranchSplit(P3DRootNode root) throws Exception {
        InlineComponent component = root.createInline();
        component.setType("http://www.simantics.org/Plant3D-0.1/Builtin/BranchSplitComponent");
        return component;
    }

    public static Equipment createEquipment(P3DRootNode root, Item equipmentType) throws Exception {
        Equipment equipment = ComponentUtils.createEquipment(root, equipmentType.getUri());
        String n = root.getUniqueName(equipmentType.getName());
        equipment.setName(n);
        return equipment;
    }

    public static Equipment createEquipmentWithNozzles(P3DRootNode root, Item equipmentType, Item nozzleType) throws Exception {
        Equipment equipment = ComponentUtils.createEquipmentWithNozzles(root, equipmentType.getUri(), nozzleType.getUri());
        String n = root.getUniqueName(equipmentType.getName());
        equipment.setName(n);
        return equipment;
    }

    public static Nozzle createDefaultNozzle(P3DRootNode root, Equipment equipment) throws Exception {
        return ComponentUtils.createNozzle(root, equipment, new Item("http://www.simantics.org/Plant3D-0.1/Builtin/Nozzle", "Nozzle"));
    }

    public static Nozzle createNozzle(P3DRootNode root, Equipment equipment, Item nozzleType) throws Exception {
        Nozzle nozzle = root.createNozzle();
        nozzle.setType(nozzleType.getUri());
        String n = root.getUniqueName(nozzleType.getName());
        nozzle.setName(n);
        PipeRun pipeRun = new PipeRun();
        n = root.getUniqueName("PipeRun");
        pipeRun.setName(n);
        nozzle.setPipeRun(pipeRun);
        equipment.addChild(nozzle);
        root.addChild((INode)pipeRun);
        return nozzle;
    }

    public static PipelineComponent addComponent(P3DRootNode root, PipelineComponent component, InsertInstruction inst) throws Exception {
        PipelineComponent newComponent = ComponentUtils.createComponent(root, inst.typeUri);
        PipeControlPoint newPcp = newComponent.getControlPoint();
        PipeControlPoint toPcp = component.getControlPoint();
        PipeRun pipeRun = toPcp.getPipeRun();
        String typeName = names.get(inst.typeUri);
        if (typeName == null) {
            typeName = "Component";
        }
        Vector3d dir = null;
        Vector3d pos = null;
        PipeControlPoint.PositionType position = inst.position;
        PipeControlPoint.PositionType insertPosition = inst.insertPosition;
        boolean lengthAdjustable = false;
        if (newComponent instanceof InlineComponent) {
            lengthAdjustable = ((InlineComponent)newComponent).isVariableLength() || ((InlineComponent)newComponent).isModifialble();
        }
        boolean insertAdjustable = false;
        if (component instanceof InlineComponent) {
            insertAdjustable = ((InlineComponent)component).isVariableLength();
        }
        boolean sizeChange = false;
        if (newComponent instanceof InlineComponent) {
            sizeChange = ((InlineComponent)newComponent).isSizeChange();
        }
        if (toPcp.isInline()) {
            switch (position) {
                case NEXT: {
                    if (!toPcp.isDualInline()) break;
                    toPcp = toPcp.getDualSub();
                    pipeRun = toPcp.getPipeRun();
                    break;
                }
                case PREVIOUS: {
                    if (!toPcp.isDualSub()) break;
                    toPcp = toPcp.parent;
                    pipeRun = toPcp.getPipeRun();
                    break;
                }
            }
            Vector3d start = new Vector3d();
            Vector3d end = new Vector3d();
            dir = new Vector3d();
            toPcp.getInlineControlPointEnds((Tuple3d)start, (Tuple3d)end, dir);
            dir.normalize();
            switch (position) {
                case NEXT: {
                    pos = new Vector3d(end);
                    break;
                }
                case PREVIOUS: {
                    pos = new Vector3d(start);
                    break;
                }
                case SPLIT: {
                    pos = new Vector3d(toPcp.getWorldPosition());
                    break;
                }
            }
        } else if (toPcp.isDirected()) {
            dir = new Vector3d(toPcp.getDirection(PipeControlPoint.Direction.NEXT));
            pos = new Vector3d(toPcp.getWorldPosition());
        } else if (toPcp.isTurn() && toPcp.asFixedAngle()) {
            Vector3d v;
            dir = new Vector3d(toPcp.getDirection(position == PipeControlPoint.PositionType.NEXT ? PipeControlPoint.Direction.NEXT : PipeControlPoint.Direction.PREVIOUS));
            pos = new Vector3d(toPcp.getWorldPosition());
            if (!lengthAdjustable) {
                v = new Vector3d(dir);
                v.scale(toPcp.getInlineLength());
                pos.add((Tuple3d)v);
            } else if (insertPosition == PipeControlPoint.PositionType.NEXT) {
                v = new Vector3d(dir);
                v.scale(toPcp.getInlineLength());
                pos.add((Tuple3d)v);
            } else if (insertPosition == PipeControlPoint.PositionType.SPLIT) {
                v = new Vector3d(dir);
                v.scale(toPcp.getInlineLength() * 0.5);
                pos.add((Tuple3d)v);
            }
        }
        String name = component.getPipeRun().getUniqueName(typeName);
        newComponent.setName(name);
        pipeRun.addChild(newComponent);
        if (newPcp.isSizeChange()) {
            newComponent.setAlternativePipeRun(pipeRun);
        }
        if (newComponent instanceof InlineComponent) {
            InlineComponent inlineComponent = (InlineComponent)newComponent;
            if (inlineComponent.isVariableLength() || inlineComponent.isModifialble()) {
                newPcp.setLength(inst.length);
                newComponent.setParameter("length", inst.length);
            }
            if (inst.rotationAngle != null) {
                ((InlineComponent)newComponent).setRotationAngle(inst.rotationAngle);
            }
        } else if (newComponent instanceof TurnComponent) {
            TurnComponent turnComponent = (TurnComponent)newComponent;
            if (turnComponent.isVariableAngle()) {
                newPcp.setTurnAngle(inst.angle);
                newComponent.setParameter("turnAngle", inst.angle);
            }
            if (inst.rotationAngle != null) {
                ((TurnComponent)newComponent).setRotationAngle(inst.rotationAngle);
            }
        }
        newComponent.updateParameters();
        Vector3d v = new Vector3d(dir);
        if (insertAdjustable) {
            if (insertPosition == PipeControlPoint.PositionType.NEXT) {
                v.scale(newComponent.getControlPoint().getInlineLength());
            } else if (insertPosition == PipeControlPoint.PositionType.SPLIT) {
                v.set(0.0, 0.0, 0.0);
            } else if (insertPosition == PipeControlPoint.PositionType.PREVIOUS) {
                v.scale(-newComponent.getControlPoint().getInlineLength());
            }
        } else {
            v.scale(newComponent.getControlPoint().getInlineLength());
        }
        switch (position) {
            case NEXT: {
                pos.add((Tuple3d)v);
                break;
            }
            case PREVIOUS: {
                pos.sub((Tuple3d)v);
                break;
            }
            case SPLIT: {
                break;
            }
        }
        switch (position) {
            case NEXT: {
                if (toPcp.isDualInline()) {
                    toPcp = toPcp.getDualSub();
                }
                newPcp.insert(toPcp, PipeControlPoint.Direction.NEXT);
                newPcp.setWorldPosition(pos);
                break;
            }
            case PREVIOUS: {
                if (toPcp.isDualSub()) {
                    toPcp = toPcp.parent;
                }
                newPcp.insert(toPcp, PipeControlPoint.Direction.PREVIOUS);
                newPcp.setWorldPosition(pos);
                break;
            }
            case SPLIT: {
                PipingRules.splitVariableLengthComponent(newComponent, (InlineComponent)component, true);
            }
        }
        if (sizeChange) {
            PipeRun other = new PipeRun();
            String n = root.getUniqueName("PipeRun");
            other.setName(n);
            other.setPipeDiameter(inst.diameter);
            other.setTurnRadius(inst.turnRadius);
            root.addChild((INode)other);
            other.addChild(newComponent.getControlPoint().getDualSub());
            newComponent.setAlternativePipeRun(other);
            boolean forward = position != PipeControlPoint.PositionType.PREVIOUS;
            PipelineComponent comp = forward ? newComponent.getNext() : newComponent.getPrevious();
            while (comp != null && comp.getPipeRun() == pipeRun) {
                if (comp.getParent() == pipeRun) {
                    comp.deattach();
                    other.addChild(comp);
                } else {
                    comp.setPipeRun(other);
                }
                comp.updateParameters();
                PipelineComponent pipelineComponent = comp = forward ? comp.getNext() : comp.getPrevious();
            }
            newComponent.updateParameters();
        }
        return newComponent;
    }

    public static boolean connect(PipelineComponent current, PipelineComponent endTo) throws Exception {
        return ComponentUtils.connect(current, endTo, null, null);
    }

    public static boolean connect(PipelineComponent current, PipelineComponent endTo, PipeControlPoint.PositionType endType, Vector3d position) throws Exception {
        boolean reversed;
        PipeControlPoint endCP = endTo.getControlPoint();
        if (current.getNext() == null) {
            reversed = false;
        } else if (current.getPrevious() == null) {
            reversed = true;
        } else {
            return false;
        }
        PipeRun pipeRun = current.getPipeRun();
        P3DRootNode root = (P3DRootNode)current.getRootNode();
        PipeControlPoint currentCP = current.getControlPoint();
        if (endType == null || endType == PipeControlPoint.PositionType.NEXT || endType == PipeControlPoint.PositionType.PREVIOUS) {
            boolean mergeRuns;
            boolean requiresReverse = false;
            if (!reversed && endCP.getPrevious() != null) {
                if (endCP.getNext() != null) {
                    return false;
                }
                requiresReverse = true;
            } else if (reversed && endCP.getNext() != null) {
                if (endCP.getPrevious() != null) {
                    return false;
                }
                requiresReverse = true;
            }
            PipeRun other = endCP.getPipeRun();
            boolean bl = mergeRuns = other == null ? true : pipeRun.canMerge(other);
            if (requiresReverse) {
                PipingRules.reverse(other);
            }
            if (mergeRuns) {
                if (other != null && pipeRun != other) {
                    pipeRun.merge(other);
                } else if (other == null) {
                    if (!(endTo instanceof Nozzle)) {
                        pipeRun.addChild(endTo);
                    } else {
                        endTo.setPipeRun(pipeRun);
                    }
                }
                if (!reversed) {
                    currentCP.setNext(endCP);
                    endCP.setPrevious(currentCP);
                } else {
                    currentCP.setPrevious(endCP);
                    endCP.setNext(currentCP);
                }
            } else {
                InlineComponent reducer = ComponentUtils.createReducer(root);
                PipeControlPoint pcp = reducer.getControlPoint();
                Vector3d endPos = endCP.getWorldPosition();
                Vector3d currentPos = currentCP.getWorldPosition();
                Vector3d v = new Vector3d(endPos);
                v.sub((Tuple3d)currentPos);
                v.scale(0.5);
                v.add((Tuple3d)currentPos);
                PipingRules.addSizeChange(reversed, pipeRun, other, reducer, currentCP, endCP);
                pcp.setWorldPosition(v);
                reducer.updateParameters();
            }
            PipingRules.positionUpdate(endCP);
            return true;
        }
        if (endType == PipeControlPoint.PositionType.SPLIT) {
            InlineComponent branchSplit = ComponentUtils.createBranchSplit((InlineComponent)endTo, position);
            if (branchSplit == null) {
                return false;
            }
            PipeControlPoint branchSplitCP = branchSplit.getControlPoint();
            PipeControlPoint pcp = new PipeControlPoint(branchSplit, pipeRun);
            branchSplitCP.children.add(pcp);
            pcp.parent = branchSplitCP;
            pcp.setWorldOrientation(branchSplitCP.getWorldOrientation());
            pcp.setWorldPosition(branchSplitCP.getWorldPosition());
            if (!reversed) {
                pcp.setPrevious(currentCP);
                currentCP.setNext(pcp);
            } else {
                pcp.setNext(currentCP);
                currentCP.setPrevious(pcp);
            }
            PipingRules.positionUpdate(endCP);
            return true;
        }
        return false;
    }

    public static InlineComponent createBranchSplit(InlineComponent component, Vector3d pos) throws Exception {
        Vector3d v;
        if (!component.isVariableLength()) {
            return null;
        }
        PipeRun pipeRun = component.getPipeRun();
        Vector3d sStart = new Vector3d();
        Vector3d sEnd = new Vector3d();
        component.getControlPoint().getInlineControlPointEnds((Tuple3d)sStart, (Tuple3d)sEnd);
        if (MathTools.distance((Tuple3d)sStart, (Tuple3d)sEnd) < pipeRun.getPipeDiameter() * 0.5) {
            return null;
        }
        Vector3d p = MathTools.closestPointOnEdge((Vector3d)new Vector3d(pos), (Vector3d)sStart, (Vector3d)sEnd);
        if (p == sStart) {
            v = new Vector3d(sEnd);
            v.sub((Tuple3d)sStart);
            v.normalize();
            v.scale(component.getPipeRun().getPipeDiameter() * 0.5);
            p.add((Tuple3d)v);
        } else if (p == sEnd) {
            v = new Vector3d(sStart);
            v.sub((Tuple3d)sEnd);
            v.normalize();
            v.scale(component.getPipeRun().getPipeDiameter() * 0.5);
            p.add((Tuple3d)v);
        }
        P3DRootNode root = (P3DRootNode)component.getRootNode();
        InlineComponent branchSplit = ComponentUtils.createBranchSplit(root);
        String branchName = component.getPipeRun().getUniqueName("Branch");
        branchSplit.setName(branchName);
        component.getPipeRun().addChild(branchSplit);
        PipeControlPoint branchSplitCP = branchSplit.getControlPoint();
        branchSplitCP.setWorldPosition(p);
        PipingRules.splitVariableLengthComponent(branchSplit, component, false);
        return branchSplit;
    }

    public static class InsertInstruction {
        public String typeUri;
        public PipeControlPoint.PositionType position = PipeControlPoint.PositionType.NEXT;
        public PipeControlPoint.PositionType insertPosition = PipeControlPoint.PositionType.NEXT;
        public Double diameter;
        public Double turnRadius;
        public Double length;
        public Double angle;
        public Double rotationAngle;

        public String getTypeUri() {
            return this.typeUri;
        }

        public void setTypeUri(String typeUri) {
            this.typeUri = typeUri;
        }

        public PipeControlPoint.PositionType getPosition() {
            return this.position;
        }

        public void setPosition(PipeControlPoint.PositionType position) {
            this.position = position;
        }

        public PipeControlPoint.PositionType getInsertPosition() {
            return this.insertPosition;
        }

        public void setInsertPosition(PipeControlPoint.PositionType insertPosition) {
            this.insertPosition = insertPosition;
        }

        public Double getDiameter() {
            return this.diameter;
        }

        public void setDiameter(Double diameter) {
            this.diameter = diameter;
        }

        public Double getTurnRadius() {
            return this.turnRadius;
        }

        public void setTurnRadius(Double turnRadius) {
            this.turnRadius = turnRadius;
        }

        public Double getLength() {
            return this.length;
        }

        public void setLength(Double length) {
            this.length = length;
        }

        public Double getAngle() {
            return this.angle;
        }

        public void setAngle(Double angle) {
            this.angle = angle;
        }

        public Double getRotationAngle() {
            return this.rotationAngle;
        }

        public void setRotationAngle(Double rotationAngle) {
            this.rotationAngle = rotationAngle;
        }
    }
}

