/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scl;

import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.scl.ScriptNodeMap;
import org.simantics.objmap.graph.IMapping;
import org.simantics.plant3d.scenegraph.IP3DNode;
import org.simantics.plant3d.scenegraph.IP3DVisualNode;
import org.simantics.plant3d.scenegraph.P3DParentNode;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.ParameterizedNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import org.simantics.plant3d.scenegraph.controlpoint.PipingRules;

public class P3DScriptNodeMap
extends ScriptNodeMap<Resource, INode> {
    private static final boolean DEBUG = false;

    public P3DScriptNodeMap(Session session, IMapping mapping, P3DRootNode rootNode) {
        super(session, mapping, (ParentNode)rootNode);
        rootNode.setMapping((IMapping<Resource, INode>)mapping);
    }

    protected void updateActor(INode n, Set<String> ids) {
        if (!(n instanceof IP3DVisualNode)) {
            if (n instanceof PipeControlPoint) {
                if ((n = ((PipeControlPoint)n).getPipelineComponent()) == null) {
                    return;
                }
            } else {
                return;
            }
        }
        IP3DVisualNode node = (IP3DVisualNode)n;
        if (ids.contains("http://www.simantics.org/Plant3D-0.1/hasGeometry")) {
            this.updateTransform(node);
        }
        if (n instanceof ParameterizedNode) {
            ParameterizedNode geom = (ParameterizedNode)n;
            for (String id : geom.getParameterMap().keySet()) {
                if (!ids.contains(id)) continue;
                this.updateTransform(node);
                break;
            }
        } else if (n instanceof PipeRun) {
            PipeRun run = (PipeRun)n;
            HashSet<String> ids2 = new HashSet<String>();
            ids2.add("http://www.simantics.org/Plant3D-0.1/hasGeometry");
            for (PipeControlPoint pcp : run.getControlPoints()) {
                this.updateActor((INode)pcp, ids2);
            }
        }
        if (ids.contains("http://www.simantics.org/G3D-0.1/hasPosition") || ids.contains("http://www.simantics.org/G3D-0.1/hasOrientation") || ids.contains("http://www.simantics.org/G3D-0.1/hasWorldPosition") || ids.contains("http://www.simantics.org/G3D-0.1/hasWorldOrientation")) {
            this.updateTransform(node);
        }
    }

    private void updateTransform(IP3DNode node) {
        if (node instanceof ParentNode) {
            ParentNode p = (ParentNode)node;
            for (IP3DNode n : p.getNodes()) {
                this.updateTransform(n);
            }
        }
    }

    protected void removeActor(INode n) {
        if (!(n instanceof IP3DVisualNode)) {
            return;
        }
        IP3DVisualNode node = (IP3DVisualNode)n;
        if (node instanceof P3DParentNode) {
            for (IP3DNode n2 : ((P3DParentNode)node).getNodes()) {
                if (!(n2 instanceof IP3DVisualNode)) continue;
                this.removeActor((INode)((IP3DVisualNode)n2));
            }
        }
    }

    protected void addActor(INode n) {
        if (!(n instanceof IP3DVisualNode)) {
            return;
        }
        IP3DVisualNode node = (IP3DVisualNode)n;
        if (node instanceof P3DParentNode) {
            for (IP3DNode n2 : ((P3DParentNode)node).getNodes()) {
                if (!(n2 instanceof IP3DVisualNode)) continue;
                this.addActor((INode)((IP3DVisualNode)n2));
            }
        }
        this.updateTransform(node);
    }

    protected void update(ReadGraph graph) throws DatabaseException {
        this.validate();
        super.update(graph);
        this.validate();
    }

    public void commit(String commitMessage) {
        this.validate();
        super.commit(commitMessage);
    }

    protected void doCommit() throws DatabaseException {
        this.validate();
        super.doCommit();
    }

    private void validate() {
        for (INode node : this.rootNode.getNodes()) {
            if (!(node instanceof PipeRun)) continue;
            PipingRules.validate((PipeRun)node);
        }
    }

    public void update() throws DatabaseException {
        try {
            boolean b = true;
            while (b) {
                this.updateCycle();
                b = PipingRules.update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.update();
    }
}

