/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph.controlpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.plant3d.scenegraph.InlineComponent;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.TurnComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import org.simantics.plant3d.utils.ComponentUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ErrorLogger;

public class PipingRules {
    private static final boolean DEBUG = false;
    private static final boolean DUMMY = false;
    private static double MIN_TURN_ANGLE = 0.001;
    private static double ALLOWED_OFFSET = 0.001;
    private static double MIN_INLINE_LENGTH = 5.0E-4;
    private static final int REMOVE_NONE = 0;
    private static final int REMOVE_START = 1;
    private static final int REMOVE_END = 2;
    private static final int REMOVE_BOTH = 3;
    private static boolean enabled = true;
    private static boolean updating = false;
    private static boolean allowInsertRemove = true;
    private static boolean triedIR = false;
    private static List<PipeControlPoint> requestUpdates = new ArrayList<PipeControlPoint>();
    private static List<PipeControlPoint> currentUpdates = new ArrayList<PipeControlPoint>();
    private static Object updateMutex = new Object();
    private static Object ruleMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestUpdate(PipeControlPoint pcp) {
        if (!enabled) {
            return;
        }
        Object object = updateMutex;
        synchronized (object) {
            if (!requestUpdates.contains(pcp)) {
                requestUpdates.add(pcp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean update() throws Exception {
        if (!enabled) {
            return false;
        }
        if (requestUpdates.size() == 0) {
            return false;
        }
        ArrayList<PipeControlPoint> temp = new ArrayList<PipeControlPoint>(requestUpdates.size());
        Object object = updateMutex;
        synchronized (object) {
            temp.addAll(requestUpdates);
            requestUpdates.clear();
        }
        object = ruleMutex;
        synchronized (object) {
            currentUpdates.clear();
            currentUpdates.addAll(temp);
            for (PipeControlPoint pcp : currentUpdates) {
                PipingRules._positionUpdate(pcp, true);
            }
            currentUpdates.clear();
        }
        object = updateMutex;
        synchronized (object) {
            requestUpdates.removeAll(temp);
        }
        return true;
    }

    public static boolean positionUpdate(PipeControlPoint pcp) throws Exception {
        return PipingRules.positionUpdate(pcp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean positionUpdate(PipeControlPoint pcp, boolean allowIR) throws Exception {
        Object object = ruleMutex;
        synchronized (object) {
            currentUpdates.add(pcp);
            boolean b = PipingRules._positionUpdate(pcp, allowIR);
            currentUpdates.clear();
            return b;
        }
    }

    private static boolean _positionUpdate(PipeControlPoint pcp, boolean allowIR) throws Exception {
        if (updating || !enabled) {
            return true;
        }
        if (pcp.getPipeRun() == null) {
            return false;
        }
        try {
            updating = true;
            allowInsertRemove = allowIR;
            triedIR = false;
            PipingRules.validate(pcp.getPipeRun());
            if (pcp.getParentPoint() != null) {
                pcp = pcp.getParentPoint();
            }
            if (pcp.asPathLegEnd()) {
                PipingRules.updatePathLegEndControlPoint(pcp);
            } else {
                PipingRules.updateInlineControlPoint(pcp);
            }
            PipingRules.validate(pcp.getPipeRun());
            if (!allowInsertRemove) {
                boolean bl = !triedIR;
                return bl;
            }
            return true;
        }
        finally {
            updating = false;
        }
    }

    public static void setEnabled(boolean enabled) {
        PipingRules.enabled = enabled;
        if (!enabled) {
            currentUpdates.clear();
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private static void updatePathLegEndControlPoint(PipeControlPoint pcp) throws Exception {
        if (pcp.getNext() != null) {
            PipingRules.updatePathLegNext(pcp, pcp, PathLegUpdateType.NEXT_S);
        }
        if (pcp.getPrevious() != null) {
            PipingRules.updatePathLegPrev(pcp, pcp, PathLegUpdateType.PREV_S);
        }
    }

    private static void updateInlineControlPoint(PipeControlPoint pcp) throws Exception {
        PipeControlPoint start = pcp.findPreviousEnd();
        PipingRules.updatePathLegNext(start, pcp, PathLegUpdateType.NONE);
    }

    private static PipeControlPoint insertElbow(PipeControlPoint pcp1, PipeControlPoint pcp2, Vector3d pos) throws Exception {
        if (pcp1.getNext() != pcp2 || pcp2.getPrevious() != pcp1) {
            PipeControlPoint t;
            if (pcp1.getNext() == pcp2 && pcp1.isDualInline() && pcp2.getPrevious() == pcp1.getDualSub()) {
                pcp1 = pcp1.getDualSub();
            } else if (pcp1.getPrevious() == pcp2 && pcp2.getNext() == pcp1) {
                t = pcp1;
                pcp1 = pcp2;
                pcp2 = t;
            } else if (pcp2.isDualInline() && pcp1.getPrevious() == pcp2.getDualSub() && pcp2.getNext() == pcp1) {
                t = pcp1;
                pcp1 = pcp2.getDualSub();
                pcp2 = t;
            } else {
                throw new RuntimeException();
            }
        }
        TurnComponent elbow = ComponentUtils.createTurn((P3DRootNode)pcp1.getRootNode());
        PipeControlPoint pcp = elbow.getControlPoint();
        if (pcp1.isDualInline()) {
            pcp1 = pcp1.getDualSub();
        }
        String name = pcp1.getPipeRun().getUniqueName("Elbow");
        elbow.setName(name);
        pcp1.getPipeRun().addChild(elbow);
        pcp.insert(pcp1, pcp2);
        pcp.setWorldPosition(pos);
        PipingRules.validate(pcp.getPipeRun());
        return pcp;
    }

    private static PipeControlPoint insertStraight(PipeControlPoint pcp1, PipeControlPoint pcp2, Vector3d pos, double length) throws Exception {
        if (pcp1.getNext() != pcp2 || pcp2.getPrevious() != pcp1) {
            PipeControlPoint t;
            if (pcp1.getNext() == pcp2 && pcp1.isDualInline() && pcp2.getPrevious() == pcp1.getDualSub()) {
                pcp1 = pcp1.getDualSub();
            } else if (pcp1.getPrevious() == pcp2 && pcp2.getNext() == pcp1) {
                t = pcp1;
                pcp1 = pcp2;
                pcp2 = t;
            } else if (pcp2.isDualInline() && pcp1.getPrevious() == pcp2.getDualSub() && pcp2.getNext() == pcp1) {
                t = pcp1;
                pcp1 = pcp2.getDualSub();
                pcp2 = t;
            } else {
                throw new RuntimeException();
            }
        }
        InlineComponent component = ComponentUtils.createStraight((P3DRootNode)pcp1.getRootNode());
        PipeControlPoint scp = component.getControlPoint();
        if (pcp1.isDualInline()) {
            pcp1 = pcp1.getDualSub();
        }
        String name = pcp1.getPipeRun().getUniqueName("Pipe");
        component.setName(name);
        pcp1.getPipeRun().addChild(component);
        scp.insert(pcp1, pcp2);
        scp.setWorldPosition(pos);
        scp.setLength(length);
        PipingRules.validate(scp.getPipeRun());
        return scp;
    }

    private static PipeControlPoint insertStraight(PipeControlPoint pcp, PipeControlPoint.Direction direction, Vector3d pos, double length) throws Exception {
        InlineComponent component = ComponentUtils.createStraight((P3DRootNode)pcp.getRootNode());
        PipeControlPoint scp = component.getControlPoint();
        if (pcp.isDualInline() && direction == PipeControlPoint.Direction.NEXT) {
            pcp = pcp.getDualSub();
        }
        String name = pcp.getPipeRun().getUniqueName("Pipe");
        component.setName(name);
        pcp.getPipeRun().addChild(component);
        scp.insert(pcp, direction);
        scp.setWorldPosition(pos);
        scp.setLength(length);
        PipingRules.validate(scp.getPipeRun());
        return scp;
    }

    private static void updatePathLegNext(PipeControlPoint start, PipeControlPoint updated, PathLegUpdateType lengthChange) throws Exception {
        UpdateStruct2 us = PipingRules.createUS(start, PipeControlPoint.Direction.NEXT, 0, new ArrayList<ExpandIterInfo>(), updated);
        if (us == null) {
            System.out.println("Null update struct " + start);
            return;
        }
        PipingRules.updatePathLeg(us, lengthChange);
    }

    private static void updatePathLegPrev(PipeControlPoint start, PipeControlPoint updated, PathLegUpdateType lengthChange) throws Exception {
        UpdateStruct2 us = PipingRules.createUS(start, PipeControlPoint.Direction.PREVIOUS, 0, new ArrayList<ExpandIterInfo>(), updated);
        if (us == null) {
            System.out.println("Null update struct " + start);
            return;
        }
        PipingRules.updatePathLeg(us, lengthChange);
    }

    public static boolean calculateDirectedOffset(Vector3d startPoint, Vector3d endPoint, PipeControlPoint start, ArrayList<PipeControlPoint> list, PipeControlPoint end, Vector3d dir, Vector3d offset) {
        return PipingRules.calculateOffset(startPoint, endPoint, start, list, end, dir, offset, true);
    }

    public static boolean calculateOffset(Vector3d startPoint, Vector3d endPoint, PipeControlPoint start, ArrayList<PipeControlPoint> list, PipeControlPoint end, Vector3d dir, Vector3d offset) {
        return PipingRules.calculateOffset(startPoint, endPoint, start, list, end, dir, offset, false);
    }

    private static boolean calculateOffset(Vector3d startPoint, Vector3d endPoint, PipeControlPoint start, ArrayList<PipeControlPoint> list, PipeControlPoint end, Vector3d dir, Vector3d offset, boolean directed) {
        List<PipeControlPoint> offsets = PipingRules.getOffsetPoints(start, list);
        if (offsets.size() == 0) {
            PipingRules.setZeroOffset(startPoint, endPoint, dir, offset);
            return false;
        }
        Vector3d sp = new Vector3d(startPoint);
        Point3d ep = new Point3d((Tuple3d)endPoint);
        dir.set((Tuple3d)ep);
        dir.sub((Tuple3d)sp);
        double l = dir.lengthSquared();
        if (l > MathTools.NEAR_ZERO) {
            dir.scale(1.0 / Math.sqrt(l));
        }
        int iter = 100;
        while (iter >= 0) {
            --iter;
            offset.set(0.0, 0.0, 0.0);
            for (PipeControlPoint icp : offsets) {
                Vector3d v = icp.getSizeChangeOffsetVector(dir);
                offset.add((Tuple3d)v);
            }
            if (directed) break;
            Point3d nep = new Point3d((Tuple3d)endPoint);
            nep.sub((Tuple3d)offset);
            if (nep.distance(ep) < 1.0E-10) break;
            ep = nep;
            dir.set((Tuple3d)ep);
            dir.sub((Tuple3d)sp);
            l = dir.lengthSquared();
            if (!(l > MathTools.NEAR_ZERO)) continue;
            dir.scale(1.0 / Math.sqrt(l));
        }
        return true;
    }

    public static void setZeroOffset(Vector3d startPoint, Vector3d endPoint, Vector3d dir, Vector3d offset) {
        dir.set((Tuple3d)endPoint);
        dir.sub((Tuple3d)startPoint);
        double l = dir.lengthSquared();
        if (l > MathTools.NEAR_ZERO) {
            dir.scale(1.0 / Math.sqrt(l));
        }
        offset.set(0.0, 0.0, 0.0);
    }

    public static List<PipeControlPoint> getOffsetPoints(PipeControlPoint start, ArrayList<PipeControlPoint> list) {
        ArrayList<PipeControlPoint> offsets = new ArrayList<PipeControlPoint>(list.size());
        if (start.isOffset()) {
            offsets.add(start);
        }
        for (PipeControlPoint icp : list) {
            if (icp.isOffset()) {
                offsets.add(icp);
                continue;
            }
            if (!icp.isDualSub()) continue;
            ErrorLogger.defaultLogError((String)("Updating pipe run, found offset controlpoint " + icp), (Throwable)new Exception("ASSERT!"));
        }
        return offsets;
    }

    private static UpdateStruct2 createUS(PipeControlPoint start, PipeControlPoint.Direction direction, int iter, ArrayList<ExpandIterInfo> toRemove, PipeControlPoint updated) {
        ArrayList<PipeControlPoint> list = new ArrayList<PipeControlPoint>();
        PipeControlPoint end = null;
        if (direction == PipeControlPoint.Direction.NEXT) {
            end = start.findNextEnd(list);
        } else {
            ArrayList<PipeControlPoint> prevList = new ArrayList<PipeControlPoint>();
            PipeControlPoint tend = start.findPreviousEnd(prevList);
            for (PipeControlPoint icp : prevList) {
                if (icp.isDualSub()) {
                    list.add(0, icp.getParentPoint());
                    continue;
                }
                list.add(0, icp);
            }
            end = start;
            start = tend;
        }
        if (start == end) {
            return null;
        }
        boolean hasOffsets = false;
        Vector3d offset = new Vector3d();
        Vector3d startPoint = start.getWorldPosition();
        Vector3d endPoint = end.getWorldPosition();
        Vector3d dir = new Vector3d();
        hasOffsets = PipingRules.calculateOffset(startPoint, endPoint, start, list, end, dir, offset);
        return new UpdateStruct2(start, startPoint, list, end, endPoint, dir, offset, hasOffsets, iter, direction == PipeControlPoint.Direction.PREVIOUS, toRemove, updated);
    }

    private static boolean asDirected(PipeControlPoint pcp, PipeControlPoint.Direction direction) {
        if (pcp.isDirected()) {
            return true;
        }
        if (pcp.asFixedAngle()) {
            if (!pcp._getReversed()) {
                return direction == PipeControlPoint.Direction.NEXT;
            }
            return direction == PipeControlPoint.Direction.PREVIOUS;
        }
        return false;
    }

    private static Vector3d direction(PipeControlPoint pcp, PipeControlPoint.Direction direction) {
        return pcp.getDirection(direction);
    }

    private static void updatePathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange) throws Exception {
        boolean rs = true;
        boolean re = true;
        if (lengthChange == PathLegUpdateType.NONE) {
            rs = false;
            re = false;
        }
        PipingRules.updatePathLeg(u, lengthChange, rs, re);
    }

    private static void updatePathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange, boolean rs, boolean re) throws Exception {
        int directed = 0;
        if (PipingRules.asDirected(u.start, PipeControlPoint.Direction.NEXT)) {
            ++directed;
        }
        if (PipingRules.asDirected(u.end, PipeControlPoint.Direction.PREVIOUS)) {
            ++directed;
        }
        if (rs) {
            PipingRules.setErrorForce(u.start, null);
        }
        if (re) {
            PipingRules.setErrorForce(u.end, null);
        }
        for (PipeControlPoint pcp : u.list) {
            PipingRules.setErrorForce(pcp, null);
        }
        switch (directed) {
            case 0: {
                PipingRules.updateFreePathLeg(u, lengthChange);
                break;
            }
            case 1: {
                PipingRules.updateDirectedPathLeg(u, lengthChange);
                break;
            }
            case 2: {
                PipingRules.updateDualDirectedPathLeg(u, lengthChange);
            }
        }
    }

    private static void updateFreePathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange) throws Exception {
        PipingRules.checkExpandPathLeg(u, lengthChange);
        if (u.start.isInline() || u.end.isInline() || u.start.asFixedAngle() || u.end.asFixedAngle()) {
            PipingRules.processPathLeg(u, true, false);
        }
    }

    private static void updateInlineControlPoints(UpdateStruct2 u, boolean checkSizes) throws Exception {
        Vector3d start = new Vector3d(u.startPoint);
        Vector3d end = new Vector3d(u.endPoint);
        if (checkSizes) {
            if (u.start.isTurn()) {
                MathTools.mad((Tuple3d)start, (Tuple3d)u.dir, (double)u.start.getInlineLength());
            }
            if (u.end.isTurn()) {
                MathTools.mad((Tuple3d)end, (Tuple3d)u.dir, (double)(-u.end.getInlineLength()));
            }
        }
        boolean recalcline = false;
        Vector3d sp = new Vector3d(start);
        Vector3d ep = new Vector3d(end);
        ep.sub((Tuple3d)u.offset);
        if (u.start.isOffset()) {
            Vector3d offset = u.start.getSizeChangeOffsetVector(u.dir);
            PipingRules.updateOffsetPoint(u.start, offset);
            sp.add((Tuple3d)offset);
            ep.add((Tuple3d)offset);
        }
        for (PipeControlPoint icp : u.list) {
            PipingRules.updateInlineControlPoint(icp, sp, ep, u.dir);
            if (!icp.isOffset()) continue;
            Vector3d offset = icp.getSizeChangeOffsetVector(u.dir);
            PipingRules.updateOffsetPoint(icp, offset);
            sp.add((Tuple3d)offset);
            ep.add((Tuple3d)offset);
        }
        if (!checkSizes) {
            return;
        }
        ArrayList<PipeControlPoint> pathLegPoints = new ArrayList<PipeControlPoint>();
        ArrayList<Pair<PipeControlPoint, Vector3d>> fixedLengthPoints = new ArrayList<Pair<PipeControlPoint, Vector3d>>();
        pathLegPoints.add(u.start);
        fixedLengthPoints.add(new Pair((Object)u.start, (Object)new Vector3d()));
        Vector3d off = new Vector3d();
        for (PipeControlPoint icp : u.list) {
            pathLegPoints.add(icp);
            PipingRules.updateBranchControlPointBranches(icp);
            if (icp.isOffset()) {
                fixedLengthPoints.add(new Pair((Object)icp, (Object)new Vector3d(off)));
                Vector3d offset = icp.getSizeChangeOffsetVector(u.dir);
                off.add((Tuple3d)offset);
                continue;
            }
            if (icp.isVariableLength()) continue;
            fixedLengthPoints.add(new Pair((Object)icp, (Object)new Vector3d(off)));
        }
        pathLegPoints.add(u.end);
        fixedLengthPoints.add(new Pair((Object)u.end, (Object)new Vector3d(off)));
        sp = new Vector3d(start);
        ep = new Vector3d(end);
        ep.sub((Tuple3d)u.offset);
        PipingRules.updateFixedLengths(fixedLengthPoints, sp, ep, u.dir);
        int i = 0;
        while (i < pathLegPoints.size()) {
            PipeControlPoint next;
            PipeControlPoint icp = (PipeControlPoint)pathLegPoints.get(i);
            PipeControlPoint prev = i > 0 ? (PipeControlPoint)pathLegPoints.get(i - 1) : null;
            PipeControlPoint pipeControlPoint = next = i < pathLegPoints.size() - 1 ? (PipeControlPoint)pathLegPoints.get(i + 1) : null;
            if (prev != null && prev.isDualInline()) {
                prev = prev.getDualSub();
            }
            if (icp.isVariableLength()) {
                if (prev != null && next != null) {
                    recalcline |= PipingRules.updateVariableLength(icp, prev, next);
                } else {
                    PipingRules.updateVariableLengthEnd(icp, prev != null ? prev : next);
                }
            } else if (prev != null && !prev.isVariableLength()) {
                recalcline |= PipingRules.possibleVaribleLengthInsert(icp, prev);
            }
            if (icp.isOffset()) {
                Vector3d offset = icp.getSizeChangeOffsetVector(u.dir);
                sp.add((Tuple3d)offset);
                ep.add((Tuple3d)offset);
            }
            ++i;
        }
        if (recalcline) {
            u.list.clear();
            u.start.findNextEnd(u.list);
        }
        if (checkSizes) {
            double pathLegLength;
            sp = new Vector3d(u.startPoint);
            ep = new Vector3d(u.endPoint);
            ep.sub((Tuple3d)u.offset);
            double availableLength = pathLegLength = MathTools.distance((Tuple3d)sp, (Tuple3d)ep);
            if (u.start.isTurn()) {
                availableLength -= u.start.getInlineLength();
            }
            if (u.end.isTurn()) {
                availableLength -= u.end.getInlineLength();
            }
            for (PipeControlPoint pcp : u.list) {
                if (pcp.isVariableLength()) continue;
                availableLength -= pcp.getLength();
            }
            if (availableLength < 0.0) {
                PipingRules.setError(u.start, "Not enough available space");
                PipingRules.setError(u.end, "Not enough available space");
                for (PipeControlPoint pcp : u.list) {
                    PipingRules.setError(pcp, "Not enough available space");
                }
            }
        }
    }

    private static void updateFixedLengths(List<Pair<PipeControlPoint, Vector3d>> fixedLengthPoints, Vector3d s, Vector3d e, Vector3d dir) {
        double totalLength = MathTools.distance((Tuple3d)s, (Tuple3d)e);
        double reservedLength = 0.0;
        ArrayList<Double> distances = new ArrayList<Double>(fixedLengthPoints.size());
        distances.add(0.0);
        int i = 1;
        while (i < fixedLengthPoints.size() - 1) {
            Pair<PipeControlPoint, Vector3d> pcp = fixedLengthPoints.get(i);
            reservedLength += ((PipeControlPoint)pcp.first).getLength();
            Vector3d p = ((PipeControlPoint)pcp.first).getWorldPosition();
            p.sub((Tuple3d)pcp.second);
            double d = MathTools.distance((Tuple3d)s, (Tuple3d)p);
            distances.add(d);
            ++i;
        }
        distances.add(totalLength);
        if (totalLength >= reservedLength) {
            ArrayList<GapObj> gaps = new ArrayList<GapObj>(fixedLengthPoints.size() - 1);
            int overlaps = 0;
            int i2 = 0;
            while (i2 < fixedLengthPoints.size() - 1) {
                Pair<PipeControlPoint, Vector3d> pcp1 = fixedLengthPoints.get(i2);
                Pair<PipeControlPoint, Vector3d> pcp2 = fixedLengthPoints.get(i2 + 1);
                double d1 = (Double)distances.get(i2);
                double d2 = (Double)distances.get(i2 + 1);
                double ld1 = i2 == 0 ? 0.0 : ((PipeControlPoint)pcp1.first).getInlineLength();
                double ld2 = i2 == fixedLengthPoints.size() - 2 ? 0.0 : ((PipeControlPoint)pcp2.first).getInlineLength();
                double e1 = d1 + ld1;
                double s2 = d2 - ld2;
                double diff = s2 - e1;
                GapObj obj = new GapObj();
                obj.pcp1 = pcp1;
                obj.pcp2 = pcp2;
                obj.d = diff;
                if (diff < -MIN_INLINE_LENGTH) {
                    obj.gap = Gap.OVERLAP;
                    ++overlaps;
                } else {
                    obj.gap = diff > MIN_INLINE_LENGTH ? Gap.SPACE : Gap.ATTACHED;
                }
                gaps.add(obj);
                ++i2;
            }
            if (overlaps == 0) {
                return;
            }
            i2 = 0;
            while (i2 < gaps.size()) {
                GapObj gapObj = (GapObj)gaps.get(i2);
                if (gapObj.gap == Gap.OVERLAP) {
                    double curr = gapObj.d;
                    int d = 1;
                    while (curr < -MIN_INLINE_LENGTH) {
                        Vector3d p;
                        Pair<PipeControlPoint, Vector3d> pcp;
                        int j;
                        Vector3d mv;
                        double move;
                        GapObj prev;
                        GapObj next = i2 + d >= 0 ? (GapObj)gaps.get(i2 + d) : null;
                        GapObj gapObj2 = prev = i2 - d >= 0 ? (GapObj)gaps.get(i2 - d) : null;
                        if (next != null && next.gap == Gap.SPACE) {
                            move = Math.min(-curr, next.d);
                            curr += move;
                            next.d -= move;
                            if (next.d < MIN_INLINE_LENGTH) {
                                next.gap = Gap.ATTACHED;
                            }
                            mv = new Vector3d(dir);
                            mv.normalize();
                            mv.scale(move);
                            j = i2;
                            while (j < i2 + d) {
                                pcp = ((GapObj)gaps.get((int)j)).pcp2;
                                p = new Vector3d(((PipeControlPoint)pcp.first).getWorldPosition());
                                p.add((Tuple3d)mv);
                                ((PipeControlPoint)pcp.first).setWorldPosition(p);
                                ++j;
                            }
                        }
                        if (!(curr < -MIN_INLINE_LENGTH) || prev == null || prev.gap != Gap.SPACE) continue;
                        move = Math.min(-curr, prev.d);
                        curr += move;
                        next.d -= move;
                        if (next.d < MIN_INLINE_LENGTH) {
                            next.gap = Gap.ATTACHED;
                        }
                        mv = new Vector3d(dir);
                        mv.normalize();
                        mv.scale(-move);
                        j = i2;
                        while (j > i2 - d) {
                            pcp = ((GapObj)gaps.get((int)j)).pcp1;
                            p = new Vector3d(((PipeControlPoint)pcp.first).getWorldPosition());
                            p.add((Tuple3d)mv);
                            ((PipeControlPoint)pcp.first).setWorldPosition(p);
                            --j;
                        }
                    }
                }
                ++i2;
            }
        } else {
            i = 1;
            while (i < fixedLengthPoints.size() - 1) {
                Pair<PipeControlPoint, Vector3d> prev = i == 0 ? null : fixedLengthPoints.get(i - 1);
                Pair<PipeControlPoint, Vector3d> curr = fixedLengthPoints.get(i);
                Pair<PipeControlPoint, Vector3d> next = i == fixedLengthPoints.size() - 1 ? null : fixedLengthPoints.get(i + 1);
                PipingRules.updateFixedLength(curr, prev, next, s, e, dir);
                ++i;
            }
        }
    }

    private static void updateFixedLength(Pair<PipeControlPoint, Vector3d> icp, Pair<PipeControlPoint, Vector3d> prev, Pair<PipeControlPoint, Vector3d> next, Vector3d s, Vector3d e, Vector3d dir) {
        if (prev != null) {
            PipingRules.checkOverlap(prev, icp, dir, true);
        }
        if (next != null) {
            PipingRules.checkOverlap(icp, next, dir, true);
        }
    }

    private static boolean checkOverlap(Pair<PipeControlPoint, Vector3d> icp, Pair<PipeControlPoint, Vector3d> icp2, Vector3d dir, boolean se) {
        double r;
        double d;
        Vector3d p1 = ((PipeControlPoint)icp.first).getWorldPosition();
        Vector3d p2 = ((PipeControlPoint)icp2.first).getWorldPosition();
        p1.add((Tuple3d)icp.second);
        p2.add((Tuple3d)icp2.second);
        double[] u = new double[1];
        MathTools.closestPointOnStraight((Tuple3d)p2, (Tuple3d)p1, (Vector3d)dir, (double[])u);
        if (u[0] < 0.0) {
            p2.set((Tuple3d)p1);
            p2.sub((Tuple3d)icp.second);
            p2.add((Tuple3d)icp2.second);
            MathTools.mad((Tuple3d)p2, (Tuple3d)dir, (double)MIN_INLINE_LENGTH);
            ((PipeControlPoint)icp2.first).setWorldPosition(p2);
        }
        if ((d = MathTools.distance((Tuple3d)p1, (Tuple3d)p2)) - (r = ((PipeControlPoint)icp.first).getInlineLength() + ((PipeControlPoint)icp2.first).getInlineLength()) < -MIN_INLINE_LENGTH) {
            if (se) {
                PipingRules.setError((PipeControlPoint)icp.first, "Overlapping");
                PipingRules.setError((PipeControlPoint)icp2.first, "Overlapping");
            }
            return true;
        }
        return false;
    }

    private static void setErrorForce(PipeControlPoint pcp, String error) {
        PipelineComponent comp = pcp.getPipelineComponent();
        if (comp == null) {
            return;
        }
        comp.setError(error);
    }

    private static void setError(PipeControlPoint pcp, String error) {
        PipelineComponent comp = pcp.getPipelineComponent();
        if (comp == null) {
            return;
        }
        if (comp.getError() != null) {
            return;
        }
        comp.setError(error);
    }

    private static boolean updateVariableLength(PipeControlPoint icp, PipeControlPoint prev, PipeControlPoint next) {
        Vector3d prevPos = prev.getWorldPosition();
        Vector3d nextPos = next.getWorldPosition();
        Vector3d dir = new Vector3d(nextPos);
        dir.sub((Tuple3d)prevPos);
        double l = dir.length();
        double l2prev = prev.getInlineLength();
        double l2next = next.getInlineLength();
        double l2 = l2prev + l2next;
        double length = l - l2;
        if (length >= MIN_INLINE_LENGTH) {
            dir.normalize();
            dir.scale(length * 0.5 + l2prev);
            dir.add((Tuple3d)prevPos);
            icp.setWorldPosition(dir);
            icp.setLength(length);
            return false;
        }
        if (icp.isDeletable()) {
            if (!allowInsertRemove) {
                icp.setLength(MIN_INLINE_LENGTH);
                PipingRules.setError(icp, "Not enough available space");
                triedIR = true;
                return false;
            }
            icp._remove();
            return true;
        }
        icp.setLength(MIN_INLINE_LENGTH);
        icp.getPipelineComponent().setError("Not enough available space");
        return false;
    }

    private static boolean possibleVaribleLengthInsert(PipeControlPoint icp, PipeControlPoint prev) throws Exception {
        Vector3d currentPos = icp.getWorldPosition();
        Vector3d prevPos = prev.getWorldPosition();
        Vector3d dir = new Vector3d(currentPos);
        dir.sub((Tuple3d)prevPos);
        double l = dir.lengthSquared();
        double l2prev = prev.getInlineLength();
        double l2next = icp.getInlineLength();
        double l2 = l2prev + l2next;
        double l2s = l2 * l2;
        double diff = l - l2s;
        if (diff >= MIN_INLINE_LENGTH) {
            if (allowInsertRemove) {
                dir.normalize();
                double length = Math.sqrt(l) - l2;
                dir.scale(length * 0.5 + l2prev);
                dir.add((Tuple3d)prevPos);
                PipingRules.insertStraight(prev, icp, dir, length);
                return true;
            }
            triedIR = true;
        }
        return false;
    }

    private static void updateVariableLengthEnd(PipeControlPoint icp, PipeControlPoint prev) {
        Vector3d currentPos = icp.getWorldPosition();
        Vector3d prevPos = prev.getWorldPosition();
        Vector3d dir = new Vector3d();
        dir.sub((Tuple3d)currentPos, (Tuple3d)prevPos);
        boolean simple = currentUpdates.contains(icp);
        if (simple) {
            double currentLength = (dir.length() - prev.getInlineLength()) * 2.0;
            icp.setLength(currentLength);
        } else {
            double currentLength = icp.getLength();
            if (currentLength < MathTools.NEAR_ZERO) {
                currentLength = (dir.length() - prev.getInlineLength()) * 2.0;
            }
            if (dir.lengthSquared() > MathTools.NEAR_ZERO) {
                dir.normalize();
            }
            Point3d endPos = new Point3d((Tuple3d)dir);
            endPos.scale(currentLength * 0.5);
            endPos.add((Tuple3d)currentPos);
            double offset = prev.getInlineLength();
            Point3d beginPos = new Point3d((Tuple3d)dir);
            beginPos.scale(offset);
            beginPos.add((Tuple3d)prevPos);
            double l = beginPos.distance(endPos);
            if (Double.isNaN(l)) {
                System.out.println("Length for " + icp + " is NaN");
            }
            dir.scale(l * 0.5);
            beginPos.add((Tuple3d)dir);
            icp.setLength(l);
            icp.setWorldPosition(new Vector3d((Tuple3d)beginPos));
        }
    }

    private static void ppNoOffset(UpdateStruct2 u, boolean updateEnds) throws Exception {
        Vector3d offset = new Vector3d();
        if (u.hasOffsets) {
            for (PipeControlPoint icp : u.list) {
                if (icp.isOffset()) {
                    offset.add((Tuple3d)icp.getSizeChangeOffsetVector(u.dir));
                    continue;
                }
                if (!icp.isDualSub()) continue;
                ErrorLogger.defaultLogError((String)("Updating pipe run, found offset controlpoint " + icp), (Throwable)new Exception("ASSERT!"));
            }
        }
        u.offset = offset;
        PipingRules.checkExpandPathLeg(u, PathLegUpdateType.NONE, updateEnds);
    }

    private static void ppNoDir(PipeControlPoint start, Vector3d startPoint, ArrayList<PipeControlPoint> list, PipeControlPoint end, Vector3d endPoint, boolean hasOffsets, int iter, boolean reversed, ArrayList<ExpandIterInfo> toRemove, PipeControlPoint updated) throws Exception {
        Vector3d dir = new Vector3d();
        Vector3d offset = new Vector3d();
        hasOffsets = PipingRules.calculateOffset(startPoint, endPoint, start, list, end, dir, offset);
        PipingRules.ppNoOffset(new UpdateStruct2(start, startPoint, list, end, endPoint, dir, null, hasOffsets, iter, reversed, toRemove, updated), true);
    }

    private static void checkExpandPathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange) throws Exception {
        PipingRules.checkExpandPathLeg(u, lengthChange, u.updated.isInline() && u.updated.isOffset());
    }

    private static void checkExpandPathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange, boolean updateEnds) throws Exception {
        if (lengthChange != PathLegUpdateType.NONE) {
            PipingRules.processPathLeg(u, updateEnds, false);
            int type = PipingRules.checkTurns(u, lengthChange);
            if (type == 0) {
                PipingRules.processPathLeg(u, updateEnds, true);
            } else {
                PipingRules.expandPathLeg(u, type);
            }
        } else {
            PipingRules.processPathLeg(u, updateEnds, true);
        }
    }

    private static void updateDirectedPathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange) throws Exception {
        Vector3d closest;
        Vector3d position;
        PipeControlPoint other;
        PipeControlPoint dcp;
        boolean canMoveOther = false;
        boolean dcpStart = false;
        boolean inlineEnd = false;
        if (PipingRules.asDirected(u.start, PipeControlPoint.Direction.NEXT)) {
            dcp = u.start;
            other = u.end;
            position = u.startPoint;
            dcpStart = true;
            if (!u.reversed) {
                canMoveOther = true;
            }
            inlineEnd = u.end.isInline();
        } else {
            dcp = u.end;
            other = u.start;
            position = u.endPoint;
            if (u.reversed) {
                canMoveOther = true;
            }
            inlineEnd = u.start.isInline();
        }
        Vector3d directedDirection = PipingRules.direction(dcp, dcpStart ? PipeControlPoint.Direction.NEXT : PipeControlPoint.Direction.PREVIOUS);
        if (directedDirection == null) {
            PipingRules.updateTurnControlPointTurn(dcp, null, null);
            directedDirection = PipingRules.direction(dcp, dcpStart ? PipeControlPoint.Direction.NEXT : PipeControlPoint.Direction.PREVIOUS);
            if (directedDirection == null) {
                return;
            }
        }
        Point3d directedEndPoint = new Point3d((Tuple3d)u.endPoint);
        if (u.hasOffsets) {
            directedEndPoint.sub((Tuple3d)u.offset);
        }
        double[] mu = new double[2];
        Vector3d t = new Vector3d();
        if (dcpStart) {
            closest = MathTools.closestPointOnStraight((Tuple3d)directedEndPoint, (Tuple3d)u.startPoint, (Vector3d)directedDirection, (double[])mu);
            t.sub((Tuple3d)closest, (Tuple3d)directedEndPoint);
        } else {
            closest = MathTools.closestPointOnStraight((Tuple3d)u.startPoint, (Tuple3d)directedEndPoint, (Vector3d)directedDirection, (double[])mu);
            t.sub((Tuple3d)closest, (Tuple3d)u.startPoint);
        }
        double distance = t.length();
        boolean aligned = distance < ALLOWED_OFFSET;
        double requiredSpace = 0.0;
        if (other.isVariableAngle()) {
            requiredSpace = PipingRules.spaceForTurn(other, dcp);
        }
        if (mu[0] < requiredSpace) {
            aligned = false;
            canMoveOther = true;
        }
        if (aligned) {
            PipingRules.checkExpandPathLeg(u, lengthChange, inlineEnd || u.start.isInline() || u.end.isInline() || u.start.asFixedAngle() || u.end.asFixedAngle());
        } else if (u.iter > 0) {
            PipingRules.backIter(u);
        } else {
            PipeControlPoint nextToMoved = u.list.size() > 0 ? (dcpStart ? u.list.get(0) : u.list.get(u.list.size() - 1)) : (dcpStart ? u.end : u.start);
            if (other.isVariableAngle()) {
                if (mu[0] < requiredSpace) {
                    if (dcpStart) {
                        closest.set((Tuple3d)u.startPoint);
                    } else {
                        closest.set((Tuple3d)u.endPoint);
                    }
                    Vector3d v = new Vector3d(directedDirection);
                    v.scale(requiredSpace);
                    closest.add((Tuple3d)v);
                }
                if (canMoveOther) {
                    Vector3d offset;
                    if (u.hasOffsets) {
                        offset = new Vector3d();
                        Vector3d newDir = new Vector3d();
                        PipingRules.calculateDirectedOffset(position, closest, u.start, u.list, u.end, newDir, offset);
                        closest.add((Tuple3d)offset);
                    } else {
                        offset = new Vector3d();
                    }
                    other.setWorldPosition(closest);
                    if (dcpStart) {
                        PipingRules.checkExpandPathLeg(new UpdateStruct2(u.start, u.startPoint, u.list, u.end, new Vector3d(closest), directedDirection, offset, u.hasOffsets, u.iter, u.reversed, u.toRemove, u.updated), PathLegUpdateType.NONE, true);
                        if (u.end.getNext() != null) {
                            PipingRules.updatePathLegNext(u.end, u.updated, PathLegUpdateType.NEXT);
                        }
                    } else {
                        PipingRules.checkExpandPathLeg(new UpdateStruct2(u.start, new Vector3d(closest), u.list, u.end, u.endPoint, directedDirection, offset, u.hasOffsets, u.iter, u.reversed, u.toRemove, u.updated), PathLegUpdateType.NONE, true);
                        if (u.start.getPrevious() != null) {
                            PipingRules.updatePathLegPrev(u.start, u.updated, PathLegUpdateType.PREV);
                        }
                    }
                } else if (allowInsertRemove) {
                    PipingRules.insertElbowUpdate(u, dcp, nextToMoved, dcpStart, position, directedDirection);
                } else {
                    triedIR = true;
                }
            } else if (other.isNonDirected() && other.getParentPoint() != null) {
                Vector3d bintersect = new Vector3d();
                PipeControlPoint bcp = other.getParentPoint();
                if (bcp == null || !canMoveOther) {
                    throw new UnsupportedOperationException("not implemented");
                }
                Point3d bstart = new Point3d();
                Point3d bend = new Point3d();
                Vector3d bdir = new Vector3d();
                bcp.getInlineControlPointEnds((Tuple3d)bstart, (Tuple3d)bend, bdir);
                Vector3d nintersect = new Vector3d();
                MathTools.intersectStraightStraight((Tuple3d)position, (Vector3d)directedDirection, (Tuple3d)bend, (Vector3d)bdir, (Tuple3d)nintersect, (Tuple3d)bintersect, (double[])mu);
                Vector3d dist = new Vector3d(nintersect);
                dist.sub((Tuple3d)bintersect);
                canMoveOther = mu[1] > 0.0 && mu[1] < 1.0 && dist.lengthSquared() < 0.01;
                if (canMoveOther) {
                    bcp.setWorldPosition(bintersect);
                    if (dcpStart) {
                        PipingRules.checkExpandPathLeg(new UpdateStruct2(u.start, u.startPoint, u.list, u.end, new Vector3d(bintersect), directedDirection, u.offset, u.hasOffsets, u.iter, u.reversed, u.toRemove, u.updated), lengthChange);
                    } else {
                        PipingRules.checkExpandPathLeg(new UpdateStruct2(u.start, new Vector3d(bintersect), u.list, u.end, u.endPoint, directedDirection, u.offset, u.hasOffsets, u.iter, u.reversed, u.toRemove, u.updated), lengthChange);
                    }
                } else if (allowInsertRemove) {
                    PipingRules.insertElbowUpdate(u, dcp, nextToMoved, dcpStart, position, directedDirection);
                } else {
                    triedIR = true;
                }
            } else if (allowInsertRemove) {
                PipingRules.insertElbowUpdate(u, dcp, nextToMoved, dcpStart, position, directedDirection);
            } else {
                triedIR = true;
            }
        }
    }

    private static void updateDualDirectedPathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange) throws Exception {
        boolean aligned;
        PipeControlPoint dcp1 = u.start;
        PipeControlPoint dcp2 = u.end;
        Point3d position1 = new Point3d((Tuple3d)u.startPoint);
        Point3d position2 = new Point3d((Tuple3d)u.endPoint);
        Point3d position1offset = new Point3d(position1);
        position1offset.sub((Tuple3d)u.offset);
        Point3d position2offset = new Point3d(position2);
        position2offset.add((Tuple3d)u.offset);
        Vector3d dir1 = PipingRules.direction(dcp1, PipeControlPoint.Direction.NEXT);
        Vector3d dir2 = PipingRules.direction(dcp2, PipeControlPoint.Direction.PREVIOUS);
        Vector3d p1 = MathTools.closestPointOnStraight((Tuple3d)position1offset, (Tuple3d)position2, (Vector3d)dir2);
        Vector3d p2 = MathTools.closestPointOnStraight((Tuple3d)position2offset, (Tuple3d)position1, (Vector3d)dir1);
        double d1 = position1.distance(new Point3d((Tuple3d)p1));
        double d2 = position2.distance(new Point3d((Tuple3d)p2));
        boolean bl = aligned = d1 < ALLOWED_OFFSET && d2 < ALLOWED_OFFSET;
        if (aligned) {
            PipingRules.processPathLeg(u);
        } else if (u.iter > 0) {
            PipingRules.backIter(u);
        } else if (allowInsertRemove) {
            PipeControlPoint next;
            PipeControlPoint dcp;
            if (!u.reversed) {
                dcp = dcp1;
                next = u.list.size() > 0 ? u.list.get(0) : dcp2;
            } else {
                dcp = dcp2;
                next = u.list.size() > 0 ? u.list.get(u.list.size() - 1) : dcp1;
            }
            p1 = dcp.getWorldPosition();
            Vector3d v = new Vector3d();
            if (!u.reversed) {
                v.set((Tuple3d)dir1);
            } else {
                v.set((Tuple3d)dir2);
            }
            double off = dcp1.getPipeRun().getTurnRadius();
            v.scale(off);
            p1.add((Tuple3d)v);
            p2 = !u.reversed ? MathTools.closestPointOnStraight((Tuple3d)new Point3d((Tuple3d)p1), (Tuple3d)position2, (Vector3d)dir2) : MathTools.closestPointOnStraight((Tuple3d)new Point3d((Tuple3d)p1), (Tuple3d)position1, (Vector3d)dir1);
            if (MathTools.distance((Tuple3d)p1, (Tuple3d)p2) < off * 2.05) {
                p2.add((Tuple3d)v);
            }
            PipeControlPoint tcp1 = PipingRules.insertElbow(dcp, next, p1);
            PipeControlPoint tcp2 = PipingRules.insertElbow(tcp1, next, p2);
            if (!u.reversed) {
                Vector3d dd = new Vector3d(p2);
                dd.sub((Tuple3d)p1);
                dir2.negate();
                PipingRules.updatePathLegNext(u.start, u.updated, PathLegUpdateType.NONE);
                PipingRules.updatePathLegNext(tcp1, u.updated, PathLegUpdateType.NONE);
                if (!u.reversed) {
                    PipingRules.updatePathLegNext(tcp2, u.updated, PathLegUpdateType.NONE);
                } else {
                    PipingRules.updatePathLegPrev(tcp2, u.updated, PathLegUpdateType.NONE);
                }
            } else {
                Vector3d dd = new Vector3d(p1);
                dd.sub((Tuple3d)p2);
                dir2.negate();
                PipingRules.updatePathLegNext(tcp1, u.updated, PathLegUpdateType.NONE);
                PipingRules.updatePathLegNext(tcp2, u.updated, PathLegUpdateType.NONE);
                if (!u.reversed) {
                    PipingRules.updatePathLegNext(u.start, u.updated, PathLegUpdateType.NONE);
                } else {
                    PipingRules.updatePathLegPrev(u.start, u.updated, PathLegUpdateType.NONE);
                }
            }
        } else {
            triedIR = true;
        }
    }

    private static double spaceForTurn(PipeControlPoint tcp, PipeControlPoint dcp) {
        double[] u;
        double tr = ((TurnComponent)tcp.getPipelineComponent()).getTurnRadius();
        if (dcp == null) {
            return tr;
        }
        PipeControlPoint ne = tcp.findNextEnd();
        PipeControlPoint pe = tcp.findPreviousEnd();
        PipeControlPoint other = null;
        if (dcp == ne) {
            other = pe;
        } else if (dcp == pe) {
            other = ne;
        } else {
            return tr;
        }
        if (other == null) {
            return tr;
        }
        Vector3d dir = dcp.getDirectedControlPointDirection();
        Vector3d dp = dcp.getWorldPosition();
        Vector3d op = other.getWorldPosition();
        Vector3d closest = MathTools.closestPointOnStraight((Tuple3d)op, (Tuple3d)dp, (Vector3d)dir, (double[])(u = new double[1]));
        if (MathTools.distanceSquared((Tuple3d)closest, (Tuple3d)op) <= MIN_INLINE_LENGTH) {
            if (u[0] > -MIN_INLINE_LENGTH) {
                return 0.0;
            }
            return tr * 2.0;
        }
        double curr = tr * 0.1;
        int iter = 10;
        Vector3d v1 = new Vector3d();
        Vector3d v2 = new Vector3d();
        while (iter > 0) {
            Vector3d tp = new Vector3d(dp);
            MathTools.mad((Tuple3d)tp, (Tuple3d)dir, (double)curr);
            v1.sub((Tuple3d)tp, (Tuple3d)dp);
            v2.sub((Tuple3d)op, (Tuple3d)tp);
            double a = v1.angle(v2);
            double t = Math.tan((Math.PI - a) * 0.5);
            double R = 0.0;
            if (t > MathTools.NEAR_ZERO) {
                R = tr / t;
            }
            if (R <= curr) break;
            curr = R * 1.001;
            --iter;
        }
        return curr;
    }

    private static void insertElbowUpdate(UpdateStruct2 u, PipeControlPoint dcp, PipeControlPoint next, boolean dcpStart, Vector3d position, Vector3d directedDirection) throws Exception {
        Vector3d closest;
        PipeControlPoint tcp = null;
        if (dcpStart) {
            closest = MathTools.closestPointOnStraight((Tuple3d)next.getWorldPosition(), (Tuple3d)position, (Vector3d)directedDirection);
            tcp = PipingRules.insertElbow(dcp, next, closest);
        } else {
            closest = MathTools.closestPointOnStraight((Tuple3d)dcp.getWorldPosition(), (Tuple3d)position, (Vector3d)directedDirection);
            tcp = PipingRules.insertElbow(next, dcp, closest);
        }
        double d = MathTools.distance((Tuple3d)position, (Tuple3d)closest);
        double s = PipingRules.spaceForTurn(tcp, dcp);
        if (d < s) {
            d = s - d;
            Vector3d p = new Vector3d(directedDirection);
            p.scale(d);
            p.add((Tuple3d)closest);
            tcp.setPosition(p);
            closest = p;
        }
        if (dcpStart) {
            PipingRules.ppNoDir(tcp, new Vector3d(closest), u.list, u.end, u.endPoint, u.hasOffsets, u.iter, u.reversed, u.toRemove, u.updated);
            PipingRules.processPathLeg(new UpdateStruct2(u.start, u.startPoint, new ArrayList<PipeControlPoint>(), tcp, new Vector3d(closest), directedDirection, new Vector3d(), false, 0, false, new ArrayList<ExpandIterInfo>(), u.updated));
        } else {
            PipingRules.ppNoDir(u.start, u.startPoint, u.list, tcp, new Vector3d(closest), u.hasOffsets, u.iter, u.reversed, u.toRemove, u.updated);
            PipingRules.processPathLeg(new UpdateStruct2(tcp, new Vector3d(closest), new ArrayList<PipeControlPoint>(), u.end, u.endPoint, directedDirection, new Vector3d(), false, 0, false, new ArrayList<ExpandIterInfo>(), u.updated));
        }
    }

    private static int checkTurns(UpdateStruct2 u, PathLegUpdateType lengthChange) throws Exception {
        PipeControlPoint endNext;
        PathLegUpdateType type;
        double a;
        PipeControlPoint startPrev;
        boolean startRemoved = false;
        boolean endRemoved = false;
        if (u.start.isVariableAngle() && (startPrev = u.start.getPrevious()) != null) {
            a = PipingRules.updateTurnControlPointTurn(u.start, null, u.dir);
            if (a < MIN_TURN_ANGLE && u.start.isDeletable()) {
                startRemoved = true;
            } else if (lengthChange == PathLegUpdateType.PREV || lengthChange == PathLegUpdateType.PREV_S) {
                type = lengthChange == PathLegUpdateType.PREV_S ? PathLegUpdateType.PREV : PathLegUpdateType.NONE;
                PipingRules.updatePathLegPrev(u.start, u.start, type);
            }
        }
        if (u.end.isVariableAngle() && (endNext = u.end.getNext()) != null) {
            a = PipingRules.updateTurnControlPointTurn(u.end, null, null);
            if (a < MIN_TURN_ANGLE && u.end.isDeletable()) {
                endRemoved = true;
            } else if (lengthChange == PathLegUpdateType.NEXT || lengthChange == PathLegUpdateType.NEXT_S) {
                type = lengthChange == PathLegUpdateType.NEXT_S ? PathLegUpdateType.NEXT : PathLegUpdateType.NONE;
                PipingRules.updatePathLegNext(u.end, u.end, type);
            }
        }
        if (!startRemoved && !endRemoved) {
            return 0;
        }
        if (startRemoved && endRemoved) {
            return 3;
        }
        if (startRemoved) {
            return 1;
        }
        return 2;
    }

    private static void expandPathLeg(UpdateStruct2 u, int type) throws Exception {
        ArrayList<PipeControlPoint> newList = new ArrayList<PipeControlPoint>();
        switch (type) {
            case 0: {
                throw new RuntimeException("Error in piping rules");
            }
            case 1: {
                u.toRemove.add(new ExpandIterInfo(u.start, 1));
                u.start = u.start.findPreviousEnd();
                u.startPoint = u.start.getPosition();
                u.start.findNextEnd(newList);
                newList.addAll(u.list);
                u.list = newList;
                break;
            }
            case 2: {
                u.toRemove.add(new ExpandIterInfo(u.end, 2));
                u.end = u.end.findNextEnd(newList);
                u.endPoint = u.end.getPosition();
                u.list.addAll(newList);
                break;
            }
            case 3: {
                u.toRemove.add(new ExpandIterInfo(u.start, u.end));
                u.start = u.start.findPreviousEnd();
                u.startPoint = u.start.getPosition();
                u.start.findNextEnd(newList);
                newList.addAll(u.list);
                u.list = newList;
                newList = new ArrayList();
                u.end = u.end.findNextEnd(newList);
                u.endPoint = u.end.getPosition();
                u.list.addAll(newList);
                break;
            }
            default: {
                throw new RuntimeException("Error in piping rules");
            }
        }
        u.offset = new Vector3d();
        if (u.hasOffsets) {
            u.dir.normalize();
            for (PipeControlPoint icp : u.list) {
                if (icp.isOffset()) {
                    u.offset.add((Tuple3d)icp.getSizeChangeOffsetVector(u.dir));
                    continue;
                }
                if (!icp.isDualSub()) continue;
                ErrorLogger.defaultLogError((String)("Updating pipe run, found offset controlpoint " + icp), (Throwable)new Exception("ASSERT!"));
            }
        }
        ++u.iter;
        PipingRules.updatePathLeg(u, PathLegUpdateType.NONE);
    }

    private static void backIter(UpdateStruct2 u) throws Exception {
        PipeControlPoint icp2;
        if (u.iter == 0) {
            throw new RuntimeException("Error in piping rules");
        }
        ExpandIterInfo info = u.toRemove.get(u.toRemove.size() - 1);
        u.toRemove.remove(u.toRemove.size() - 1);
        if (info.getType() == 1 || info.getType() == 3) {
            while (u.list.size() > 0) {
                icp2 = u.list.get(0);
                if (icp2.getPrevious().equals(info.getStart())) break;
                u.list.remove(icp2);
            }
            u.start = info.getStart();
        }
        if (info.getType() == 2 || info.getType() == 3) {
            while (u.list.size() > 0) {
                icp2 = u.list.get(u.list.size() - 1);
                if (icp2.getNext().equals(info.getEnd())) break;
                u.list.remove(icp2);
            }
            u.end = info.getEnd();
        }
        u.offset = new Vector3d();
        if (u.hasOffsets) {
            u.dir.normalize();
            for (PipeControlPoint icp2 : u.list) {
                if (icp2.isOffset()) {
                    u.offset.add((Tuple3d)icp2.getSizeChangeOffsetVector(u.dir));
                    continue;
                }
                if (!icp2.isDualSub()) continue;
                ErrorLogger.defaultLogError((String)("Updating pipe run, found offset controlpoint " + icp2), (Throwable)new Exception("ASSERT!"));
            }
        }
        PipingRules.processPathLeg(u);
    }

    private static void processPathLeg(UpdateStruct2 u) throws Exception {
        PipingRules.processPathLeg(u, true, true);
    }

    private static void processPathLeg(UpdateStruct2 u, boolean updateEnds, boolean updateInline) throws Exception {
        if (u.toRemove.size() > 0) {
            for (ExpandIterInfo info : u.toRemove) {
                if (info.getStart() != null) {
                    info.getStart()._remove();
                }
                if (info.getEnd() == null) continue;
                info.getEnd()._remove();
            }
            u.list.clear();
            u.start.findNextEnd(u.list);
        }
        PipingRules.updateInlineControlPoints(u, false);
        if (updateEnds) {
            if (u.start.isTurn()) {
                PipingRules.updateTurnControlPointTurn(u.start, null, null);
            } else if (u.start.isEnd()) {
                PipingRules.updateEndComponentControlPoint(u.start, u.dir);
            } else if (u.start.isInline()) {
                PipingRules.updateControlPointOrientation(u.start, u.dir);
            }
            if (u.end.isTurn()) {
                PipingRules.updateTurnControlPointTurn(u.end, null, null);
            } else if (u.end.isEnd()) {
                PipingRules.updateEndComponentControlPoint(u.end, u.dir);
            } else if (u.end.isInline()) {
                PipingRules.updateControlPointOrientation(u.end, u.dir);
            }
        } else {
            if (u.start.isEnd()) {
                PipingRules.updateEndComponentControlPoint(u.start, u.dir);
            }
            if (u.end.isEnd()) {
                PipingRules.updateEndComponentControlPoint(u.end, u.dir);
            }
        }
        if (updateInline) {
            PipingRules.updateInlineControlPoints(u, true);
        }
    }

    private static void processPathLegNoOffset(UpdateStruct2 u) throws Exception {
        Vector3d offset = new Vector3d();
        if (u.hasOffsets) {
            u.dir.normalize();
            for (PipeControlPoint icp : u.list) {
                if (icp.isOffset()) {
                    offset.add((Tuple3d)icp.getSizeChangeOffsetVector(u.dir));
                    continue;
                }
                if (!icp.isDualSub()) continue;
                ErrorLogger.defaultLogError((String)("Updating pipe run, found offset controlpoint " + icp), (Throwable)new Exception("ASSERT!"));
            }
        }
        PipingRules.processPathLeg(u);
    }

    private static void updateOffsetPoint(PipeControlPoint sccp, Vector3d offset) {
        Vector3d world = sccp.getWorldPosition();
        world.add((Tuple3d)offset);
        PipeControlPoint ocp = sccp.getDualSub();
        ocp.setWorldPosition(world);
    }

    private static void updateInlineControlPoint(PipeControlPoint icp, Vector3d prev, Vector3d next, Vector3d dir) {
        Vector3d inlinePoint = icp.getWorldPosition();
        Vector3d prevPoint = new Vector3d(prev);
        Vector3d nextPoint = new Vector3d(next);
        if (!icp.isVariableLength()) {
            MathTools.mad((Tuple3d)prevPoint, (Tuple3d)dir, (double)icp.getInlineLength());
            MathTools.mad((Tuple3d)nextPoint, (Tuple3d)dir, (double)(-icp.getInlineLength()));
            if (MathTools.distance((Tuple3d)prevPoint, (Tuple3d)nextPoint) < ALLOWED_OFFSET) {
                prevPoint = prev;
                nextPoint = next;
            }
        }
        boolean canCalc = MathTools.distance((Tuple3d)prevPoint, (Tuple3d)nextPoint) > ALLOWED_OFFSET;
        Vector3d newInlinePoint = null;
        if (canCalc) {
            boolean branchUpdate = false;
            PipeControlPoint becp = null;
            for (PipeControlPoint pcp : icp.getChildPoints()) {
                if (!pcp.isNonDirected()) continue;
                branchUpdate = true;
                becp = pcp;
                break;
            }
            if (!branchUpdate) {
                newInlinePoint = MathTools.closestPointOnEdge((Vector3d)new Vector3d(inlinePoint), (Vector3d)prevPoint, (Vector3d)nextPoint);
            } else {
                PipeControlPoint p = null;
                if (becp.getNext() != null) {
                    p = becp.findNextEnd();
                } else if (becp.getPrevious() != null) {
                    p = becp.findPreviousEnd();
                }
                if (p == null) {
                    newInlinePoint = MathTools.closestPointOnEdge((Vector3d)new Vector3d(inlinePoint), (Vector3d)prevPoint, (Vector3d)nextPoint);
                } else if (canCalc) {
                    Vector3d branchLegEnd = p.getWorldPosition();
                    Vector3d dir2 = new Vector3d(inlinePoint);
                    dir2.sub((Tuple3d)branchLegEnd);
                    Vector3d dir1 = new Vector3d(nextPoint);
                    dir1.sub((Tuple3d)prevPoint);
                    newInlinePoint = new Vector3d();
                    double[] mu = new double[2];
                    MathTools.intersectStraightStraight((Tuple3d)new Vector3d(prevPoint), (Vector3d)dir1, (Tuple3d)new Vector3d(branchLegEnd), (Vector3d)dir2, (Tuple3d)newInlinePoint, (Tuple3d)new Vector3d(), (double[])mu);
                    if (mu[0] < 0.0) {
                        newInlinePoint = new Vector3d(prevPoint);
                    } else if (mu[0] > 1.0) {
                        newInlinePoint = new Vector3d(nextPoint);
                    }
                }
            }
        } else {
            newInlinePoint = new Vector3d(prevPoint);
        }
        icp.setWorldPosition(newInlinePoint);
        PipingRules.updateControlPointOrientation(icp, dir);
    }

    private static void updateEndComponentControlPoint(PipeControlPoint ecp, Vector3d dir) throws Exception {
        if (!ecp.isFixed()) {
            PipingRules.updateControlPointOrientation(ecp, dir);
        }
        for (PipeControlPoint pcp : ecp.getChildPoints()) {
            PipingRules.updatePathLegEndControlPoint(pcp);
        }
    }

    private static void updateControlPointOrientation(PipeControlPoint pcp, Vector3d dir) {
        Double angleO = pcp.getRotationAngle();
        double angle = 0.0;
        if (angleO != null) {
            angle = angleO;
        }
        boolean reversed = pcp._getReversed();
        Quat4d q = null;
        q = dir != null ? pcp.getControlPointOrientationQuat(dir, angle, reversed) : pcp.getControlPointOrientationQuat(angle, reversed);
        pcp.setWorldOrientation(q);
    }

    private static void updateBranchControlPointBranches(PipeControlPoint bcp) throws Exception {
        if (bcp.isDualInline()) {
            return;
        }
        List<PipeControlPoint> branches = bcp.getChildPoints();
        if (branches.size() == 0) {
            return;
        }
        for (PipeControlPoint pcp : branches) {
            PipingRules.updatePathLegEndControlPoint(pcp);
        }
    }

    private static double updateTurnControlPointTurn(PipeControlPoint tcp, Vector3d prev, Vector3d next) {
        UpdateStruct2 us;
        if (next == null && (us = PipingRules.createUS(tcp, PipeControlPoint.Direction.NEXT, 0, new ArrayList<ExpandIterInfo>(), tcp)) != null) {
            next = us.dir;
        }
        if (prev == null && (us = PipingRules.createUS(tcp, PipeControlPoint.Direction.PREVIOUS, 0, new ArrayList<ExpandIterInfo>(), tcp)) != null) {
            prev = us.dir;
        }
        if (!tcp.asFixedAngle()) {
            if (next == null || prev == null) {
                if (tcp.getTurnAngle() != null) {
                    return tcp.getTurnAngle();
                }
                return Math.PI;
            }
            double turnAngle = prev.angle(next);
            double angle = Math.PI - turnAngle;
            Vector3d turnAxis = new Vector3d();
            turnAxis.cross(prev, next);
            if (turnAxis.lengthSquared() > MathTools.NEAR_ZERO) {
                double elbowRadius = ((TurnComponent)tcp.getPipelineComponent()).getTurnRadius();
                double R = elbowRadius / Math.tan(angle * 0.5);
                turnAxis.normalize();
                tcp.setTurnAngle(turnAngle);
                tcp.setLength(R);
                tcp.setTurnAxis(turnAxis);
            } else {
                turnAngle = 0.0;
                tcp.setTurnAngle(0.0);
                tcp.setLength(0.0);
                tcp.setTurnAxis(new Vector3d(MathTools.Y_AXIS));
            }
            PipingRules.updateControlPointOrientation(tcp, prev);
            return turnAngle;
        }
        if (prev == null || next == null) {
            if (prev == null) {
                if (!tcp._getReversed()) {
                    tcp.setReversed(true);
                }
            } else if (next == null && tcp._getReversed()) {
                tcp.setReversed(false);
            }
        }
        Vector3d dir = null;
        if (!tcp._getReversed()) {
            dir = prev;
        } else {
            dir = next;
            dir.negate();
        }
        if (dir == null) {
            return Math.PI;
        }
        Quat4d q = PipeControlPoint.getControlPointOrientationQuat(dir, tcp.getRotationAngle() != null ? tcp.getRotationAngle() : 0.0);
        Vector3d v = new Vector3d();
        MathTools.rotate((Quat4d)q, (Tuple3d)MathTools.Y_AXIS, (Tuple3d)v);
        tcp.setTurnAxis(v);
        tcp.setWorldOrientation(q);
        if (tcp.getTurnAngle() != null) {
            return tcp.getTurnAngle();
        }
        return Math.PI;
    }

    public static List<PipeControlPoint> getControlPoints(PipeRun pipeRun) {
        ArrayList<PipeControlPoint> list = new ArrayList<PipeControlPoint>();
        if (pipeRun.getControlPoints().size() == 0) {
            return list;
        }
        PipeControlPoint pcp = pipeRun.getControlPoints().iterator().next();
        while (pcp.getPrevious() != null) {
            PipeControlPoint prev = pcp.getPrevious();
            if (prev.getPipeRun() != pipeRun && prev.getPipeRun() != null) break;
            pcp = prev;
        }
        if (pcp.isDualSub()) {
            pcp = pcp.getParentPoint();
        }
        list.add(pcp);
        while (pcp.getNext() != null) {
            if ((pcp = pcp.getNext()).getPipeRun() != pipeRun) break;
            list.add(pcp);
        }
        return list;
    }

    public static void reverse(PipeRun pipeRun) {
        PipeRun pr;
        List<PipeControlPoint> points;
        PipeControlPoint pcp;
        while ((pcp = (points = PipingRules.getControlPoints(pipeRun)).get(0)).isSizeChange() && pcp.getChildPoints().size() > 0 && (pr = pcp.getPipeRun()) != pipeRun) {
            pipeRun = pr;
        }
        ArrayList<PipeRun> all = new ArrayList<PipeRun>();
        ArrayList<List<PipeControlPoint>> pcps = new ArrayList<List<PipeControlPoint>>();
        while (true) {
            PipeRun pipeRun2;
            all.add(pipeRun);
            List<PipeControlPoint> points2 = PipingRules.getControlPoints(pipeRun);
            pcps.add(points2);
            PipeControlPoint pcp2 = points2.get(points2.size() - 1);
            if (pcp2.getChildPoints().size() <= 0 || pipeRun == (pipeRun2 = pcp2.getChildPoints().get(0).getPipeRun())) break;
            pipeRun = pipeRun2;
        }
        int i = 0;
        while (i < all.size()) {
            List list = (List)pcps.get(i);
            PipingRules._reverse(list);
            ++i;
        }
        i = 0;
        while (i < all.size()) {
            boolean last = i == all.size() - 1;
            List list = (List)pcps.get(i);
            if (!last) {
                PipeControlPoint next;
                List list2 = (List)pcps.get(i + 1);
                PipeControlPoint prev = (PipeControlPoint)list.get(list.size() - 1);
                if (prev == (next = (PipeControlPoint)list2.get(0))) {
                    InlineComponent ic = (InlineComponent)prev.getPipelineComponent();
                    PipeRun r1 = ic.getPipeRun();
                    PipeRun r2 = ic.getAlternativePipeRun();
                    if (r1 == null || r2 == null) {
                        throw new RuntimeException("Components on PipeRun changes should refer to bot PipeRuns");
                    }
                    ic.deattach();
                    r2.addChild(ic);
                    ic.setPipeRun(r2);
                    ic.setAlternativePipeRun(r1);
                } else {
                    throw new RuntimeException("PipeRun changes should contain shared control points");
                }
            }
            ++i;
        }
    }

    private static void _reverse(List<PipeControlPoint> list) {
        if (list.size() <= 1) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            PipeControlPoint prev;
            boolean first = i == 0;
            boolean last = i == list.size() - 1;
            PipeControlPoint current = list.get(i);
            PipeControlPoint currentSub = null;
            if (current.isDualInline()) {
                currentSub = current.getDualSub();
            }
            if (first) {
                PipeControlPoint next = list.get(i + 1);
                if (next.isDualInline()) {
                    next = next.getDualSub();
                }
                if (current.getNext() == next) {
                    current.setNext(null);
                }
                current.setPrevious(next);
                if (currentSub != null) {
                    if (currentSub.getNext() == next) {
                        currentSub.setNext(null);
                    }
                    currentSub.setPrevious(next);
                }
            } else if (last) {
                prev = list.get(i - 1);
                if (current.getPrevious() == prev) {
                    current.setPrevious(null);
                }
                current.setNext(prev);
                if (currentSub != null) {
                    if (currentSub.getPrevious() == prev) {
                        currentSub.setPrevious(null);
                    }
                    currentSub.setNext(prev);
                }
            } else {
                prev = list.get(i - 1);
                PipeControlPoint next = list.get(i + 1);
                if (next.isDualInline()) {
                    next = next.getDualSub();
                }
                current.setPrevious(next);
                current.setNext(prev);
                if (currentSub != null) {
                    currentSub.setPrevious(next);
                    currentSub.setNext(prev);
                }
            }
            if (current.asFixedAngle()) {
                current.setReversed(!current._getReversed());
            }
            if (current.isInline() && current.isReverse()) {
                current.setReversed(!current._getReversed());
            }
            ++i;
        }
    }

    public static void validate(PipeRun pipeRun) {
        if (pipeRun == null) {
            return;
        }
        Collection<PipeControlPoint> pcps = pipeRun.getControlPoints();
        int count = 0;
        for (PipeControlPoint pcp : pcps) {
            if (pcp.getParentPoint() != null && pcp.getParentPoint().getPipeRun() == pipeRun) continue;
            ++count;
        }
        List<PipeControlPoint> runPcps = PipingRules.getControlPoints(pipeRun);
        if (runPcps.size() != count) {
            System.out.println("Run " + pipeRun.getName() + " contains unconnected control points, found " + runPcps.size() + " connected, " + pcps.size() + " total.");
            for (PipeControlPoint pcp : pcps) {
                if (runPcps.contains(pcp)) continue;
                System.out.println("Unconnected " + pcp + " " + pcp.getPipelineComponent());
            }
        }
        for (PipeControlPoint pcp : pcps) {
            if (pcp.getPipeRun() == null) {
                System.out.println("PipeRun ref missing " + pcp + " " + pcp.getPipelineComponent());
            }
            if (pcp.isDirected() || pcp.getNext() != null || pcp.getPrevious() != null) continue;
            System.out.println("Orphan undirected " + pcp + " " + pcp.getPipelineComponent());
        }
        for (PipeControlPoint pcp : pcps) {
            if (pcp.getParentPoint() != null) continue;
            PipeControlPoint sub = null;
            if (pcp.isDualInline()) {
                sub = pcp.getDualSub();
            }
            PipeControlPoint next = pcp.getNext();
            PipeControlPoint prev = pcp.getPrevious();
            if (next != null && next.getPrevious() != pcp && next.getPrevious() != sub) {
                System.out.println("Inconsistency between " + pcp + " -> " + next);
            }
            if (prev == null) continue;
            PipeControlPoint prevParent = null;
            if (prev.isDualSub()) {
                prevParent = prev.getParentPoint();
            } else if (prev.isDualInline()) {
                System.out.println("Inconsistency between " + pcp + " <-- " + prev);
            }
            if (prev.getNext() == pcp && (prevParent == null || prevParent.getNext() == pcp)) continue;
            System.out.println("Inconsistency between " + pcp + " <-- " + prev);
        }
    }

    public static void splitVariableLengthComponent(PipelineComponent newComponent, InlineComponent splittingComponent, boolean assignPos) throws Exception {
        Vector3d dir;
        assert (!splittingComponent.getControlPoint().isFixedLength());
        assert (!(newComponent instanceof InlineComponent) || newComponent.getControlPoint().isFixedLength());
        PipeControlPoint newCP = newComponent.getControlPoint();
        PipeControlPoint splittingCP = splittingComponent.getControlPoint();
        PipeControlPoint nextCP = splittingCP.getNext();
        PipeControlPoint prevCP = splittingCP.getPrevious();
        if (nextCP == null && prevCP == null) {
            throw new RuntimeException("VariableLengthComponent " + splittingComponent + " is not connected to anything.");
        }
        double newLength = newComponent.getControlPoint().getLength();
        Point3d next = new Point3d();
        Point3d prev = new Point3d();
        splittingCP.getInlineControlPointEnds((Tuple3d)prev, (Tuple3d)next);
        Vector3d newPos = null;
        if (assignPos) {
            newPos = new Vector3d((Tuple3d)prev);
            dir = new Vector3d((Tuple3d)next);
            dir.sub((Tuple3d)prev);
            dir.scale(0.5);
            newPos.add((Tuple3d)dir);
            newComponent.setWorldPosition(newPos);
        } else {
            newPos = newComponent.getWorldPosition();
        }
        dir = new Vector3d((Tuple3d)next);
        dir.sub((Tuple3d)prev);
        dir.normalize();
        dir.scale(newLength * 0.5);
        Point3d vn = new Point3d((Tuple3d)newPos);
        Point3d vp = new Point3d((Tuple3d)newPos);
        vn.add((Tuple3d)dir);
        vp.sub((Tuple3d)dir);
        double ln = vn.distance(next);
        double lp = vp.distance(prev);
        vp.interpolate((Tuple3d)prev, 0.5);
        vn.interpolate((Tuple3d)next, 0.5);
        if (nextCP == null) {
            newCP.insert(splittingCP, PipeControlPoint.Direction.NEXT);
            PipingRules.insertStraight(newCP, PipeControlPoint.Direction.NEXT, new Vector3d((Tuple3d)vn), ln);
            splittingCP.setWorldPosition(new Vector3d((Tuple3d)vp));
        } else if (prevCP == null) {
            newCP.insert(splittingCP, PipeControlPoint.Direction.PREVIOUS);
            PipingRules.insertStraight(newCP, PipeControlPoint.Direction.PREVIOUS, new Vector3d((Tuple3d)vp), lp);
            splittingCP.setWorldPosition(new Vector3d((Tuple3d)vn));
        } else {
            newCP.insert(splittingCP, nextCP);
            PipingRules.insertStraight(newCP, nextCP, new Vector3d((Tuple3d)vn), ln);
            splittingCP.setWorldPosition(new Vector3d((Tuple3d)vp));
        }
        PipingRules.positionUpdate(newCP);
    }

    public static void addSizeChange(boolean reversed, PipeRun pipeRun, PipeRun other, InlineComponent reducer, PipeControlPoint previous, PipeControlPoint next) {
        PipeControlPoint pcp = reducer.getControlPoint();
        PipeControlPoint ocp = pcp.getDualSub();
        if (!reversed) {
            String name = pipeRun.getUniqueName("Reducer");
            reducer.setName(name);
            pipeRun.addChild(reducer);
            other.addChild(ocp);
            reducer.setAlternativePipeRun(other);
            previous.setNext(pcp);
            pcp.setPrevious(previous);
            ocp.setPrevious(previous);
            if (next != null) {
                pcp.setNext(next);
                ocp.setNext(next);
                next.setPrevious(ocp);
            }
        } else {
            String name = other.getUniqueName("Reducer");
            reducer.setName(name);
            other.addChild(reducer);
            pipeRun.addChild(ocp);
            reducer.setAlternativePipeRun(pipeRun);
            if (next != null) {
                next.setNext(pcp);
                pcp.setPrevious(next);
                ocp.setPrevious(next);
            }
            pcp.setNext(previous);
            ocp.setNext(previous);
            previous.setPrevious(ocp);
        }
    }

    public static class ExpandIterInfo {
        private PipeControlPoint start;
        private PipeControlPoint end;
        private int type;

        public ExpandIterInfo() {
        }

        public ExpandIterInfo(PipeControlPoint tcp, int type) {
            if (type == 1) {
                this.start = tcp;
            } else {
                this.end = tcp;
            }
            this.type = type;
        }

        public ExpandIterInfo(PipeControlPoint start, PipeControlPoint end) {
            this.start = start;
            this.end = end;
            this.type = 3;
        }

        public PipeControlPoint getEnd() {
            return this.end;
        }

        public void setEnd(PipeControlPoint end) {
            this.end = end;
        }

        public PipeControlPoint getStart() {
            return this.start;
        }

        public void setStart(PipeControlPoint start) {
            this.start = start;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }

    private static enum Gap {
        ATTACHED,
        OVERLAP,
        SPACE;

    }

    private static class GapObj {
        Gap gap;
        double d;
        Pair<PipeControlPoint, Vector3d> pcp1;
        Pair<PipeControlPoint, Vector3d> pcp2;

        private GapObj() {
        }
    }

    private static enum PathLegUpdateType {
        NONE,
        PREV,
        NEXT,
        PREV_S,
        NEXT_S;

    }

    private static class UpdateStruct2 {
        public PipeControlPoint start;
        public Vector3d startPoint;
        public ArrayList<PipeControlPoint> list;
        public PipeControlPoint end;
        public Vector3d endPoint;
        public Vector3d dir;
        public Vector3d offset;
        public boolean hasOffsets;
        public int iter;
        public boolean reversed;
        public ArrayList<ExpandIterInfo> toRemove;
        public PipeControlPoint updated;

        public UpdateStruct2(PipeControlPoint start, Vector3d startPoint, ArrayList<PipeControlPoint> list, PipeControlPoint end, Vector3d endPoint, Vector3d dir, Vector3d offset, boolean hasOffsets, int iter, boolean reversed, ArrayList<ExpandIterInfo> toRemove, PipeControlPoint updated) {
            if (start == null || end == null) {
                throw new NullPointerException();
            }
            this.start = start;
            this.startPoint = startPoint;
            this.list = list;
            this.end = end;
            this.endPoint = endPoint;
            this.dir = dir;
            this.offset = offset;
            this.hasOffsets = hasOffsets;
            this.iter = iter;
            this.reversed = reversed;
            this.toRemove = toRemove;
            this.updated = updated;
            if (!(MathTools.isValid((Tuple3d)startPoint) && MathTools.isValid((Tuple3d)endPoint) && MathTools.isValid((Tuple3d)dir))) {
                throw new RuntimeException();
            }
        }

        public String toString() {
            return this.start + " " + this.end + " " + this.dir + " " + this.hasOffsets + " " + this.offset + " " + this.iter + " " + this.toRemove.size();
        }
    }
}

