/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph.controlpoint;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.plant3d.ontology.Plant3D;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import org.simantics.plant3d.utils.Item;
import org.simantics.plant3d.utils.P3DUtil;

public class ControlPointFactory {
    private static Map<String, Instruction> cache = new HashMap<String, Instruction>();

    public static void preloadCache(String libUri) throws Exception {
        List<Item> items = P3DUtil.getEnds(libUri);
        items.addAll(P3DUtil.getInlines(libUri));
        items.addAll(P3DUtil.getNozzles(libUri));
        items.addAll(P3DUtil.getTurns(libUri));
        for (Item item : items) {
            Instruction inst = ControlPointFactory.createInstruction(item.getUri());
            cache.put(item.getUri(), inst);
        }
    }

    public static PipeControlPoint create(PipelineComponent component) throws Exception {
        Instruction inst = cache.get(component.getType());
        if (inst == null) {
            inst = ControlPointFactory.createInstruction(component.getType());
            cache.put(component.getType(), inst);
        }
        if (inst == null) {
            return null;
        }
        PipeControlPoint pcp = new PipeControlPoint(component);
        pcp.setType(inst.type);
        pcp.setFixed(inst.fixed);
        pcp.setMod(inst.mod);
        pcp.setRotate(inst.isRotate);
        pcp.setReverse(inst.isReverse);
        switch (inst.type) {
            case END: {
                break;
            }
            case INLINE: {
                if (!inst.isOffset && !inst.isSizeChange) break;
                PipeControlPoint sub = new PipeControlPoint(component);
                pcp.children.add(sub);
                sub.parent = pcp;
                sub.setType(inst.type);
                sub.setFixed(inst.fixed);
                sub.setMod(inst.mod);
                sub.setSub(true);
                sub.setDeletable(false);
                if (inst.isOffset) {
                    pcp.setOffset(0.0);
                }
                if (!inst.isSizeChange) break;
                pcp.setSizeChange(true);
                break;
            }
        }
        return pcp;
    }

    private static Instruction createInstruction(final String type) throws Exception {
        return (Instruction)Simantics.getSession().syncRequest((Read)new Read<Instruction>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Instruction perform(ReadGraph graph) throws DatabaseException {
                Resource res = graph.getResource(type);
                Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
                Instruction i = new Instruction();
                i.fixed = false;
                i.isOffset = false;
                i.isSizeChange = false;
                i.isRotate = false;
                i.isReverse = false;
                i.type = PipeControlPoint.PointType.INLINE;
                i.mod = false;
                if (graph.isInheritedFrom(res, p3d.Nozzle)) {
                    i.fixed = true;
                    i.isOffset = false;
                    i.isSizeChange = false;
                    i.type = PipeControlPoint.PointType.END;
                    return i;
                } else if (graph.isInheritedFrom(res, p3d.InlineComponent)) {
                    i.type = PipeControlPoint.PointType.INLINE;
                    if (graph.hasStatement(res, p3d.VariableLengthInlineComponent)) {
                        i.fixed = false;
                    } else if (graph.hasStatement(res, p3d.FixedLengthInlineComponent)) {
                        i.fixed = true;
                    } else {
                        if (!graph.hasStatement(res, p3d.AdjustableLengthInlineComponent)) throw new DatabaseException("Inline component type " + res + " does not have length configuration.");
                        i.fixed = true;
                        i.mod = true;
                    }
                    if (graph.hasStatement(res, p3d.SizeChangeComponent)) {
                        i.isSizeChange = true;
                    }
                    if (graph.hasStatement(res, p3d.OffsetComponent)) {
                        i.isOffset = true;
                    }
                    if (graph.hasStatement(res, p3d.RotateComponent)) {
                        i.isRotate = true;
                    }
                    if (!graph.hasStatement(res, p3d.ReverseComponent)) return i;
                    i.isReverse = true;
                    return i;
                } else if (graph.isInheritedFrom(res, p3d.TurnComponent)) {
                    i.type = PipeControlPoint.PointType.TURN;
                    if (graph.hasStatement(res, p3d.VariableAngleTurnComponent)) {
                        i.fixed = false;
                        return i;
                    } else {
                        if (!graph.hasStatement(res, p3d.FixedAngleTurnComponent)) throw new DatabaseException("Turn component type " + res + " does not have angle configuration.");
                        i.fixed = true;
                    }
                    return i;
                } else {
                    if (!graph.isInheritedFrom(res, p3d.EndComponent)) return null;
                    i.fixed = false;
                    i.type = PipeControlPoint.PointType.END;
                }
                return i;
            }
        });
    }

    private static class Instruction {
        PipeControlPoint.PointType type;
        boolean fixed;
        boolean mod;
        boolean isOffset;
        boolean isSizeChange;
        boolean isRotate;
        boolean isReverse;

        private Instruction() {
        }
    }
}

