/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph;

import java.util.HashSet;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.g3d.property.annotations.PropertyContributor;
import org.simantics.g3d.property.annotations.SetPropertyValue;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.tools.NodeTools;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;
import org.simantics.plant3d.scenegraph.IP3DNode;
import org.simantics.plant3d.scenegraph.IP3DVisualNode;

@PropertyContributor
public abstract class P3DParentNode<T extends IP3DNode>
extends ParentNode<T>
implements IP3DVisualNode {
    private String name;
    private Vector3d position = new Vector3d();
    private Quat4d orientation = MathTools.getIdentityQuat();

    @Override
    @RelatedGetValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    @GetPropertyValue(value="http://www.simantics.org/Layer0-1.1/HasName", tabId="Default", name="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @RelatedSetValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    @SetPropertyValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.name = name;
        this.firePropertyChanged("http://www.simantics.org/Layer0-1.1/HasName");
    }

    public String toString() {
        return this.getName();
    }

    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasOrientation", tabId="Transform", name="Orientation")
    public Quat4d getOrientation() {
        return this.orientation;
    }

    @RelatedGetValue(value="http://www.simantics.org/G3D-0.1/hasOrientation")
    public double[] getOrientationArr() {
        double[] arr = new double[4];
        this.orientation.get(arr);
        return arr;
    }

    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasPosition", tabId="Transform", name="Position")
    public Vector3d getPosition() {
        return this.position;
    }

    @RelatedGetValue(value="http://www.simantics.org/G3D-0.1/hasPosition")
    public double[] getPositionArr() {
        double[] arr = new double[3];
        this.position.get(arr);
        return arr;
    }

    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasOrientation")
    public void setOrientation(Quat4d orientation) {
        assert (orientation != null);
        this.orientation = orientation;
        this.firePropertyChanged("http://www.simantics.org/G3D-0.1/hasOrientation");
    }

    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasPosition")
    public void setPosition(Vector3d position) {
        assert (position != null);
        this.position = position;
        this.firePropertyChanged("http://www.simantics.org/G3D-0.1/hasPosition");
    }

    @RelatedSetValue(value="http://www.simantics.org/G3D-0.1/hasOrientation")
    public void setOrientation(double[] arr) {
        if (arr == null) {
            return;
        }
        this.setOrientation(new Quat4d(arr));
    }

    @RelatedSetValue(value="http://www.simantics.org/G3D-0.1/hasPosition")
    public void setPosition(double[] arr) {
        if (arr == null) {
            return;
        }
        this.setPosition(new Vector3d(arr));
    }

    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldPosition", tabId="Transform", name="World Position")
    public Vector3d getWorldPosition() {
        IG3DNode parent = (IG3DNode)this.getParent();
        if (parent == null) {
            return this.position;
        }
        return NodeTools.getWorldPosition((IG3DNode)parent, (Vector3d)new Vector3d(this.position));
    }

    public Vector3d getWorldPosition(Vector3d localPosition) {
        return NodeTools.getWorldPosition((IG3DNode)this, (Vector3d)localPosition);
    }

    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldOrientation", tabId="Transform", name="World Orientation")
    public Quat4d getWorldOrientation() {
        return this.getWorldOrientation(new Quat4d(this.orientation));
    }

    public Quat4d getWorldOrientation(Quat4d localOrientation) {
        IG3DNode parent = (IG3DNode)this.getParent();
        if (parent == null) {
            return localOrientation;
        }
        return NodeTools.getWorldOrientation((IG3DNode)parent, (Quat4d)localOrientation);
    }

    public Vector3d getLocalPosition(Vector3d worldPosition) {
        IG3DNode parent = (IG3DNode)this.getParent();
        if (parent == null) {
            return worldPosition;
        }
        return NodeTools.getLocalPosition((IG3DNode)parent, (Vector3d)new Vector3d(worldPosition));
    }

    public Quat4d getLocalOrientation(Quat4d worldOrientation) {
        IG3DNode parent = (IG3DNode)this.getParent();
        if (parent == null) {
            return worldOrientation;
        }
        return NodeTools.getLocalOrientation((IG3DNode)parent, (Quat4d)new Quat4d(worldOrientation));
    }

    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldPosition")
    public void setWorldPosition(Vector3d position) {
        Vector3d localPos = this.getLocalPosition(position);
        this.setPosition(localPos);
    }

    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldOrientation")
    public void setWorldOrientation(Quat4d orientation) {
        Quat4d localOr = this.getLocalOrientation(orientation);
        this.setOrientation(localOr);
    }

    public <C> C getAdapter(Class<C> adapter) {
        if (adapter.isInstance(this)) {
            return adapter.cast(this);
        }
        return null;
    }

    public String getUniqueName(String prefix) {
        HashSet<String> names = new HashSet<String>();
        for (IP3DNode node : this.getNodes()) {
            if (!(node instanceof IP3DVisualNode)) continue;
            IP3DVisualNode n = (IP3DVisualNode)node;
            names.add(n.getName());
        }
        int i = 1;
        String genName;
        while (names.contains(genName = String.valueOf(prefix) + "_" + i)) {
            ++i;
        }
        return genName;
    }
}

