/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.scenegraph.GeometryProvider;
import org.simantics.g3d.scenegraph.MeshProvider;
import org.simantics.g3d.scenegraph.NodeHighlighter;
import org.simantics.g3d.scenegraph.ParametricGeometryProvider;
import org.simantics.g3d.shape.Mesh;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.shape.MeshActor;
import org.simantics.g3d.vtk.shape.vtkMeshObject;
import org.simantics.opencascade.OccTriangulator;
import org.simantics.opencascade.SolidModelProvider;
import org.simantics.opencascade.vtk.vtkSolidObject;
import vtk.vtkActor;
import vtk.vtkProp3D;
import vtk.vtkProperty;

public class GeometryComponent {
    private TopoDS_Shape solidModel;
    private vtkSolidObject solidObject;
    private Mesh mesh;
    private vtkMeshObject meshObject;
    private Map<String, Object> currentParameters = new HashMap<String, Object>();
    private Map<String, Object> calculatedParameters = new HashMap<String, Object>();
    private boolean parametersUpdated = true;
    private GeometryProvider geometryProvider;
    private boolean selected = false;
    private boolean hover = false;

    public void visualize(VtkView panel) {
        if (this.geometryProvider != null) {
            this.updateParameters();
            if (this.geometryProvider instanceof SolidModelProvider) {
                SolidModelProvider solidModelProvider = (SolidModelProvider)this.geometryProvider;
                if (this.solidModel == null || this.parametersUpdated) {
                    this.createGeometry(solidModelProvider);
                }
                if ((this.solidObject == null || this.parametersUpdated) && this.solidModel != null) {
                    this.solidObject = new vtkSolidObject(panel, this.solidModel);
                }
                if (this.solidObject != null) {
                    this.solidObject.visualizeSolid(true, true, false, false);
                    this.updateVisuals(true, true);
                }
            } else if (this.geometryProvider instanceof MeshProvider) {
                MeshProvider provider = (MeshProvider)this.geometryProvider;
                if (this.mesh == null || this.parametersUpdated) {
                    this.mesh = provider.getMesh();
                }
                if ((this.meshObject == null || this.parametersUpdated) && this.mesh != null) {
                    this.meshObject = new vtkMeshObject(panel, this.mesh);
                }
                if (this.meshObject != null) {
                    this.meshObject.visualizeMesh();
                    this.updateVisuals(true, true);
                }
            }
        }
        this.parametersUpdated = false;
    }

    public void updateParameters() {
        if (this.geometryProvider instanceof ParametricGeometryProvider) {
            ((ParametricGeometryProvider)this.geometryProvider).setProperties(this.currentParameters);
            ((ParametricGeometryProvider)this.geometryProvider).updateCalculatedProperties(this.calculatedParameters);
        }
    }

    private void createGeometry(SolidModelProvider solidModelProvider) {
        try {
            Collection shapes = solidModelProvider.getModel();
            if (shapes.size() == 1) {
                this.solidModel = (TopoDS_Shape)shapes.iterator().next();
            } else {
                this.solidModel = OccTriangulator.makeCompound((TopoDS_Shape[])shapes.toArray(new TopoDS_Shape[shapes.size()]));
                for (TopoDS_Shape shape : shapes) {
                    shape.delete();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> getParameterMap() {
        return Collections.unmodifiableMap(this.currentParameters);
    }

    public Map<String, Object> getCalculatedParameters() {
        return this.calculatedParameters;
    }

    public Map<String, Object> getTotalParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(this.currentParameters);
        params.putAll(this.calculatedParameters);
        return params;
    }

    public void setParametersUpdated(boolean parametersUpdated) {
        this.parametersUpdated = parametersUpdated;
    }

    public Set<String> setParameterMap(Map<String, Object> parameters) {
        HashSet<String> ids = new HashSet<String>();
        for (String id : parameters.keySet()) {
            Object newValue;
            Object currentValue = this.currentParameters.get(id);
            if (currentValue == (newValue = parameters.get(id)) || newValue == null || currentValue instanceof Double && Math.abs((Double)currentValue - (Double)newValue) < MathTools.NEAR_ZERO) continue;
            this.currentParameters.put(id, newValue);
            this.parametersUpdated = true;
            ids.add(id);
        }
        return ids;
    }

    public GeometryProvider getGeometry() {
        return this.geometryProvider;
    }

    public void setGeometry(GeometryProvider provider) {
        if (provider != null && provider.equals(this.geometryProvider)) {
            return;
        }
        if (this.geometryProvider != null) {
            this.deleteData();
        }
        this.geometryProvider = provider;
    }

    private void deleteData() {
        this.geometryProvider = null;
        if (this.solidObject != null) {
            this.solidObject.clearActors();
            this.solidObject = null;
        }
        if (this.solidModel != null) {
            this.solidModel.delete();
            this.solidModel = null;
        }
        if (this.meshObject != null) {
            this.meshObject.clearActors();
            this.meshObject = null;
        }
        if (this.mesh != null) {
            this.mesh = null;
        }
    }

    public Collection<vtkProp3D> getActors() {
        ArrayList<vtkProp3D> list = new ArrayList<vtkProp3D>();
        if (this.solidObject != null) {
            list.addAll(this.solidObject.getActors());
        }
        if (this.meshObject != null && this.meshObject.getActor() != null) {
            list.add((vtkProp3D)this.meshObject.getActor());
        }
        return list;
    }

    public void stopVisualize() {
        if (this.solidObject != null) {
            this.solidObject.clearActorsVTK();
            this.solidObject = null;
        }
        if (this.solidModel != null) {
            this.solidModel.delete();
            this.solidModel = null;
        }
        if (this.meshObject != null) {
            this.meshObject.clearActorsVTK();
            this.meshObject = null;
        }
        if (this.mesh != null) {
            this.mesh = null;
        }
    }

    public void highlight(NodeHighlighter.HighlightEventType type) {
        if (type == NodeHighlighter.HighlightEventType.Selection || type == NodeHighlighter.HighlightEventType.ClearSelection) {
            this.selected = type == NodeHighlighter.HighlightEventType.Selection;
            this.updateVisuals(true, false);
        } else {
            this.hover = type == NodeHighlighter.HighlightEventType.Hover;
            this.updateVisuals(false, true);
        }
    }

    protected double[] getSelectedColor() {
        return new double[]{1.0, 0.0, 0.0};
    }

    protected double[] getColor() {
        return new double[]{1.0, 1.0, 0.0};
    }

    public void updateVisuals(boolean s, boolean h) {
        if (this.solidObject != null) {
            vtkProperty property;
            double[] color;
            if (s) {
                color = this.selected ? this.getSelectedColor() : this.getColor();
                for (vtkProp3D prop : this.solidObject.getSolid()) {
                    property = ((vtkActor)prop).GetProperty();
                    property.SetColor(color);
                    property.Delete();
                }
            }
            if (h) {
                color = new double[]{0.0, 0.0, 0.0};
                if (this.hover) {
                    color = new double[]{1.0, 0.0, 1.0};
                }
                for (vtkProp3D prop : this.solidObject.getEdges()) {
                    property = ((vtkActor)prop).GetProperty();
                    property.SetColor(color);
                    property.Delete();
                }
            }
        } else if (this.meshObject != null) {
            vtkProperty property;
            double[] color;
            if (s) {
                color = this.selected ? this.getSelectedColor() : this.getColor();
                MeshActor prop = this.meshObject.getActor();
                if (prop != null) {
                    property = ((vtkActor)prop).GetProperty();
                    property.SetColor(color);
                    property.Delete();
                }
            }
            if (h) {
                color = new double[]{0.0, 0.0, 0.0};
                MeshActor actor = this.meshObject.getActor();
                if (actor != null) {
                    property = actor.GetProperty();
                    if (this.hover) {
                        color = new double[]{1.0, 0.0, 1.0};
                        property.SetEdgeVisibility(1);
                        property.SetEdgeColor(color);
                    } else {
                        property.SetEdgeVisibility(0);
                        property.SetEdgeColor(color);
                    }
                    property.Delete();
                }
            }
        }
    }
}

