/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.property.annotations.CompoundGetPropertyValue;
import org.simantics.g3d.property.annotations.CompoundSetPropertyValue;
import org.simantics.g3d.scenegraph.GeometryProvider;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.objmap.graph.annotations.CompoundRelatedGetValue;
import org.simantics.objmap.graph.annotations.CompoundRelatedSetValue;
import org.simantics.objmap.graph.annotations.DynamicGraphType;
import org.simantics.objmap.graph.annotations.GetType;
import org.simantics.objmap.graph.annotations.RelatedElementsAdd;
import org.simantics.objmap.graph.annotations.RelatedElementsGet;
import org.simantics.objmap.graph.annotations.RelatedElementsRem;
import org.simantics.objmap.graph.annotations.SetType;
import org.simantics.plant3d.geometry.FixedNozzleProvider;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.P3DParentGeometryNode;
import org.simantics.plant3d.scenegraph.controlpoint.PipingRules;

@DynamicGraphType(value="http://www.simantics.org/Plant3D-0.1/Equipment")
public class Equipment
extends P3DParentGeometryNode<Nozzle> {
    private String type;
    private FixedNozzleProvider fnp;

    @GetType(value="http://www.simantics.org/Plant3D-0.1/Equipment")
    public String getType() {
        return this.type;
    }

    @SetType(value="http://www.simantics.org/Plant3D-0.1/Equipment")
    public void setType(String type) {
        this.type = type;
    }

    @RelatedElementsAdd(value="http://www.simantics.org/Plant3D-0.1/HasNozzle")
    public void addChild(Nozzle node) {
        Collection<Nozzle> children = this.getChild();
        if (this.numberOfFixedNozzles() > 0 && children.size() >= this.numberOfFixedNozzles()) {
            throw new RuntimeException("Equipment has already all fixed nozzles");
        }
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Nozzle n : children) {
            ids.add(n.getNozzleId());
        }
        int newId = 0;
        while (ids.contains(newId)) {
            ++newId;
        }
        this.addNode("http://www.simantics.org/Plant3D-0.1/HasNozzle", (INode)node);
        node.setNozzleId(newId);
        if (this.fnp != null) {
            this.syncNozzles();
        }
    }

    @RelatedElementsGet(value="http://www.simantics.org/Plant3D-0.1/HasNozzle")
    public Collection<Nozzle> getChild() {
        return this.getNodes("http://www.simantics.org/Plant3D-0.1/HasNozzle");
    }

    @RelatedElementsRem(value="http://www.simantics.org/Plant3D-0.1/HasNozzle")
    public void remChild(Nozzle node) {
        this.removeNode("http://www.simantics.org/Plant3D-0.1/HasNozzle", (INode)node);
    }

    @Override
    @CompoundRelatedGetValue(objRelation="http://www.simantics.org/Plant3D-0.1/hasParameter", objType="http://www.simantics.org/Plant3D-0.1/Parameter", valRelation="http://www.simantics.org/Plant3D-0.1/hasParameterValue")
    @CompoundGetPropertyValue(name="Parameters", tabId="Parameters", value="parameters")
    public Map<String, Object> getParameterMap() {
        return super.getParameterMap();
    }

    @Override
    @CompoundRelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/hasParameter")
    @CompoundSetPropertyValue(value="parameters")
    public void setParameterMap(Map<String, Object> parameters) {
        super.setParameterMap(parameters);
        this.syncNozzles();
    }

    @Override
    public void setGeometry(GeometryProvider provider) {
        super.setGeometry(provider);
        if (provider instanceof FixedNozzleProvider) {
            this.fnp = (FixedNozzleProvider)provider;
            this.syncNozzles();
        }
    }

    public int numberOfFixedNozzles() {
        if (this.fnp == null) {
            return 0;
        }
        return this.fnp.numberOfNozzles();
    }

    public void syncNozzles() {
        if (this.fnp == null) {
            return;
        }
        this.updateParameters();
        int count = this.fnp.numberOfNozzles();
        List currentNozzles = this.getNodes();
        int i = 0;
        while (i < count) {
            if (i < currentNozzles.size()) {
                Nozzle nozzle = (Nozzle)currentNozzles.get(i);
                nozzle.setName(this.fnp.getNozzleName(i));
                this.fnp.updateNozzlePosition(i, nozzle);
                nozzle.setFixed(true);
            }
            ++i;
        }
    }

    @Override
    protected double[] getColor() {
        return new double[]{1.0, 0.0, 0.0};
    }

    @Override
    protected double[] getSelectedColor() {
        return new double[]{0.5, 0.0, 0.5};
    }

    @Override
    public void setPosition(Vector3d position) {
        if (MathTools.equals((Tuple3d)position, (Tuple3d)this.getPosition())) {
            return;
        }
        super.setPosition(position);
        for (Nozzle n : this.getChild()) {
            n.getControlPoint()._setWorldPosition(n.getWorldPosition());
            n.getControlPoint()._setWorldOrientation(n.getWorldOrientation());
        }
        for (Nozzle n : this.getChild()) {
            try {
                PipingRules.requestUpdate(n.getControlPoint());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setOrientation(Quat4d orientation) {
        if (MathTools.equals((Tuple4d)orientation, (Tuple4d)this.getOrientation())) {
            return;
        }
        super.setOrientation(orientation);
        for (Nozzle n : this.getChild()) {
            n.getControlPoint()._setWorldPosition(n.getWorldPosition());
            n.getControlPoint()._setWorldOrientation(n.getWorldOrientation());
        }
        for (Nozzle n : this.getChild()) {
            try {
                PipingRules.requestUpdate(n.getControlPoint());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

