/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.PartNameListener;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.g3d.property.PropertyTabContributor;
import org.simantics.g3d.property.PropertyTabUtil;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.tools.AdaptationUtils;
import org.simantics.objmap.structural.StructuralResource;
import org.simantics.selectionview.BasicPropertyTab;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.PropertyTabContributorImpl;
import org.simantics.selectionview.SelectionProcessor;
import vtk.vtkProp;

public class P3DSelectionProcessor
implements SelectionProcessor<Object, ReadGraph> {
    private static final boolean DEBUG = false;

    public Collection<?> process(Object selection, ReadGraph backend) {
        ArrayList<ComparableTabContributor> result = new ArrayList<ComparableTabContributor>();
        Collection resourceCollection = AdaptationUtils.adaptToCollection((Object)selection, Resource.class);
        Collection structuralResourceCollection = AdaptationUtils.adaptToCollection((Object)selection, StructuralResource.class);
        Collection propCollection = AdaptationUtils.adaptToCollection((Object)selection, vtkProp.class);
        Collection nodeCollection = AdaptationUtils.adaptToCollection((Object)selection, INode.class);
        boolean readOnly = false;
        if (resourceCollection.size() == 0 && structuralResourceCollection.size() > 0) {
            for (StructuralResource sr : structuralResourceCollection) {
                if (sr.isStructural() && !sr.isStructuralRoot()) {
                    readOnly = true;
                }
                resourceCollection.add(sr.getResource());
            }
        }
        if (nodeCollection.size() == 1) {
            INode node = (INode)nodeCollection.iterator().next();
            List contributors = PropertyTabUtil.getContributors((Object)node);
            int i = 100;
            for (PropertyTabContributor c : contributors) {
                result.add(new ComparableTabContributor((org.simantics.selectionview.PropertyTabContributor)c, (double)i--, (Object)node, c.getId()));
            }
        }
        if (resourceCollection.size() == 1) {
            try {
                Resource r = (Resource)resourceCollection.iterator().next();
                result.add(new ComparableTabContributor((org.simantics.selectionview.PropertyTabContributor)new P3DBasicPropertyTab(!readOnly), 0.0, (Object)r, "Properties"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (result.size() == 0) {
            result.add(new ComparableTabContributor((org.simantics.selectionview.PropertyTabContributor)new NoneSelectionTabContributor(), 0.0, (Object)resourceCollection, "Empty"));
        }
        return result;
    }

    public class MultiSelectionTabContibutor
    extends PropertyTabContributorImpl {
        public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        }

        public Read<String> getPartNameReadRequest(ISelection forSelection) {
            final Collection coll = AdaptationUtils.adaptToCollection((Object)forSelection, Resource.class);
            if (coll.size() == 0) {
                return null;
            }
            return new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    String title = "";
                    for (Resource r : coll) {
                        title = String.valueOf(title) + NameUtils.getSafeName((ReadGraph)graph, (Resource)r) + ",";
                    }
                    System.out.println(title);
                    return title.substring(0, title.length() - 1);
                }
            };
        }
    }

    public class NoneSelectionTabContributor
    extends PropertyTabContributorImpl {
        public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        }

        public void updatePartName(ISelection forSelection, Consumer<String> updateCallback) {
            updateCallback.accept("No Selection");
        }
    }

    public class P3DBasicPropertyTab
    extends BasicPropertyTab {
        boolean enabled;

        public P3DBasicPropertyTab(boolean enabled) {
            this.enabled = enabled;
        }

        public void updatePartName(ISelection forSelection, Consumer<String> updateCallback) {
            Read<String> read = this.getPartNameReadRequest(forSelection);
            if (read == null) {
                updateCallback.accept("Override to control part name (PropertyTabContributorImpl.updatePartName)");
            } else {
                Simantics.getSession().asyncRequest(read, (Listener)new PartNameListener(updateCallback));
            }
        }

        public Read<String> getPartNameReadRequest(ISelection forSelection) {
            final Resource r = (Resource)AdaptationUtils.adaptToSingle((Object)forSelection, Resource.class);
            if (r == null) {
                return null;
            }
            return new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    return NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
                }
            };
        }

        public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
            super.createControls(body, site, context, support);
            ((Composite)this.parameterExplorer.getExplorerControl()).setEnabled(this.enabled);
        }
    }
}

