/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.geometry;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jcae.opencascade.jni.BRepBuilderAPI_MakeEdge;
import org.jcae.opencascade.jni.BRepBuilderAPI_MakeFace;
import org.jcae.opencascade.jni.BRepBuilderAPI_MakeWire;
import org.jcae.opencascade.jni.BRepPrimAPI_MakeRevol;
import org.jcae.opencascade.jni.GC_MakeArcOfCircle;
import org.jcae.opencascade.jni.GC_MakeSegment;
import org.jcae.opencascade.jni.TopoDS_Edge;
import org.jcae.opencascade.jni.TopoDS_Face;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.jcae.opencascade.jni.TopoDS_Wire;
import org.simantics.db.Resource;
import org.simantics.g3d.math.MathTools;
import org.simantics.plant3d.geometry.BuiltinGeometryProvider;

public class CapGeometryProvider
extends BuiltinGeometryProvider {
    private double radius = 0.01;

    public CapGeometryProvider(Resource resource) {
        super(resource);
    }

    public Collection<TopoDS_Shape> getModel() throws Exception {
        if (this.radius < MathTools.NEAR_ZERO) {
            return Collections.emptyList();
        }
        double length = this.radius * 0.5;
        double[] p0 = new double[]{length, 0.0, 0.0};
        double[] p1 = new double[]{length * 0.8, this.radius * 0.6, 0.0};
        double[] p2 = new double[]{length * 0.5, this.radius, 0.0};
        double[] p3 = new double[]{0.0, this.radius, 0.0};
        double[] p4 = new double[]{0.0, 0.0, 0.0};
        GC_MakeArcOfCircle m1 = new GC_MakeArcOfCircle(p0, p1, p2);
        GC_MakeSegment s1 = new GC_MakeSegment(p2, p3);
        GC_MakeSegment s2 = new GC_MakeSegment(p3, p4);
        BRepBuilderAPI_MakeEdge edge = new BRepBuilderAPI_MakeEdge(m1.value());
        TopoDS_Edge e1 = (TopoDS_Edge)edge.shape();
        edge.delete();
        edge = new BRepBuilderAPI_MakeEdge(s1.value());
        TopoDS_Edge e2 = (TopoDS_Edge)edge.shape();
        edge.delete();
        edge = new BRepBuilderAPI_MakeEdge(s2.value());
        TopoDS_Edge e3 = (TopoDS_Edge)edge.shape();
        edge.delete();
        BRepBuilderAPI_MakeWire wire = new BRepBuilderAPI_MakeWire(e1, e2, e3);
        TopoDS_Wire w = (TopoDS_Wire)wire.shape();
        wire.delete();
        BRepBuilderAPI_MakeFace face = new BRepBuilderAPI_MakeFace(w);
        TopoDS_Face F = (TopoDS_Face)face.shape();
        face.delete();
        BRepPrimAPI_MakeRevol revol = new BRepPrimAPI_MakeRevol((TopoDS_Shape)F, new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0});
        TopoDS_Shape shape = revol.shape();
        revol.delete();
        m1.delete();
        s1.delete();
        s2.delete();
        e1.delete();
        e2.delete();
        e3.delete();
        w.delete();
        F.delete();
        return Collections.singletonList(shape);
    }

    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("radius")) {
            this.radius = (Double)props.get("radius");
        }
        if (this.radius < MathTools.NEAR_ZERO) {
            this.radius = MathTools.NEAR_ZERO;
        }
    }

    @Override
    public void updateCalculatedProperties(Map<String, Object> returnProps) {
        returnProps.put("length", this.radius * 4.0);
    }
}

