/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.NodeMap;
import org.simantics.g3d.scenegraph.RenderListener;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.toolbar.ToolComposite;
import org.simantics.g3d.vtk.action.RemoveAction;
import org.simantics.g3d.vtk.action.vtkAction;
import org.simantics.g3d.vtk.common.HoverHighlighter;
import org.simantics.g3d.vtk.common.NodeSelectionProvider2;
import org.simantics.g3d.vtk.common.SelectionHighlighter;
import org.simantics.g3d.vtk.common.VTKNodeMap;
import org.simantics.g3d.vtk.common.VTKSelectionItem;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.shape.vtkShape;
import org.simantics.g3d.vtk.swt.ContextMenuListener;
import org.simantics.g3d.vtk.swt.FocusAction;
import org.simantics.g3d.vtk.swt.InteractiveVtkComposite;
import org.simantics.g3d.vtk.swt.RotateAction;
import org.simantics.g3d.vtk.swt.TranslateAction;
import org.simantics.g3d.vtk.swt.vtkCameraAndSelectorAction;
import org.simantics.g3d.vtk.utils.AxesDisplay;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.graph.Mappings;
import org.simantics.objmap.graph.schema.IMappingSchema;
import org.simantics.plant3d.actions.AddComponentAction;
import org.simantics.plant3d.actions.AddEquipmentAction;
import org.simantics.plant3d.actions.AddNozzleAction;
import org.simantics.plant3d.actions.RemoveAndSplitAction;
import org.simantics.plant3d.actions.ReversePipeRunAction;
import org.simantics.plant3d.actions.RoutePipeAction;
import org.simantics.plant3d.actions.TranslateFreeVariableLengthAction;
import org.simantics.plant3d.actions.TranslateInlineAction;
import org.simantics.plant3d.editor.P3DContentOutlinePage;
import org.simantics.plant3d.editor.P3DNodeMap;
import org.simantics.plant3d.scenegraph.EndComponent;
import org.simantics.plant3d.scenegraph.Equipment;
import org.simantics.plant3d.scenegraph.IP3DNode;
import org.simantics.plant3d.scenegraph.InlineComponent;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.SchemaBuilder;
import org.simantics.plant3d.scenegraph.TurnComponent;
import org.simantics.plant3d.scenegraph.controlpoint.ControlPointFactory;
import org.simantics.plant3d.scenegraph.controlpoint.PipingRules;
import org.simantics.plant3d.utils.ComponentUtils;
import org.simantics.plant3d.utils.Item;
import org.simantics.plant3d.utils.P3DUtil;
import org.simantics.selectionview.StandardPropertyPage;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorPart;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ExceptionUtils;
import vtk.vtkActor;
import vtk.vtkCameraPass;
import vtk.vtkDefaultPass;
import vtk.vtkGaussianBlurPass;
import vtk.vtkLightsPass;
import vtk.vtkObjectBase;
import vtk.vtkProp;
import vtk.vtkRenderPass;
import vtk.vtkRenderPassCollection;
import vtk.vtkRenderer;
import vtk.vtkSSAAPass;
import vtk.vtkSequencePass;
import vtk.vtkSimpleMotionBlurPass;

public class Plant3DEditor
extends ResourceEditorPart {
    private Composite parent;
    protected ToolComposite toolComposite;
    private Resource input;
    private InteractiveVtkComposite panel;
    private P3DRootNode rootNode;
    private IMapping<Resource, INode> mapping;
    protected NodeSelectionProvider2<Resource, INode> selectionProvider;
    protected vtkCameraAndSelectorAction cameraAction;
    protected FocusAction focusAction;
    protected TranslateAction translateAction;
    protected TranslateInlineAction translateInlineAction;
    protected TranslateFreeVariableLengthAction translateFreeVariableLengthAction;
    protected RotateAction rotateAction;
    protected RemoveAction removeAction;
    protected RemoveAndSplitAction removeSplitAction;
    protected RoutePipeAction routePipeAction;
    protected AddComponentAction addComponentAction;
    protected ReversePipeRunAction reversePipeRunAction;
    private P3DNodeMap nodeMap;
    protected Menu contextMenu;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        IResourceEditorInput rei = (IResourceEditorInput)this.getEditorInput();
        this.input = rei.getResource();
        this.toolComposite = new ToolComposite(parent, 2048);
        this.toolComposite.setVisible(true);
        this.panel = new InteractiveVtkComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.getPanel().getComponent());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.toolComposite);
        this.hookContextMenu();
        this.createScene();
        new ContextMenuListener(this.panel, this.contextMenu);
        this.cameraAction = this.createCameraAction();
        this.panel.setDefaultAction((vtkAction)this.cameraAction);
        this.panel.useDefaultAction();
        this.panel.setPickType(4);
        try {
            ControlPointFactory.preloadCache(this.getLibraryUri());
            ComponentUtils.preloadCache();
        }
        catch (Exception e) {
            ExceptionUtils.logAndShowError((String)"Cannot open Plant3D editor", (Throwable)e);
            return;
        }
        try {
            this.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    PipingRules.setEnabled(false);
                    IMappingSchema<Resource, INode> schema = Plant3DEditor.this.getSchema(graph);
                    Plant3DEditor.this.mapping = Mappings.createWithListening(schema);
                    Plant3DEditor.this.rootNode = (P3DRootNode)((Object)Plant3DEditor.this.mapping.map(graph, (Object)Plant3DEditor.this.input));
                    try {
                        P3DUtil.finalizeDBLoad(Plant3DEditor.this.rootNode);
                        Plant3DEditor.this.nodeMap = Plant3DEditor.this.createNodeMap(Plant3DEditor.this.getSession(), (IMapping<Resource, INode>)Plant3DEditor.this.mapping, (VtkView)Plant3DEditor.this.panel, Plant3DEditor.this.rootNode);
                    }
                    catch (Exception e) {
                        throw new DatabaseException((Throwable)e);
                    }
                }
            });
            if (this.rootNode == null) {
                throw new RuntimeException("Scenegraph loading failed.");
            }
            this.populate();
            this.selectionProvider = this.createSelectionProvider();
            this.cameraAction.addSelectionChangedListener(this.selectionProvider);
            this.cameraAction.addHoverChangedListener(this.createHoverHighlhighter());
            this.selectionProvider.addSelectionChangedListener(this.createSelectionHighlighter());
            this.getSite().setSelectionProvider(this.selectionProvider);
            this.getSite().getPage().addPostSelectionListener(this.selectionProvider);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Plant3DEditor.this.getSite().getPage().removePostSelectionListener(Plant3DEditor.this.selectionProvider);
                    PipingRules.setEnabled(false);
                    Plant3DEditor.this.nodeMap.delete();
                    PipingRules.setEnabled(true);
                    Plant3DEditor.this.mapping.dispose();
                }
            });
        }
        catch (DatabaseException e1) {
            ExceptionUtils.logAndShowError((String)"Cannot open Plant3D editor", (Throwable)e1);
            return;
        }
        this.createActions();
    }

    protected vtkCameraAndSelectorAction createCameraAction() {
        return new vtkCameraAndSelectorAction(this.panel);
    }

    protected NodeSelectionProvider2<Resource, INode> createSelectionProvider() {
        return new NodeSelectionProvider2((IEditorPart)this, this.mapping, (VTKNodeMap)this.nodeMap);
    }

    protected HoverHighlighter<Resource> createHoverHighlhighter() {
        return new HoverHighlighter((VtkView)this.panel, (VTKNodeMap)this.nodeMap);
    }

    protected SelectionHighlighter<Resource> createSelectionHighlighter() {
        return new SelectionHighlighter((VtkView)this.panel, (VTKNodeMap)this.nodeMap);
    }

    protected String getLibraryUri() {
        return "http://www.simantics.org/Plant3D-0.1/Builtin";
    }

    protected void createActions() {
        this.focusAction = new FocusAction((VtkView)this.panel, this.cameraAction);
        this.translateAction = new TranslateAction(this.panel, (VTKNodeMap)this.nodeMap, this.toolComposite);
        this.translateInlineAction = new TranslateInlineAction(this.panel, (VTKNodeMap<?, ? extends INode>)this.nodeMap, this.toolComposite);
        this.translateFreeVariableLengthAction = new TranslateFreeVariableLengthAction(this.panel, this.getRootNode(), this.toolComposite);
        this.rotateAction = new RotateAction(this.panel, (VTKNodeMap)this.nodeMap, this.toolComposite);
        this.removeAction = new RemoveAction((VTKNodeMap)this.nodeMap);
        this.removeSplitAction = new RemoveAndSplitAction((VTKNodeMap<?, ? extends INode>)this.nodeMap);
        this.routePipeAction = new RoutePipeAction(this.panel, this.rootNode, this.toolComposite);
        this.addComponentAction = new AddComponentAction(this.panel, this.rootNode, this.getLibraryUri());
        this.reversePipeRunAction = new ReversePipeRunAction((VTKNodeMap<?, ? extends INode>)this.nodeMap);
    }

    public void populate() {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.panel.getThreadQueue(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Plant3DEditor.this.nodeMap.populate();
                Plant3DEditor.this.panel.addListener(new RenderListener(){

                    public void preRender() {
                    }

                    public void postRender() {
                        try {
                            P3DUtil.finalizeDBLoad2(Plant3DEditor.this.rootNode);
                            if (Plant3DEditor.this.nodeMap.isRangeModified()) {
                                // empty if block
                            }
                            Plant3DEditor.this.nodeMap.commit("Load sync");
                        }
                        catch (Exception e) {
                            ExceptionUtils.logAndShowError((String)"Failed to load model correctly", (Throwable)e);
                        }
                        Plant3DEditor.this.panel.removeListener((RenderListener)this);
                    }
                });
            }
        });
    }

    protected IMappingSchema<Resource, INode> getSchema(ReadGraph graph) throws DatabaseException {
        IMappingSchema<Resource, INode> schema = SchemaBuilder.getSchema(graph);
        return schema;
    }

    protected P3DNodeMap createNodeMap(Session session, IMapping<Resource, INode> mapping, VtkView panel, P3DRootNode rootNode) {
        return new P3DNodeMap(session, mapping, panel, rootNode);
    }

    public void setFocus() {
        this.panel.getComponent().setFocus();
    }

    private void createScene() {
        vtkRenderer ren1 = this.panel.getRenderer();
        boolean multiPass = false;
        boolean blur = false;
        boolean ssaa = false;
        boolean mblur = false;
        if (multiPass) {
            vtkLightsPass lightsPass = new vtkLightsPass();
            vtkDefaultPass defaultPass = new vtkDefaultPass();
            vtkRenderPassCollection passes = new vtkRenderPassCollection();
            passes.AddItem((vtkRenderPass)lightsPass);
            passes.AddItem((vtkRenderPass)defaultPass);
            vtkSequencePass seq = new vtkSequencePass();
            seq.SetPasses(passes);
            vtkCameraPass cameraPass = new vtkCameraPass();
            cameraPass.SetDelegatePass((vtkRenderPass)seq);
            if (blur) {
                vtkGaussianBlurPass blurPass = new vtkGaussianBlurPass();
                blurPass.SetDelegatePass((vtkRenderPass)cameraPass);
                ren1.SetPass((vtkRenderPass)blurPass);
            } else if (ssaa) {
                vtkSSAAPass ssaaPass = new vtkSSAAPass();
                ssaaPass.SetDelegatePass((vtkRenderPass)cameraPass);
                ren1.SetPass((vtkRenderPass)ssaaPass);
            } else if (mblur) {
                vtkSimpleMotionBlurPass mBlurPass = new vtkSimpleMotionBlurPass();
                mBlurPass.SetDelegatePass((vtkRenderPass)cameraPass);
                ren1.SetPass((vtkRenderPass)mBlurPass);
            } else {
                ren1.SetPass((vtkRenderPass)cameraPass);
            }
        }
        ren1.SetBackground2(1.0, 1.0, 1.0);
        ren1.SetBackground(0.9, 0.9, 0.9);
        ren1.SetGradientBackground(true);
        vtkActor grid = vtkShape.createGridActor((int)8, (double)1.0, (int)2);
        grid.SetPickable(0);
        ren1.AddActor((vtkProp)grid);
        this.panel.addDeletable((vtkObjectBase)grid);
        AxesDisplay axesDisplay = new AxesDisplay((VtkView)this.panel);
        axesDisplay.show();
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Plant3DEditor.this.createContextMenu(manager);
            }
        });
        this.contextMenu = menuMgr.createContextMenu((Control)this.parent);
    }

    protected void createContextMenu(IMenuManager m) {
        List selected = this.selectionProvider.getSelectedNodes();
        List selectedItems = this.selectionProvider.getSelectedItems();
        if (selectedItems.size() > 0) {
            ArrayList<vtkProp> props = new ArrayList<vtkProp>();
            for (VTKSelectionItem i : selectedItems) {
                vtkProp p = (vtkProp)i.getAdapter(vtkProp.class);
                if (p == null) continue;
                props.add(p);
            }
            if (props.size() > 0) {
                this.focusAction.setProps(props);
                m.add((IAction)this.focusAction);
            }
        }
        try {
            if (selected.size() == 0) {
                m.add((IAction)new AddEquipmentAction(this.rootNode, this.getLibraryUri()));
            } else if (selected.size() == 1) {
                PipelineComponent component;
                IP3DNode node = (IP3DNode)selected.get(0);
                if (node instanceof Equipment) {
                    m.add((IAction)this.translateAction);
                    m.add((IAction)this.rotateAction);
                    for (Item eq : P3DUtil.getNozzles(this.getLibraryUri())) {
                        AddNozzleAction add = new AddNozzleAction(this.rootNode, eq);
                        add.setEquipment((Equipment)node);
                        m.add((IAction)add);
                    }
                    m.add((IAction)this.removeAction);
                } else if (node instanceof Nozzle) {
                    Nozzle nozzle = (Nozzle)node;
                    if (!nozzle.isFixed()) {
                        m.add((IAction)this.translateAction);
                        m.add((IAction)this.rotateAction);
                    }
                    m.add((IAction)this.routePipeAction);
                    this.routePipeAction.setComponent(nozzle);
                    this.routePipeAction.setEnabled(nozzle.getNext() == null && nozzle.getPrevious() == null);
                    m.add((IAction)this.addComponentAction);
                    this.addComponentAction.setComponent(nozzle);
                    m.add((IAction)this.removeAction);
                } else if (node instanceof TurnComponent) {
                    m.add((IAction)this.translateAction);
                    component = (TurnComponent)node;
                    m.add((IAction)this.routePipeAction);
                    this.routePipeAction.setComponent(component);
                    this.routePipeAction.setEnabled(component.getNext() == null || component.getPrevious() == null);
                    m.add((IAction)this.addComponentAction);
                    this.addComponentAction.setComponent(component);
                    m.add((IAction)this.removeAction);
                    m.add((IAction)this.removeSplitAction);
                    this.removeSplitAction.setNode((INode)node);
                } else if (node instanceof EndComponent) {
                    m.add((IAction)this.translateAction);
                    m.add((IAction)this.addComponentAction);
                    this.addComponentAction.setComponent((PipelineComponent)node);
                    m.add((IAction)this.removeAction);
                } else if (node instanceof InlineComponent) {
                    component = (InlineComponent)node;
                    if (((InlineComponent)component).isVariableLength()) {
                        m.add((IAction)this.translateFreeVariableLengthAction);
                    } else {
                        m.add((IAction)this.translateInlineAction);
                    }
                    m.add((IAction)this.routePipeAction);
                    this.routePipeAction.setComponent(component);
                    m.add((IAction)this.addComponentAction);
                    this.addComponentAction.setComponent(component);
                    m.add((IAction)this.removeAction);
                    m.add((IAction)this.removeSplitAction);
                    this.removeSplitAction.setNode((INode)node);
                } else if (node instanceof PipeRun) {
                    m.add((IAction)this.reversePipeRunAction);
                    m.add((IAction)this.removeAction);
                    this.reversePipeRunAction.setNode((INode)node);
                } else {
                    m.add((IAction)this.removeAction);
                }
                this.translateAction.setNode((IG3DNode)node);
                this.translateInlineAction.setNode(node);
                this.translateFreeVariableLengthAction.setNode(node);
                this.rotateAction.setNode((IG3DNode)node);
                this.removeAction.setNode((INode)node);
            }
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }

    private IContentOutlinePage createOutline() {
        if (this.rootNode == null || this.selectionProvider == null) {
            return null;
        }
        P3DContentOutlinePage outlinePage = new P3DContentOutlinePage(this.rootNode, this.selectionProvider){

            @Override
            protected void createContextMenu(IMenuManager manager) {
                Plant3DEditor.this.createContextMenu(manager);
            }
        };
        outlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Plant3DEditor.this.selectionProvider.selectionChanged(event);
            }
        });
        return outlinePage;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(IPropertyPage.class)) {
            return adapter.cast(new StandardPropertyPage(this.getSite(), this.getPropertyContexts()));
        }
        if (adapter.isAssignableFrom(ISelectionProvider.class)) {
            return adapter.cast(this.selectionProvider);
        }
        if (adapter.isAssignableFrom(IContentOutlinePage.class)) {
            return adapter.cast(this.createOutline());
        }
        if (adapter.isAssignableFrom(NodeMap.class)) {
            return adapter.cast((Object)this.nodeMap);
        }
        if (adapter.isAssignableFrom(INode.class)) {
            return adapter.cast((Object)this.rootNode);
        }
        if (adapter.isAssignableFrom(IMapping.class)) {
            return adapter.cast(this.mapping);
        }
        if (adapter.isAssignableFrom(VtkView.class)) {
            return adapter.cast(this.panel);
        }
        return (T)super.getAdapter(adapter);
    }

    public Set<String> getPropertyContexts() {
        HashSet<String> result = new HashSet<String>();
        result.add("http://www.simantics.org/Project-1.0/ProjectBrowseContext");
        return result;
    }

    public InteractiveVtkComposite getPanel() {
        return this.panel;
    }

    public P3DRootNode getRootNode() {
        return this.rootNode;
    }

    public IMapping<Resource, INode> getMapping() {
        return this.mapping;
    }

    public P3DNodeMap getNodeMap() {
        return this.nodeMap;
    }
}

