/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.dialog;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.exception.DatabaseException;
import org.simantics.plant3d.dialog.ComponentContentProvider;
import org.simantics.plant3d.dialog.ComponentLabelProvider;
import org.simantics.plant3d.scenegraph.Equipment;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.utils.Item;
import org.simantics.plant3d.utils.P3DUtil;
import org.simantics.utils.ui.ExceptionUtils;

public class EquipmentSelectionDialog
extends Dialog
implements ISelectionChangedListener {
    private ResourceManager resourceManager;
    private String libUri;
    private P3DRootNode root;
    private Item selected;
    private Item selectedNozzle;
    ListViewer equipmentViewer;
    ListViewer nozzleViewer;

    public EquipmentSelectionDialog(Shell parentShell, P3DRootNode root) {
        this(parentShell, root, "http://www.simantics.org/Plant3D-0.1/Builtin");
    }

    public EquipmentSelectionDialog(Shell parentShell, P3DRootNode root, String libUri) {
        super(parentShell);
        this.root = root;
        this.libUri = libUri;
    }

    protected List<Item> getItems(Class c, String libUri) throws DatabaseException {
        if (Equipment.class.equals((Object)c)) {
            return P3DUtil.getEquipments(libUri);
        }
        if (Nozzle.class.equals((Object)c)) {
            return P3DUtil.getNozzles(libUri);
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        EquipmentSelectionDialog.applyDialogFont((Control)composite);
        List<Item> equipment = null;
        List<Item> nozzles = null;
        try {
            equipment = this.getItems(Equipment.class, this.libUri);
            nozzles = this.getItems(Nozzle.class, this.libUri);
        }
        catch (DatabaseException e) {
            Label label = new Label(composite, 0);
            label.setText("Cannot load equipment data: " + e.getMessage());
            ExceptionUtils.logError((Throwable)e);
            return composite;
        }
        ExpandBar expandBar = new ExpandBar(composite, 0);
        ExpandItem equipmentItem = new ExpandItem(expandBar, 0);
        equipmentItem.setText("Equipment");
        this.equipmentViewer = new ListViewer((Composite)expandBar);
        this.equipmentViewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        this.equipmentViewer.setContentProvider((IContentProvider)new ComponentContentProvider());
        ExpandItem nozzleItem = new ExpandItem(expandBar, 0);
        nozzleItem.setText("Nozzles");
        this.nozzleViewer = new ListViewer((Composite)expandBar);
        this.nozzleViewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        this.nozzleViewer.setContentProvider((IContentProvider)new ComponentContentProvider());
        equipmentItem.setControl((Control)this.equipmentViewer.getList());
        nozzleItem.setControl((Control)this.nozzleViewer.getList());
        this.equipmentViewer.setInput(equipment);
        this.nozzleViewer.setInput(nozzles);
        equipmentItem.setHeight(this.equipmentViewer.getList().computeSize((int)-1, (int)-1).y);
        nozzleItem.setHeight(this.nozzleViewer.getList().computeSize((int)-1, (int)-1).y);
        this.equipmentViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.nozzleViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).span(2, 1).applyTo((Control)expandBar);
        GridDataFactory.fillDefaults().minSize(500, 500).hint(500, 500).applyTo((Control)composite);
        return composite;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Item i = (Item)sel.getFirstElement();
        if (i != null) {
            if (event.getSource() == this.equipmentViewer) {
                this.selected = i;
            } else if (event.getSource() == this.nozzleViewer) {
                this.selectedNozzle = i;
            }
        } else if (event.getSource() == this.equipmentViewer) {
            this.selected = i;
        } else if (event.getSource() == this.nozzleViewer) {
            this.selectedNozzle = i;
        }
    }

    public Item getSelected() {
        return this.selected;
    }

    public Item getSelectedNozzle() {
        return this.selectedNozzle;
    }
}

