/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.dialog;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.db.exception.DatabaseException;
import org.simantics.plant3d.Activator;
import org.simantics.plant3d.dialog.ComponentContentProvider;
import org.simantics.plant3d.dialog.ComponentLabelProvider;
import org.simantics.plant3d.scenegraph.EndComponent;
import org.simantics.plant3d.scenegraph.InlineComponent;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.TurnComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import org.simantics.plant3d.utils.Item;
import org.simantics.plant3d.utils.P3DUtil;
import org.simantics.utils.ui.ExceptionUtils;

public class ComponentSelectionDialog
extends Dialog
implements ISelectionChangedListener {
    private ResourceManager resourceManager;
    private String libUri;
    private Item selected;
    private Set<PipeControlPoint.PositionType> allowed;
    private Set<PipeControlPoint.PositionType> filterAllowed;
    private PipelineComponent component;
    private boolean insertAdjustable;
    private boolean lenghtAdjustable;
    private PipeControlPoint.PositionType insertPosition = PipeControlPoint.PositionType.NEXT;
    private Double angle;
    private Double length;
    private Double rotationAngle;
    private Text lengthText;
    private Text angleText;
    private Text rotationAngleText;
    private Double diameter;
    private Double turnRadius;
    private Text diameterText;
    private Text turnRadiusText;
    private Button startButton;
    private Button middleButton;
    private Button endButton;
    private boolean inlineSplit = false;
    ListViewer inlineViewer;
    ListViewer turnViewer;
    ListViewer endViewer;

    public ComponentSelectionDialog(Shell parentShell, Set<PipeControlPoint.PositionType> allowed, PipelineComponent component) {
        this(parentShell, allowed, component, "http://www.simantics.org/Plant3D-0.1/Builtin");
    }

    public ComponentSelectionDialog(Shell parentShell, Set<PipeControlPoint.PositionType> allowed, PipelineComponent component, String libUri) {
        super(parentShell);
        this.allowed = allowed;
        this.component = component;
        this.filterAllowed = new HashSet<PipeControlPoint.PositionType>();
        this.insertAdjustable = component instanceof InlineComponent ? ((InlineComponent)component).isVariableLength() : false;
        this.lenghtAdjustable = false;
        this.libUri = libUri;
    }

    protected List<Item> getItems(Class c, String libUri) throws DatabaseException {
        if (InlineComponent.class.equals((Object)c)) {
            return P3DUtil.getInlines(libUri);
        }
        if (TurnComponent.class.equals((Object)c)) {
            return P3DUtil.getTurns(libUri);
        }
        if (EndComponent.class.equals((Object)c)) {
            return P3DUtil.getEnds(libUri);
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ComponentSelectionDialog.applyDialogFont((Control)composite);
        List<Item> ends = null;
        List<Item> turns = null;
        List<Item> inlines = null;
        try {
            ends = this.getItems(EndComponent.class, this.libUri);
            turns = this.getItems(TurnComponent.class, this.libUri);
            inlines = this.getItems(InlineComponent.class, this.libUri);
        }
        catch (DatabaseException e) {
            Label label = new Label(composite, 0);
            label.setText("Cannot load pipeline components: " + e.getMessage());
            ExceptionUtils.logError((Throwable)e);
            return composite;
        }
        ends = P3DUtil.filterUserComponents(ends);
        turns = P3DUtil.filterUserComponents(turns);
        inlines = P3DUtil.filterUserComponents(inlines);
        ExpandBar expandBar = new ExpandBar(composite, 0);
        ExpandItem inlineItem = new ExpandItem(expandBar, 0);
        inlineItem.setText("Inline");
        this.inlineViewer = new ListViewer((Composite)expandBar);
        this.inlineViewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        this.inlineViewer.setContentProvider((IContentProvider)new ComponentContentProvider());
        ExpandItem turnItem = new ExpandItem(expandBar, 0);
        turnItem.setText("Turn");
        this.turnViewer = new ListViewer((Composite)expandBar);
        this.turnViewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        this.turnViewer.setContentProvider((IContentProvider)new ComponentContentProvider());
        ExpandItem endItem = new ExpandItem(expandBar, 0);
        endItem.setText("End");
        this.endViewer = new ListViewer((Composite)expandBar);
        this.endViewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        this.endViewer.setContentProvider((IContentProvider)new ComponentContentProvider());
        inlineItem.setControl((Control)this.inlineViewer.getList());
        turnItem.setControl((Control)this.turnViewer.getList());
        endItem.setControl((Control)this.endViewer.getList());
        this.inlineViewer.setInput(inlines);
        this.turnViewer.setInput(turns);
        this.endViewer.setInput(ends);
        inlineItem.setHeight(this.inlineViewer.getList().computeSize((int)-1, (int)-1).y);
        turnItem.setHeight(this.turnViewer.getList().computeSize((int)-1, (int)-1).y);
        endItem.setHeight(this.endViewer.getList().computeSize((int)-1, (int)-1).y);
        this.inlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.turnViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.endViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).span(2, 1).applyTo((Control)expandBar);
        GridDataFactory.fillDefaults().minSize(500, 500).hint(500, 500).applyTo((Control)composite);
        Label label = new Label(composite, 0);
        label.setText("Position");
        Composite buttonComposite = new Composite(composite, 0);
        this.startButton = new Button(buttonComposite, 2);
        this.middleButton = new Button(buttonComposite, 2);
        this.endButton = new Button(buttonComposite, 2);
        this.startButton.setImage(this.resourceManager.createImage(Activator.imageDescriptorFromPlugin((String)"org.simantics.plant3d", (String)"icons/insert_start.png")));
        this.middleButton.setImage(this.resourceManager.createImage(Activator.imageDescriptorFromPlugin((String)"org.simantics.plant3d", (String)"icons/insert_middle.png")));
        this.endButton.setImage(this.resourceManager.createImage(Activator.imageDescriptorFromPlugin((String)"org.simantics.plant3d", (String)"icons/insert_end.png")));
        this.startButton.setToolTipText("Overlapping insert");
        this.middleButton.setToolTipText("Cutting insert");
        this.endButton.setToolTipText("Adding insert");
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(buttonComposite);
        this.startButton.setEnabled(false);
        this.middleButton.setEnabled(false);
        this.endButton.setEnabled(false);
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentSelectionDialog.this.updateInsertPosition(PipeControlPoint.PositionType.PREVIOUS);
            }
        });
        this.middleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentSelectionDialog.this.updateInsertPosition(PipeControlPoint.PositionType.SPLIT);
            }
        });
        this.endButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentSelectionDialog.this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
            }
        });
        this.endButton.setSelection(true);
        label = new Label(composite, 0);
        label.setText("Length");
        this.lengthText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label.setText("Angle");
        this.angleText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label.setText("Rotation angle");
        this.rotationAngleText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label.setText("Diameter");
        this.diameterText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label.setText("Turn Radius");
        this.turnRadiusText = new Text(composite, 2052);
        this.lengthText.setEnabled(false);
        this.angleText.setEnabled(false);
        this.rotationAngleText.setEnabled(false);
        this.turnRadiusText.setEnabled(false);
        this.diameterText.setEnabled(false);
        this.lengthText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    ComponentSelectionDialog.this.length = Double.parseDouble(ComponentSelectionDialog.this.lengthText.getText());
                }
                catch (NumberFormatException err) {
                    ComponentSelectionDialog.this.length = null;
                }
                ComponentSelectionDialog.this.validate();
            }
        });
        this.angleText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    ComponentSelectionDialog.this.angle = Double.parseDouble(ComponentSelectionDialog.this.angleText.getText());
                }
                catch (NumberFormatException err) {
                    ComponentSelectionDialog.this.angle = null;
                }
                ComponentSelectionDialog.this.validate();
            }
        });
        this.rotationAngleText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    ComponentSelectionDialog.this.rotationAngle = Double.parseDouble(ComponentSelectionDialog.this.rotationAngleText.getText());
                }
                catch (NumberFormatException err) {
                    ComponentSelectionDialog.this.rotationAngle = null;
                }
                ComponentSelectionDialog.this.validate();
            }
        });
        this.diameterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    ComponentSelectionDialog.this.diameter = Double.parseDouble(ComponentSelectionDialog.this.diameterText.getText());
                }
                catch (NumberFormatException err) {
                    ComponentSelectionDialog.this.diameter = null;
                }
                ComponentSelectionDialog.this.validate();
            }
        });
        this.turnRadiusText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    ComponentSelectionDialog.this.turnRadius = Double.parseDouble(ComponentSelectionDialog.this.turnRadiusText.getText());
                }
                catch (NumberFormatException err) {
                    ComponentSelectionDialog.this.turnRadius = null;
                }
                ComponentSelectionDialog.this.validate();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)this.lengthText);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)this.angleText);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)this.rotationAngleText);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)this.diameterText);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)this.turnRadiusText);
        if (!this.allowed.contains((Object)PipeControlPoint.PositionType.NEXT) && !this.allowed.contains((Object)PipeControlPoint.PositionType.PREVIOUS)) {
            this.turnViewer.getList().setEnabled(false);
            this.endViewer.getList().setEnabled(false);
            this.inlineSplit = true;
        }
        return composite;
    }

    private void updateInsertPosition(PipeControlPoint.PositionType type) {
        if (this.insertPosition == type) {
            return;
        }
        this.endButton.setSelection(type == PipeControlPoint.PositionType.NEXT);
        this.middleButton.setSelection(type == PipeControlPoint.PositionType.SPLIT);
        this.startButton.setSelection(type == PipeControlPoint.PositionType.PREVIOUS);
        this.insertPosition = type;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Item i = (Item)sel.getFirstElement();
        if (i != null) {
            this.selected = i;
            if (event.getSource() == this.inlineViewer) {
                this.turnViewer.setSelection((ISelection)new StructuredSelection());
                this.endViewer.setSelection((ISelection)new StructuredSelection());
            } else if (event.getSource() == this.turnViewer) {
                this.inlineViewer.setSelection((ISelection)new StructuredSelection());
                this.endViewer.setSelection((ISelection)new StructuredSelection());
            } else if (event.getSource() == this.endViewer) {
                this.inlineViewer.setSelection((ISelection)new StructuredSelection());
                this.turnViewer.setSelection((ISelection)new StructuredSelection());
            }
            this.validate();
        }
    }

    private void validate() {
        boolean ok;
        HashSet<PipeControlPoint.PositionType> filterAllowed;
        block39: {
            block42: {
                block41: {
                    block40: {
                        block38: {
                            this.filterAllowed.clear();
                            filterAllowed = new HashSet<PipeControlPoint.PositionType>();
                            ok = true;
                            if (this.selected != null) break block38;
                            ok = false;
                            break block39;
                        }
                        if (!this.selected.isCode()) break block40;
                        ok = false;
                        break block39;
                    }
                    boolean bl = this.lenghtAdjustable = this.selected.getType() == Item.Type.INLINE && (this.selected.isVariable() || this.selected.isModifiable());
                    if (!this.insertAdjustable) break block41;
                    switch (this.selected.getType()) {
                        case END: {
                            this.startButton.setEnabled(false);
                            this.middleButton.setEnabled(false);
                            this.endButton.setEnabled(true);
                            this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
                            break;
                        }
                        case INLINE: {
                            if (!this.selected.isVariable()) {
                                this.startButton.setEnabled(true);
                                this.middleButton.setEnabled(true);
                                this.endButton.setEnabled(true);
                                break;
                            }
                            this.startButton.setEnabled(false);
                            this.middleButton.setEnabled(false);
                            this.endButton.setEnabled(true);
                            this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
                            break;
                        }
                        case NOZZLE: {
                            this.startButton.setEnabled(false);
                            this.middleButton.setEnabled(false);
                            this.endButton.setEnabled(true);
                            this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
                            break;
                        }
                        case TURN: {
                            this.startButton.setEnabled(false);
                            this.middleButton.setEnabled(true);
                            this.endButton.setEnabled(true);
                            if (this.insertPosition == PipeControlPoint.PositionType.PREVIOUS) {
                                this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
                                break;
                            }
                            break block42;
                        }
                        case EQUIPMENT: {
                            throw new RuntimeException("Expected component, got equipment " + this.selected);
                        }
                    }
                    break block42;
                }
                if (this.lenghtAdjustable) {
                    if (this.component instanceof InlineComponent) {
                        this.startButton.setEnabled(true);
                        this.middleButton.setEnabled(true);
                        this.endButton.setEnabled(true);
                    } else if (this.component instanceof TurnComponent) {
                        this.startButton.setEnabled(false);
                        this.middleButton.setEnabled(true);
                        this.endButton.setEnabled(true);
                        if (this.insertPosition == PipeControlPoint.PositionType.PREVIOUS) {
                            this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
                        }
                    } else if (this.component instanceof EndComponent || this.component instanceof Nozzle) {
                        this.startButton.setEnabled(false);
                        this.middleButton.setEnabled(false);
                        this.endButton.setEnabled(true);
                        this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
                    }
                } else {
                    this.startButton.setEnabled(false);
                    this.middleButton.setEnabled(false);
                    this.endButton.setEnabled(true);
                }
            }
            if (this.selected.isVariable() || this.selected.isModifiable()) {
                if (this.selected.getType() == Item.Type.INLINE) {
                    filterAllowed.add(PipeControlPoint.PositionType.NEXT);
                    filterAllowed.add(PipeControlPoint.PositionType.PREVIOUS);
                    if (this.inlineSplit && this.selected.isVariable()) {
                        this.lengthText.setEnabled(false);
                        this.angleText.setEnabled(false);
                        this.rotationAngleText.setEnabled(this.selected.isRotated());
                        ok = false;
                    } else {
                        this.lengthText.setEnabled(true);
                        this.angleText.setEnabled(false);
                        this.rotationAngleText.setEnabled(this.selected.isRotated());
                        if (this.length == null) {
                            ok = false;
                        }
                    }
                } else if (this.selected.getType() == Item.Type.TURN) {
                    filterAllowed.add(PipeControlPoint.PositionType.NEXT);
                    filterAllowed.add(PipeControlPoint.PositionType.PREVIOUS);
                    this.lengthText.setEnabled(false);
                    this.angleText.setEnabled(true);
                    this.rotationAngleText.setEnabled(true);
                    if (this.angle == null) {
                        ok = false;
                    }
                } else {
                    this.lengthText.setEnabled(false);
                    this.angleText.setEnabled(false);
                    this.rotationAngleText.setEnabled(false);
                }
            } else {
                this.lengthText.setEnabled(false);
                this.angleText.setEnabled(false);
                this.rotationAngleText.setEnabled(this.selected.getType() == Item.Type.TURN || this.selected.isRotated());
            }
            if (this.selected.isSizeChange()) {
                this.turnRadiusText.setEnabled(true);
                this.diameterText.setEnabled(true);
                if (this.diameter == null || this.turnRadius == null) {
                    ok = false;
                }
            } else {
                this.turnRadiusText.setEnabled(false);
                this.diameterText.setEnabled(false);
            }
            if (!this.selected.isVariable()) {
                switch (this.selected.getType()) {
                    case END: {
                        filterAllowed.add(PipeControlPoint.PositionType.NEXT);
                        filterAllowed.add(PipeControlPoint.PositionType.PREVIOUS);
                        break;
                    }
                    case EQUIPMENT: 
                    case NOZZLE: {
                        break;
                    }
                    case INLINE: {
                        filterAllowed.add(PipeControlPoint.PositionType.NEXT);
                        filterAllowed.add(PipeControlPoint.PositionType.PREVIOUS);
                        filterAllowed.add(PipeControlPoint.PositionType.SPLIT);
                    }
                    case TURN: {
                        filterAllowed.add(PipeControlPoint.PositionType.NEXT);
                        filterAllowed.add(PipeControlPoint.PositionType.PREVIOUS);
                    }
                }
            }
        }
        for (PipeControlPoint.PositionType t : filterAllowed) {
            if (!this.allowed.contains((Object)t)) continue;
            this.filterAllowed.add(t);
        }
        this.getButton(0).setEnabled(ok);
    }

    public Item getSelected() {
        return this.selected;
    }

    public Double getAngle() {
        return this.angle;
    }

    public Double getLength() {
        return this.length;
    }

    public Double getRotationAngle() {
        return this.rotationAngle;
    }

    public Double getDiameter() {
        return this.diameter;
    }

    public Double getTurnRadius() {
        return this.turnRadius;
    }

    public Set<PipeControlPoint.PositionType> filterAllowed() {
        return this.filterAllowed;
    }

    public PipeControlPoint.PositionType getInsertPosition() {
        return this.insertPosition;
    }

    public boolean isInsertAdjustable() {
        return this.insertAdjustable;
    }

    public boolean isLenghtAdjustable() {
        return this.lenghtAdjustable;
    }
}

