/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.actions;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.math.Ray;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.toolbar.ToolComposite;
import org.simantics.g3d.vtk.common.VTKNodeMap;
import org.simantics.g3d.vtk.swt.InteractiveVtkComposite;
import org.simantics.g3d.vtk.swt.TranslateAction;
import org.simantics.g3d.vtk.utils.vtkUtil;
import org.simantics.plant3d.Activator;
import org.simantics.plant3d.scenegraph.InlineComponent;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import vtk.vtkRenderer;

public class TranslateInlineAction
extends TranslateAction {
    private boolean inline;
    private Vector3d s;
    private Vector3d e;
    private Vector3d dir;

    public TranslateInlineAction(InteractiveVtkComposite panel, VTKNodeMap<?, ? extends INode> nodeMap, ToolComposite toolComposite) {
        super(panel, nodeMap, toolComposite);
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/arrow_refresh.png"));
    }

    public void setNode(IG3DNode node) {
        super.setNode(node);
        if (node instanceof InlineComponent) {
            InlineComponent comp = (InlineComponent)node;
            if (comp.isVariableLength()) {
                this.setEnabled(false);
            } else if (comp.getNext() == null || comp.getPrevious() == null) {
                this.setEnabled(true);
                this.inline = false;
                this.dir = comp.getControlPoint().getInlineDir();
                this.dir.normalize();
            } else {
                this.setEnabled(true);
                this.inline = true;
                PipelineComponent prev = comp.getPrevious();
                PipelineComponent next = comp.getNext();
                if (prev == null || next == null) {
                    this.setEnabled(false);
                    return;
                }
                if (prev.getControlPoint().isInline() && !prev.getControlPoint().isFixedLength() && prev.getPrevious() != null) {
                    prev = prev.getPrevious();
                }
                if (next.getControlPoint().isInline() && !next.getControlPoint().isFixedLength() && next.getNext() != null) {
                    next = next.getNext();
                }
                Point3d ns = new Point3d();
                Point3d ne = new Point3d();
                Point3d ps = new Point3d();
                Point3d pe = new Point3d();
                next.getEnds((Tuple3d)ns, (Tuple3d)ne);
                prev.getEnds((Tuple3d)ps, (Tuple3d)pe);
                this.dir = comp.getControlPoint().getInlineDir();
                Vector3d wp = node.getWorldPosition();
                this.s = prev.getControlPoint().isVariableLength() ? MathTools.closestPointOnStraight((Tuple3d)ps, (Tuple3d)wp, (Vector3d)this.dir) : MathTools.closestPointOnStraight((Tuple3d)pe, (Tuple3d)wp, (Vector3d)this.dir);
                this.e = next.getControlPoint().isVariableLength() ? MathTools.closestPointOnStraight((Tuple3d)ne, (Tuple3d)wp, (Vector3d)this.dir) : MathTools.closestPointOnStraight((Tuple3d)ns, (Tuple3d)wp, (Vector3d)this.dir);
                double l = comp.getControlPoint().getInlineLength();
                Vector3d ld = new Vector3d(this.dir);
                ld.scale(l);
                this.s.add((Tuple3d)ld);
                this.e.sub((Tuple3d)ld);
            }
        } else {
            this.setEnabled(false);
        }
    }

    protected void createTools(ToolComposite toolComposite) {
    }

    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.panel.useDefaultAction();
        }
        if (!this.inline) {
            return super.keyPressed(e);
        }
        if (this.valid) {
            return true;
        }
        this.update();
        return true;
    }

    public void setWorldCoord(boolean b) {
    }

    public boolean mouseDragged(MouseEvent e) {
        if (e.getButton() == 1 && this.valid) {
            if (this.inline) {
                Vector3d translate = this.getTranslate(e.getX(), e.getY(), this.prevTranslate);
                if (translate == null) {
                    return true;
                }
                Vector3d pos = new Vector3d(this.node.getWorldPosition());
                pos.set((Tuple3d)translate);
                this.setWorldPos(pos);
                this.update();
            } else {
                super.mouseDragged(e);
            }
        } else {
            this.getDefaultAction().mouseDragged(e);
            this.update();
        }
        return true;
    }

    protected Vector3d getTranslate(double x, double y, Vector3d offset) {
        Ray ray = vtkUtil.createMouseRay((vtkRenderer)this.panel.getRenderer(), (double)x, (double)y);
        Vector3d p = this.node.getWorldPosition();
        if (this.inline) {
            Vector3d i1 = new Vector3d();
            Vector3d i2 = new Vector3d();
            double[] mu = new double[2];
            MathTools.intersectStraightStraight((Tuple3d)p, (Vector3d)this.dir, (Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)i2, (Tuple3d)i1, (double[])mu);
            Vector3d t = MathTools.closestPointOnEdge((Vector3d)i1, (Vector3d)this.s, (Vector3d)this.e);
            return t;
        }
        return super.getTranslate(x, y, offset);
    }
}

