/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.actions;

import org.eclipse.jface.action.Action;
import org.simantics.plant3d.Activator;
import org.simantics.plant3d.scenegraph.Equipment;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.utils.ComponentUtils;
import org.simantics.plant3d.utils.Item;
import org.simantics.utils.ui.ExceptionUtils;

public class AddNozzleAction
extends Action {
    P3DRootNode root;
    private Item item;
    private Equipment equipment;

    public AddNozzleAction(P3DRootNode root, Item item) {
        this.root = root;
        this.item = item;
        this.setText("Add " + item.getName());
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.simantics.plant3d", (String)"icons/Nozzle.png"));
    }

    public void setEquipment(Equipment equipment) {
        this.equipment = equipment;
        int fixedNozzles = equipment.numberOfFixedNozzles();
        if (fixedNozzles > 0) {
            int currentNozzles = equipment.getNodes().size();
            this.setEnabled(currentNozzles < fixedNozzles);
        } else {
            this.setEnabled(true);
        }
    }

    public void run() {
        try {
            Nozzle nozzle = ComponentUtils.createNozzle(this.root, this.equipment, this.item);
            this.root.getNodeMap().commit("Add nozzle " + nozzle.getName());
        }
        catch (Exception e) {
            ExceptionUtils.logAndShowError((String)"Cannot create equipment", (Throwable)e);
        }
    }
}

