/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.opencascade.vtk;

import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.jcae.opencascade.jni.BRepMesh_IncrementalMesh;
import org.jcae.opencascade.jni.BRepPrimAPI_MakeCylinder;
import org.jcae.opencascade.jni.BRep_Tool;
import org.jcae.opencascade.jni.GP_Trsf;
import org.jcae.opencascade.jni.Poly_Triangulation;
import org.jcae.opencascade.jni.TopAbs_Orientation;
import org.jcae.opencascade.jni.TopAbs_ShapeEnum;
import org.jcae.opencascade.jni.TopExp_Explorer;
import org.jcae.opencascade.jni.TopLoc_Location;
import org.jcae.opencascade.jni.TopoDS_Face;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.simantics.opencascade.OCCTTool;
import org.simantics.opencascade.vtk.EdgePointsFilter;
import vtk.vtkActor;
import vtk.vtkAlgorithmOutput;
import vtk.vtkAppendPolyData;
import vtk.vtkAssembly;
import vtk.vtkCleanPolyData;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkFeatureEdges;
import vtk.vtkGlyph3D;
import vtk.vtkIdList;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyDataNormals;
import vtk.vtkProp;
import vtk.vtkProp3D;
import vtk.vtkProp3DCollection;
import vtk.vtkProperty;
import vtk.vtkSphereSource;
import vtk.vtkTriangle;

public class VTKOCCTool {
    public static vtkAssembly vtkTestAssembly() {
        vtkAssembly assemblies = new vtkAssembly();
        vtkPolyData partGrid = VTKOCCTool.createTestPartGrid();
        VTKOCCTool.gridToAssembly(assemblies, partGrid);
        return assemblies;
    }

    public static vtkAssembly vtkOCCShapeToAssembly(TopoDS_Shape shape) {
        double mass;
        double deflection = 0.001;
        if (deflection <= 0.0) {
            deflection = 5.0E-4;
            System.out.println("Bad value for deflection. Using: " + deflection);
        }
        if ((mass = OCCTTool.getMass((TopoDS_Shape)shape)) < 1.0E-12) {
            System.out.println("Non 3D-shape detected");
            System.out.println("The cad import features are currently limited to 3D models.");
        }
        double length = OCCTTool.getBoundingBoxDiagonal((TopoDS_Shape)shape);
        BRepMesh_IncrementalMesh mesh = new BRepMesh_IncrementalMesh(shape, deflection *= length);
        int faceNumber = 0;
        TopExp_Explorer expFace = new TopExp_Explorer();
        vtkAssembly assemblies = new vtkAssembly();
        expFace.init(shape, TopAbs_ShapeEnum.FACE);
        while (expFace.more()) {
            TopoDS_Face face = (TopoDS_Face)expFace.current();
            vtkPolyData partGrid = VTKOCCTool.createPartGrid(face);
            face.delete();
            if (partGrid != null) {
                ++faceNumber;
                VTKOCCTool.gridToAssembly(assemblies, partGrid);
            }
            expFace.next();
        }
        expFace.delete();
        mesh.delete();
        if (faceNumber == 0) {
            System.out.println("Cad import: error: no surface triangulation was generated.");
            return null;
        }
        return assemblies;
    }

    private static void gridToAssembly(vtkAssembly assemblies, vtkPolyData partGrid, vtkAppendPolyData stlSurfaceData, vtkAppendPolyData stlEdgeData) {
        double featureAngle = 30.0;
        vtkDataSetMapper partMapper = new vtkDataSetMapper();
        boolean computeNormals = true;
        boolean cleanPart = true;
        boolean mergePoints = false;
        vtkCleanPolyData partCleaner = new vtkCleanPolyData();
        if (cleanPart) {
            partCleaner.SetInputData((vtkDataObject)partGrid);
            if (mergePoints) {
                partCleaner.PointMergingOn();
            } else {
                partCleaner.PointMergingOff();
            }
        }
        if (computeNormals) {
            vtkPolyDataNormals partNormals = new vtkPolyDataNormals();
            if (cleanPart) {
                partNormals.SetInputConnection(partCleaner.GetOutputPort());
            } else {
                partNormals.SetInputData((vtkDataObject)partGrid);
            }
            partNormals.SetFeatureAngle(featureAngle);
            partMapper.SetInputConnection(partNormals.GetOutputPort());
            partNormals.Delete();
        } else if (cleanPart) {
            partMapper.SetInputConnection(partCleaner.GetOutputPort());
        } else {
            partMapper.SetInputData((vtkDataSet)partGrid);
        }
        partMapper.ScalarVisibilityOn();
        vtkActor partActor = new vtkActor();
        partActor.SetPickable(1);
        partActor.GetProperty().SetColor(1.0, 1.0, 0.0);
        partActor.SetMapper((vtkMapper)partMapper);
        vtkFeatureEdges partEdges = new vtkFeatureEdges();
        if (cleanPart) {
            partEdges.SetInputConnection(partCleaner.GetOutputPort());
        } else {
            partEdges.SetInputData((vtkDataObject)partGrid);
        }
        partEdges.SetFeatureAngle(featureAngle);
        partEdges.FeatureEdgesOn();
        partEdges.BoundaryEdgesOn();
        partEdges.NonManifoldEdgesOn();
        partEdges.ManifoldEdgesOn();
        vtkDataSetMapper partEdgesMapper = new vtkDataSetMapper();
        partEdgesMapper.SetInputConnection(partEdges.GetOutputPort());
        partEdgesMapper.SetResolveCoincidentTopologyToPolygonOffset();
        partEdgesMapper.ScalarVisibilityOff();
        vtkActor partEdgesActor = new vtkActor();
        partEdgesActor.SetPickable(0);
        partEdgesActor.GetProperty().SetColor(1.0, 0.0, 1.0);
        partEdgesActor.SetMapper((vtkMapper)partEdgesMapper);
        if (cleanPart) {
            stlSurfaceData.AddInputData(partCleaner.GetOutput());
        } else {
            stlSurfaceData.AddInputData(partGrid);
        }
        stlEdgeData.AddInputData(partEdges.GetOutput());
        assemblies.AddPart((vtkProp3D)partActor);
        assemblies.AddPart((vtkProp3D)partEdgesActor);
        partEdgesActor.Delete();
        partEdgesMapper.Delete();
        partEdges.Delete();
        partActor.Delete();
        partMapper.Delete();
        partGrid.Delete();
        partCleaner.Delete();
    }

    public static void gridToAssembly(vtkAssembly assemblies, vtkPolyData partGrid) {
        double featureAngle = 30.0;
        vtkDataSetMapper partMapper = new vtkDataSetMapper();
        boolean computeNormals = true;
        boolean cleanPart = false;
        boolean mergePoints = false;
        vtkCleanPolyData partCleaner = new vtkCleanPolyData();
        if (cleanPart) {
            partCleaner.SetInputData((vtkDataObject)partGrid);
            if (mergePoints) {
                partCleaner.PointMergingOn();
            } else {
                partCleaner.PointMergingOff();
            }
        }
        if (computeNormals) {
            vtkAlgorithmOutput out;
            vtkPolyDataNormals partNormals = new vtkPolyDataNormals();
            if (cleanPart) {
                out = partCleaner.GetOutputPort();
                partNormals.SetInputConnection(out);
                out.Delete();
            } else {
                partNormals.SetInputData((vtkDataObject)partGrid);
            }
            partNormals.SetFeatureAngle(featureAngle);
            out = partNormals.GetOutputPort();
            partMapper.SetInputConnection(out);
            out.Delete();
            partNormals.Delete();
        } else if (cleanPart) {
            vtkAlgorithmOutput out = partCleaner.GetOutputPort();
            partMapper.SetInputConnection(out);
            out.Delete();
        } else {
            partMapper.SetInputData((vtkDataSet)partGrid);
        }
        partMapper.ScalarVisibilityOn();
        vtkActor partActor = new vtkActor();
        partActor.SetPickable(1);
        vtkProperty prop = partActor.GetProperty();
        prop.SetColor(1.0, 1.0, 0.0);
        prop.Delete();
        partActor.SetMapper((vtkMapper)partMapper);
        assemblies.AddPart((vtkProp3D)partActor);
        vtkFeatureEdges partEdges = new vtkFeatureEdges();
        if (cleanPart) {
            vtkAlgorithmOutput out = partCleaner.GetOutputPort();
            partEdges.SetInputConnection(out);
            out.Delete();
        } else {
            partEdges.SetInputData((vtkDataObject)partGrid);
        }
        partEdges.FeatureEdgesOn();
        partEdges.BoundaryEdgesOn();
        partEdges.NonManifoldEdgesOn();
        partEdges.ManifoldEdgesOn();
        vtkDataSetMapper partEdgesMapper = new vtkDataSetMapper();
        vtkAlgorithmOutput out = partEdges.GetOutputPort();
        partEdgesMapper.SetInputConnection(out);
        out.Delete();
        partEdgesMapper.SetResolveCoincidentTopologyToPolygonOffset();
        partEdgesMapper.ScalarVisibilityOff();
        vtkActor partEdgesActor = new vtkActor();
        prop = partEdgesActor.GetProperty();
        prop.SetColor(0.0, 0.0, 0.0);
        prop.SetLineWidth(2.0);
        prop.Delete();
        partEdgesActor.SetMapper((vtkMapper)partEdgesMapper);
        partEdgesActor.PickableOn();
        assemblies.AddPart((vtkProp3D)partEdgesActor);
        EdgePointsFilter edgePoints = new EdgePointsFilter();
        out = partEdges.GetOutputPort();
        edgePoints.SetInputConnection(out);
        out.Delete();
        vtkSphereSource sphereSource = new vtkSphereSource();
        vtkGlyph3D glyph3D = new vtkGlyph3D();
        out = sphereSource.GetOutputPort();
        glyph3D.SetSourceConnection(out);
        out.Delete();
        out = edgePoints.GetOutputPort();
        glyph3D.SetInputConnection(out);
        out.Delete();
        glyph3D.SetScaleFactor(0.03);
        glyph3D.Update();
        vtkPolyDataMapper partEdgePointsMapper = new vtkPolyDataMapper();
        out = glyph3D.GetOutputPort();
        partEdgePointsMapper.SetInputConnection(out);
        out.Delete();
        vtkActor edgePointsActor = new vtkActor();
        prop = edgePointsActor.GetProperty();
        prop.SetColor(0.0, 0.0, 1.0);
        prop.Delete();
        edgePointsActor.SetMapper((vtkMapper)partEdgePointsMapper);
        edgePointsActor.PickableOn();
        assemblies.AddPart((vtkProp3D)edgePointsActor);
        edgePointsActor.Delete();
        partEdgePointsMapper.Delete();
        partEdgesActor.Delete();
        partEdgesMapper.Delete();
        partEdges.Delete();
        partActor.Delete();
        partMapper.Delete();
        partGrid.Delete();
        partCleaner.Delete();
    }

    public static vtkPolyData createPartGrid(TopoDS_Face face) {
        TopLoc_Location Location2 = new TopLoc_Location();
        Poly_Triangulation triangulation = BRep_Tool.triangulation((TopoDS_Face)face, (TopLoc_Location)Location2);
        if (triangulation == null) {
            Location2.delete();
            System.out.println("Encountered empty triangulation after face");
            return null;
        }
        boolean reverse = face.orientation() == TopAbs_Orientation.REVERSED;
        int[] triangles = triangulation.triangles();
        double[] nodes = triangulation.nodes();
        int nofTriangles = triangulation.nbTriangles();
        int nofNodes = triangulation.nbNodes();
        triangulation.delete();
        if (nofTriangles < 1) {
            System.out.println("No triangles for mesh on face");
            Location2.delete();
            return null;
        }
        if (nofNodes < 1) {
            System.out.println("No nodes for mesh on face:");
            Location2.delete();
            return null;
        }
        vtkPolyData partGrid = new vtkPolyData();
        partGrid.Allocate(nofTriangles, nofTriangles);
        vtkTriangle triangle = new vtkTriangle();
        vtkIdList list = triangle.GetPointIds();
        int i = 0;
        while (i < nofTriangles) {
            int n2;
            int n1;
            int n0;
            if (!reverse) {
                n0 = triangles[3 * i];
                n1 = triangles[3 * i + 1];
                n2 = triangles[3 * i + 2];
            } else {
                n0 = triangles[3 * i + 2];
                n1 = triangles[3 * i + 1];
                n2 = triangles[3 * i];
            }
            list.SetId(0, n0);
            list.SetId(1, n1);
            list.SetId(2, n2);
            partGrid.InsertNextCell(triangle.GetCellType(), list);
            ++i;
        }
        list.Delete();
        triangle.Delete();
        GP_Trsf transformation = Location2.transformation();
        Location2.delete();
        double[] d_mat = new double[16];
        double[] d_p = new double[3];
        transformation.getValues(d_mat);
        Matrix4d mat = new Matrix4d(d_mat);
        vtkPoints partPoints = new vtkPoints();
        int i2 = 0;
        while (i2 < nofNodes) {
            Point3d p = new Point3d(nodes[3 * i2], nodes[3 * i2 + 1], nodes[3 * i2 + 2]);
            mat.transform(p);
            d_p[0] = p.x;
            d_p[1] = p.y;
            d_p[2] = p.z;
            partPoints.InsertPoint(i2, d_p);
            ++i2;
        }
        transformation.delete();
        partGrid.SetPoints(partPoints);
        partPoints.Delete();
        return partGrid;
    }

    public static vtkPolyData createPartGrid(List<Double> meshPoints, List<Integer> meshTriangles) {
        int nofTriangles = meshTriangles.size() / 3;
        int nofNodes = meshPoints.size() / 3;
        if (nofTriangles < 1) {
            System.out.println("No triangles for mesh on face");
            return null;
        }
        if (nofNodes < 1) {
            System.out.println("No nodes for mesh on face:");
            return null;
        }
        vtkPolyData partGrid = new vtkPolyData();
        partGrid.Allocate(nofTriangles, nofTriangles);
        vtkTriangle triangle = new vtkTriangle();
        vtkIdList list = triangle.GetPointIds();
        int i = 0;
        while (i < nofTriangles) {
            int n0 = meshTriangles.get(3 * i);
            int n1 = meshTriangles.get(3 * i + 1);
            int n2 = meshTriangles.get(3 * i + 2);
            list.SetId(0, n0);
            list.SetId(1, n1);
            list.SetId(2, n2);
            partGrid.InsertNextCell(triangle.GetCellType(), list);
            ++i;
        }
        list.Delete();
        triangle.Delete();
        double[] d_p = new double[3];
        vtkPoints partPoints = new vtkPoints();
        int i2 = 0;
        while (i2 < nofNodes) {
            d_p[0] = meshPoints.get(3 * i2);
            d_p[1] = meshPoints.get(3 * i2 + 1);
            d_p[2] = meshPoints.get(3 * i2 + 2);
            partPoints.InsertPoint(i2, d_p);
            ++i2;
        }
        partGrid.SetPoints(partPoints);
        partPoints.Delete();
        return partGrid;
    }

    private static vtkPolyData createTestPartGrid() {
        int index;
        int j;
        int size = 64;
        double[] nodes = new double[(size + 1) * (size + 1) * 3];
        int[] triangles = new int[3 * size * size * 2];
        double es = 1.0;
        int i = 0;
        while (i <= size) {
            j = 0;
            while (j <= size) {
                index = j * size + i;
                double x = (double)i * es;
                double y = (Math.sin((double)i / (double)size) + Math.sin((double)j / (double)size)) * es;
                double z = (double)j * es;
                nodes[index *= 3] = x;
                nodes[index + 1] = y;
                nodes[index + 2] = z;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            j = 0;
            while (j < size) {
                index = j * size + i;
                index *= 3;
                triangles[index *= 2] = j * (size + 1) + i;
                triangles[index + 1] = j * (size + 1) + i + 1;
                triangles[index + 2] = (j + 1) * (size + 1) + i;
                triangles[index + 3] = (j + 1) * (size + 1) + i;
                triangles[index + 4] = j * (size + 1) + i + 1;
                triangles[index + 5] = (j + 1) * (size + 1) + i + 1;
                ++j;
            }
            ++i;
        }
        int nofTriangles = triangles.length / 3;
        int nofNodes = nodes.length / 3;
        if (nofTriangles < 1) {
            return null;
        }
        if (nofNodes < 1) {
            return null;
        }
        vtkPolyData partGrid = new vtkPolyData();
        partGrid.Allocate(nofTriangles, nofTriangles);
        vtkTriangle triangle = new vtkTriangle();
        vtkIdList list = triangle.GetPointIds();
        int i2 = 0;
        while (i2 < nofTriangles) {
            int n0 = triangles[3 * i2];
            int n1 = triangles[3 * i2 + 1];
            int n2 = triangles[3 * i2 + 2];
            list.SetId(0, n0);
            list.SetId(1, n1);
            list.SetId(2, n2);
            partGrid.InsertNextCell(triangle.GetCellType(), list);
            ++i2;
        }
        list.Delete();
        triangle.Delete();
        vtkPoints partPoints = new vtkPoints();
        int i3 = 0;
        while (i3 < nofNodes) {
            double[] xyz = new double[]{nodes[3 * i3], nodes[3 * i3 + 1], nodes[3 * i3 + 2]};
            partPoints.InsertPoint(i3, xyz);
            ++i3;
        }
        partGrid.SetPoints(partPoints);
        partPoints.Delete();
        return partGrid;
    }

    public static void test() {
        TopoDS_Shape shape = null;
        int t = 0;
        while (t < 5000) {
            vtkAssembly ass;
            int test = 2;
            if (test == 0) {
                ass = VTKOCCTool.vtkOCCShapeToAssembly(shape);
                vtkProp3DCollection col = ass.GetParts();
                int i = 0;
                while (i < col.GetNumberOfItems()) {
                    vtkProp prop = (vtkProp)col.GetItemAsObject(i);
                    prop.Delete();
                    ++i;
                }
                col.Delete();
                ass.Delete();
            } else if (test == 1) {
                ass = new vtkAssembly();
                double vol = OCCTTool.getBoundingBoxDiagonal(shape);
                double d = 0.001 * vol;
                BRepMesh_IncrementalMesh mesh = new BRepMesh_IncrementalMesh(shape, d);
                TopExp_Explorer expFace = new TopExp_Explorer();
                expFace.init(shape, TopAbs_ShapeEnum.FACE);
                while (expFace.more()) {
                    TopoDS_Face face = (TopoDS_Face)expFace.current();
                    vtkPolyData data = VTKOCCTool.createPartGrid(face);
                    VTKOCCTool.gridToAssembly(ass, data);
                    face.delete();
                    expFace.next();
                }
                expFace.delete();
                mesh.delete();
                vtkProp3DCollection col = ass.GetParts();
                int i = 0;
                while (i < col.GetNumberOfItems()) {
                    vtkProp prop = (vtkProp)col.GetItemAsObject(i);
                    prop.Delete();
                    ++i;
                }
                col.Delete();
                ass.Delete();
            } else if (test == 2) {
                double[] pointStruct = new double[]{0.0, 0.0, 0.0};
                double[] dirStruct = new double[]{0.0, 1.0, 0.0};
                double radius = 1.0;
                double height = 1.0;
                double[] axe = new double[6];
                System.arraycopy(pointStruct, 0, axe, 0, 3);
                System.arraycopy(dirStruct, 0, axe, 3, 3);
                BRepPrimAPI_MakeCylinder cyl = new BRepPrimAPI_MakeCylinder(axe, radius, height, Math.PI * 2);
                TopoDS_Shape tds = cyl.shape();
                cyl.delete();
                double vol = OCCTTool.getBoundingBoxDiagonal((TopoDS_Shape)tds);
                double d = 0.001 * vol;
                BRepMesh_IncrementalMesh mesh = new BRepMesh_IncrementalMesh(tds, d);
                mesh.delete();
                tds.delete();
            }
            System.out.println(t);
            ++t;
        }
    }
}

