/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.simantics.g3d.scenegraph.RenderListener;
import org.simantics.g3d.vtk.action.vtkAction;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.swt.vtkSwtAction;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import vtk.rendering.swt.vtkSwtComponent;
import vtk.vtkAbstractPicker;
import vtk.vtkActor2D;
import vtk.vtkActor2DCollection;
import vtk.vtkAreaPicker;
import vtk.vtkAssemblyNode;
import vtk.vtkAssemblyPath;
import vtk.vtkCellPicker;
import vtk.vtkObjectBase;
import vtk.vtkPointPicker;
import vtk.vtkProp;
import vtk.vtkProp3DCollection;
import vtk.vtkPropCollection;
import vtk.vtkPropPicker;
import vtk.vtkRenderWindow;
import vtk.vtkRenderer;
import vtk.vtkScenePicker;

public class InteractiveVtkComposite
extends vtkSwtComponent
implements VtkView {
    Composite parentComposite;
    private boolean updating = false;
    private Object mutex = new Object();
    boolean update = false;
    boolean render = false;
    private List<RenderListener> listeners = new ArrayList<RenderListener>();
    List<RenderListener> list = new ArrayList<RenderListener>();
    private List<vtkObjectBase> deletable = new ArrayList<vtkObjectBase>();
    private vtkSwtAction defaultAction;
    private vtkSwtAction currentAction;
    private vtkScenePicker scenePicker;
    int pickType = 4;

    public InteractiveVtkComposite(Composite parentComposite) {
        super(parentComposite);
        this.parentComposite = parentComposite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.updating) {
                this.updating = true;
                ThreadUtils.asyncExec((IThreadWorkQueue)this.getThreadQueue(), (Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InteractiveVtkComposite.this.parentComposite.isDisposed()) {
                            return;
                        }
                        Object object = InteractiveVtkComposite.this.mutex;
                        synchronized (object) {
                            InteractiveVtkComposite.this.updating = false;
                        }
                        InteractiveVtkComposite.this.update();
                    }
                });
            }
        }
    }

    public void update() {
        if (this.update) {
            return;
        }
        this.update = true;
        super.update();
        this.update = false;
    }

    @Override
    public IThreadWorkQueue getThreadQueue() {
        return SWTThread.getThreadAccess();
    }

    public void Render() {
        if (this.render) {
            return;
        }
        this.render = true;
        this.firePreRender();
        super.Render();
        this.firePostRender();
        this.render = false;
    }

    @Override
    public void addListener(RenderListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(RenderListener l) {
        this.listeners.remove(l);
    }

    private void firePreRender() {
        if (this.listeners.size() > 0) {
            this.list.addAll(this.listeners);
            for (RenderListener l : this.list) {
                l.preRender();
            }
            this.list.clear();
        }
    }

    private void firePostRender() {
        if (this.listeners.size() > 0) {
            this.list.addAll(this.listeners);
            for (RenderListener l : this.list) {
                l.postRender();
            }
            this.list.clear();
        }
    }

    @Override
    public void addDeletable(vtkObjectBase o) {
        this.deletable.add(o);
    }

    @Override
    public void removeDeletable(vtkObjectBase o) {
        this.deletable.remove(o);
    }

    public void Delete() {
        for (vtkObjectBase o : this.deletable) {
            if (o.GetVTKId() == 0L) continue;
            o.Delete();
        }
        this.deletable.clear();
        super.Delete();
    }

    @Override
    public void setActiveAction(vtkAction action) {
        if (((Object)((Object)action)).equals((Object)this.currentAction)) {
            return;
        }
        if (this.currentAction != null) {
            this.currentAction.deattach();
        }
        this.currentAction = (vtkSwtAction)action;
        if (action != null) {
            action.attach();
        }
    }

    @Override
    public void setDefaultAction(vtkAction defaultAction) {
        this.defaultAction = (vtkSwtAction)defaultAction;
    }

    @Override
    public void useDefaultAction() {
        this.setActiveAction(this.defaultAction);
    }

    @Override
    public vtkAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public void lock() {
        this.getVTKLock().lock();
        if (this.getComponent().getContext() != null && !this.getComponent().getContext().isCurrent()) {
            int n = this.getComponent().getContext().makeCurrent();
        }
    }

    @Override
    public void unlock() {
        this.getVTKLock().unlock();
    }

    public int getPickType() {
        return this.pickType;
    }

    public void setPickType(int pickType) {
        this.pickType = pickType;
    }

    public vtkProp[] pick(int x, int y) {
        vtkRenderWindow rw = this.getRenderWindow();
        vtkRenderer ren = this.getRenderer();
        int ax = x;
        int ay = rw.GetSize()[1] - y;
        if (this.pickType == 0) {
            throw new IllegalStateException("SWT Binding does not work with hw picking");
        }
        if (this.pickType == 1) {
            throw new IllegalStateException("SWT Binding does not work with hw picking");
        }
        if (this.pickType == 2) {
            vtkPointPicker picker = new vtkPointPicker();
            picker.SetTolerance(1.0E-5);
            this.lock();
            picker.Pick(new double[]{ax, ay, 0.0}, ren);
            this.unlock();
            vtkAssemblyPath apath = picker.GetPath();
            return this.processPick((vtkAbstractPicker)picker, apath);
        }
        if (this.pickType == 3) {
            vtkAreaPicker picker = new vtkAreaPicker();
            this.lock();
            picker.Pick(new double[]{ax, ay, 0.0}, ren);
            this.unlock();
            vtkAssemblyPath apath = picker.GetPath();
            return this.processPick((vtkAbstractPicker)picker, apath);
        }
        if (this.pickType == 4) {
            vtkCellPicker picker = new vtkCellPicker();
            picker.SetTolerance(1.0E-5);
            this.lock();
            picker.Pick(new double[]{ax, ay, 0.0}, ren);
            this.unlock();
            vtkAssemblyPath apath = picker.GetPath();
            return this.processPick((vtkAbstractPicker)picker, apath);
        }
        if (this.pickType == 5) {
            vtkActor2D a;
            vtkActor2DCollection coll = ren.GetActors2D();
            coll.InitTraversal();
            ArrayList<vtkActor2D> picked = new ArrayList<vtkActor2D>();
            while ((a = coll.GetNextItem()) != null) {
                double[] pos = a.GetPosition();
                double w = a.GetWidth();
                double h = a.GetHeight();
                int minx = (int)(pos[0] - w * 0.5);
                int miny = (int)(pos[1] - h * 0.5);
                int maxx = (int)(pos[0] + w * 0.5);
                int maxy = (int)(pos[1] + h * 0.5);
                if (minx > ax || maxx < ax || miny > ay || maxy < ay) continue;
                picked.add(a);
            }
            return picked.toArray(new vtkProp[picked.size()]);
        }
        return null;
    }

    public vtkProp[] pick2(int x, int y) {
        vtkRenderWindow rw = this.getRenderWindow();
        vtkRenderer ren = this.getRenderer();
        if (this.pickType == 0) {
            vtkPropPicker picker = new vtkPropPicker();
            this.lock();
            picker.PickProp((double)x, (double)(rw.GetSize()[1] - y), ren);
            this.unlock();
            vtkPropCollection coll = picker.GetPickList();
            return this.processPick((vtkAbstractPicker)picker, coll);
        }
        if (this.pickType == 1) {
            if (this.scenePicker == null) {
                this.scenePicker = new vtkScenePicker();
                this.scenePicker.SetRenderer(ren);
                this.scenePicker.EnableVertexPickingOn();
                this.scenePicker.DebugOn();
            }
            this.lock();
            vtkAssemblyPath apath = ren.PickProp((double)x, (double)(rw.GetSize()[1] - y));
            this.unlock();
            if (apath != null) {
                apath.InitTraversal();
                vtkAssemblyNode node = apath.GetLastNode();
                vtkProp test = node.GetViewProp();
                apath.Delete();
                node.Delete();
                return new vtkProp[]{test};
            }
        } else {
            if (this.pickType == 2) {
                vtkPointPicker picker = new vtkPointPicker();
                picker.SetTolerance(2.0 / (double)rw.GetSize()[0]);
                this.lock();
                picker.Pick(new double[]{x, rw.GetSize()[1] - y, 0.0}, ren);
                this.unlock();
                vtkProp3DCollection coll = picker.GetProp3Ds();
                return this.processPick((vtkAbstractPicker)picker, (vtkPropCollection)coll);
            }
            if (this.pickType == 3) {
                vtkAreaPicker picker = new vtkAreaPicker();
                this.lock();
                picker.Pick(new double[]{x, rw.GetSize()[1] - y, 0.0}, ren);
                this.unlock();
                vtkProp3DCollection coll = picker.GetProp3Ds();
                return this.processPick((vtkAbstractPicker)picker, (vtkPropCollection)coll);
            }
            if (this.pickType == 4) {
                vtkCellPicker picker = new vtkCellPicker();
                picker.SetTolerance(2.0 / (double)rw.GetSize()[0]);
                this.lock();
                picker.Pick(new double[]{x, rw.GetSize()[1] - y, 0.0}, ren);
                this.unlock();
                vtkProp3DCollection coll = picker.GetProp3Ds();
                return this.processPick((vtkAbstractPicker)picker, (vtkPropCollection)coll);
            }
        }
        return null;
    }

    private vtkProp[] processPick(vtkAbstractPicker picker, vtkAssemblyPath apath) {
        picker.Delete();
        if (apath != null) {
            apath.InitTraversal();
            vtkProp[] result = new vtkProp[apath.GetNumberOfItems()];
            int i = apath.GetNumberOfItems() - 1;
            while (i >= 0) {
                vtkProp test;
                vtkAssemblyNode node = apath.GetNextNode();
                result[i] = test = node.GetViewProp();
                node.Delete();
                --i;
            }
            apath.Delete();
            return result;
        }
        return null;
    }

    private vtkProp[] processPick(vtkAbstractPicker picker, vtkPropCollection coll) {
        picker.Delete();
        if (coll != null) {
            coll.InitTraversal();
            vtkProp[] result = new vtkProp[coll.GetNumberOfItems()];
            int i = coll.GetNumberOfItems() - 1;
            while (i >= 0) {
                vtkProp test;
                result[i] = test = coll.GetNextProp();
                --i;
            }
            coll.Delete();
            return result;
        }
        return null;
    }
}

