/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.shape;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.shape.Color4d;
import org.simantics.g3d.shape.Cone;
import org.simantics.g3d.shape.Cylinder;
import org.simantics.g3d.shape.Mesh;
import org.simantics.g3d.shape.Sphere;
import org.simantics.g3d.vtk.shape.MeshActor;
import vtk.vtkLinearTransform;
import vtk.vtkMatrix4x4;
import vtk.vtkProp;
import vtk.vtkRenderer;
import vtk.vtkTextActor;

public class axesSphereActor2
extends MeshActor {
    private double axisLength;
    private vtkRenderer ren;
    private vtkTextActor xactor;
    private vtkTextActor yactor;
    private vtkTextActor zactor;
    private boolean labelVisible = false;
    Matrix4d m = new Matrix4d();
    double[] mat = new double[16];
    Point3d x = new Point3d();
    Point3d y = new Point3d();
    Point3d z = new Point3d();

    public axesSphereActor2(vtkRenderer ren, double size) {
        int res = 16;
        this.axisLength = size;
        this.ren = ren;
        Mesh cone_x = Cone.create((double)(size * 0.3), (int)res);
        Mesh cone_y = Cone.create((double)(size * 0.3), (int)res);
        Mesh cone_z = Cone.create((double)(size * 0.3), (int)res);
        cone_x.rotate(MathTools.getQuat((AxisAngle4d)new AxisAngle4d(0.0, 0.0, -1.0, 1.5707963267948966)));
        cone_z.rotate(MathTools.getQuat((AxisAngle4d)new AxisAngle4d(1.0, 0.0, 0.0, 1.5707963267948966)));
        cone_x.translate(new Vector3d(size, 0.0, 0.0));
        cone_y.translate(new Vector3d(0.0, size, 0.0));
        cone_z.translate(new Vector3d(0.0, 0.0, size));
        Mesh tube_x = Cylinder.create((Vector3d)MathTools.ORIGIN, (Vector3d)new Vector3d(size, 0.0, 0.0), (double)(size * 0.1), (int)res);
        Mesh tube_y = Cylinder.create((Vector3d)MathTools.ORIGIN, (Vector3d)new Vector3d(0.0, size, 0.0), (double)(size * 0.1), (int)res);
        Mesh tube_z = Cylinder.create((Vector3d)MathTools.ORIGIN, (Vector3d)new Vector3d(0.0, 0.0, size), (double)(size * 0.1), (int)res);
        Mesh sphere = Sphere.create((double)(size * 0.3), (int)res, (int)(res * 2 / 3));
        Color4d x_col = new Color4d(1.0, 0.0, 0.0, 1.0);
        Color4d y_col = new Color4d(1.0, 1.0, 0.0, 1.0);
        Color4d z_col = new Color4d(0.0, 1.0, 0.0, 1.0);
        Color4d o_col = new Color4d(0.0, 0.0, 1.0, 1.0);
        cone_x.setColor(x_col);
        tube_x.setColor(x_col);
        cone_y.setColor(y_col);
        tube_y.setColor(y_col);
        cone_z.setColor(z_col);
        tube_z.setColor(z_col);
        sphere.setColor(o_col);
        sphere.add(cone_x);
        sphere.add(tube_x);
        sphere.add(cone_y);
        sphere.add(tube_y);
        sphere.add(cone_z);
        sphere.add(tube_z);
        this.setMesh(sphere);
        this.xactor = new vtkTextActor();
        this.yactor = new vtkTextActor();
        this.zactor = new vtkTextActor();
        this.xactor.SetInput("X");
        this.yactor.SetInput("Y");
        this.zactor.SetInput("Z");
        this.xactor.SetTextScaleModeToNone();
        this.yactor.SetTextScaleModeToNone();
        this.zactor.SetTextScaleModeToNone();
        this.xactor.GetTextProperty().SetColor(0.0, 0.0, 0.0);
        this.xactor.GetTextProperty().ShadowOff();
        this.xactor.GetTextProperty().ItalicOff();
        this.xactor.GetTextProperty().BoldOff();
        this.yactor.GetTextProperty().SetColor(0.0, 0.0, 0.0);
        this.yactor.GetTextProperty().ShadowOff();
        this.yactor.GetTextProperty().ItalicOff();
        this.yactor.GetTextProperty().BoldOff();
        this.zactor.GetTextProperty().SetColor(0.0, 0.0, 0.0);
        this.zactor.GetTextProperty().ShadowOff();
        this.zactor.GetTextProperty().ItalicOff();
        this.zactor.GetTextProperty().BoldOff();
        this.xactor.GetTextProperty().Delete();
        this.yactor.GetTextProperty().Delete();
        this.zactor.GetTextProperty().Delete();
        this.xactor.SetMaximumLineHeight(0.25);
        this.yactor.SetMaximumLineHeight(0.25);
        this.zactor.SetMaximumLineHeight(0.25);
        this.xactor.SetPickable(0);
        this.yactor.SetPickable(0);
        this.zactor.SetPickable(0);
    }

    public void setLabelVisibility(boolean ison) {
        if (ison == this.labelVisible) {
            return;
        }
        this.labelVisible = ison;
        if (this.labelVisible) {
            this.ren.AddActor2D((vtkProp)this.xactor);
            this.ren.AddActor2D((vtkProp)this.yactor);
            this.ren.AddActor2D((vtkProp)this.zactor);
            this.updateTextLoc();
        } else {
            this.ren.RemoveActor2D((vtkProp)this.xactor);
            this.ren.RemoveActor2D((vtkProp)this.yactor);
            this.ren.RemoveActor2D((vtkProp)this.zactor);
        }
    }

    private void updateTextLoc() {
        if (!this.labelVisible) {
            return;
        }
        this.xactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.yactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.zactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.GetMatrix(this.mat);
        MathTools.set((Matrix4d)this.m, (double[])this.mat);
        this.x.set(this.axisLength, 0.0, 0.0);
        this.y.set(0.0, this.axisLength, 0.0);
        this.z.set(0.0, 0.0, this.axisLength);
        this.m.transform(this.x);
        this.m.transform(this.y);
        this.m.transform(this.z);
        this.xactor.GetPositionCoordinate().SetValue(this.x.x, this.x.y, this.x.z);
        this.yactor.GetPositionCoordinate().SetValue(this.y.x, this.y.y, this.y.z);
        this.zactor.GetPositionCoordinate().SetValue(this.z.x, this.z.y, this.z.z);
        this.xactor.GetPositionCoordinate().Delete();
        this.yactor.GetPositionCoordinate().Delete();
        this.zactor.GetPositionCoordinate().Delete();
    }

    public void SetOrientation(double id0, double id1, double id2) {
        super.SetOrientation(id0, id1, id2);
        this.updateTextLoc();
    }

    public void RotateWXYZ(double id0, double id1, double id2, double id3) {
        super.RotateWXYZ(id0, id1, id2, id3);
        this.updateTextLoc();
    }

    public void SetPosition(double[] id0) {
        super.SetPosition(id0);
        this.updateTextLoc();
    }

    public void SetPosition(double id0, double id1, double id2) {
        super.SetPosition(id0, id1, id2);
        this.updateTextLoc();
    }

    public void SetOrientation(double[] id0) {
        super.SetOrientation(id0);
        this.updateTextLoc();
    }

    public void SetScale(double id0) {
        super.SetScale(id0);
        this.updateTextLoc();
    }

    public void SetScale(double id0, double id1, double id2) {
        super.SetScale(id0, id1, id2);
        this.updateTextLoc();
    }

    public void SetScale(double[] id0) {
        super.SetScale(id0);
        this.updateTextLoc();
    }

    public void SetUserMatrix(vtkMatrix4x4 id0) {
        super.SetUserMatrix(id0);
        this.updateTextLoc();
    }

    public void SetUserTransform(vtkLinearTransform id0) {
        super.SetUserTransform(id0);
        this.updateTextLoc();
    }

    @Override
    public void Delete() {
        this.ren.RemoveActor((vtkProp)this.xactor);
        this.ren.RemoveActor((vtkProp)this.yactor);
        this.ren.RemoveActor((vtkProp)this.zactor);
        this.xactor.Delete();
        this.yactor.Delete();
        this.zactor.Delete();
        super.Delete();
    }
}

