/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.handlers;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import vtk.vtkCamera;
import vtk.vtkRenderer;

public class ParallelPerspectiveHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command command = event.getCommand();
        boolean oldValue = HandlerUtil.toggleCommandState((Command)command);
        final boolean activate = !oldValue;
        IEditorPart ap = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        final VtkView panel = (VtkView)ap.getAdapter(VtkView.class);
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                vtkRenderer ren = panel.getRenderer();
                vtkCamera cam = ren.GetActiveCamera();
                if (activate) {
                    Vector3d focal = new Vector3d(panel.getRenderer().GetActiveCamera().GetFocalPoint());
                    Vector3d pos = new Vector3d(panel.getRenderer().GetActiveCamera().GetPosition());
                    double dist = MathTools.distance((Tuple3d)pos, (Tuple3d)focal);
                    cam.SetParallelScale(dist / 4.0);
                    Vector3d dir = new Vector3d(pos);
                    dir.sub((Tuple3d)focal);
                    dir.normalize();
                    dir.scale(100.0);
                    dir.add((Tuple3d)focal);
                    cam.SetPosition(dir.x, dir.y, dir.z);
                    cam.SetParallelProjection(1);
                    ren.ResetCameraClippingRange();
                } else {
                    double scale = cam.GetParallelScale();
                    cam.SetParallelProjection(0);
                    Vector3d focal = new Vector3d(panel.getRenderer().GetActiveCamera().GetFocalPoint());
                    Vector3d pos = new Vector3d(panel.getRenderer().GetActiveCamera().GetPosition());
                    Vector3d dir = new Vector3d(pos);
                    dir.sub((Tuple3d)focal);
                    dir.normalize();
                    dir.scale(scale * 4.0);
                    dir.add((Tuple3d)focal);
                    cam.SetPosition(dir.x, dir.y, dir.z);
                    ren.ResetCameraClippingRange();
                }
                panel.refresh();
            }
        });
        return null;
    }
}

